/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.integration;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.entity.mob.EntityDemonBase;
import WayofTime.bloodmagic.event.SacrificeKnifeUsedEvent;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.integration.WitcheryIntegration;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/integration/BloodMagicIntegration;", "Lnet/msrandom/witchery/integration/WitcheryIntegration;", "()V", "boostBloodPowers", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "health", "", "init", "isDemon", "", "entity", "Lnet/minecraft/entity/Entity;", "reduceMagicPower", "Lnet/minecraft/entity/EntityLivingBase;", "factor", "EventHooks", "IntegrateBloodMagic", "WitcheryResurrected"})
public final class BloodMagicIntegration
extends WitcheryIntegration {
    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHooks());
    }

    @Override
    public void reduceMagicPower(@NotNull EntityLivingBase entity, float factor) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        IntegrateBloodMagic.INSTANCE.reduceMagicPower(entity, factor);
    }

    @Override
    public void boostBloodPowers(@NotNull EntityPlayer player, float health) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        IntegrateBloodMagic.INSTANCE.boostBloodPowers(player, health);
    }

    @Override
    public boolean isDemon(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return entity instanceof EntityDemonBase;
    }

    public BloodMagicIntegration() {
        super("bloodmagic");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/integration/BloodMagicIntegration$EventHooks;", "", "()V", "onSacrificeKnifeUsed", "", "event", "LWayofTime/bloodmagic/event/SacrificeKnifeUsedEvent;", "WitcheryResurrected"})
    public static final class EventHooks {
        @SubscribeEvent
        public final void onSacrificeKnifeUsed(@NotNull SacrificeKnifeUsedEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            EntityPlayer entityPlayer = event.player;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"event.player");
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(entityPlayer);
            VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
            if (transformation.getLevel() > 0) {
                event.shouldDrainHealth = false;
                if (!event.player.world.isRemote) {
                    if (transformation.decreaseBlood(event.healthDrained * 100, true)) {
                        playerEx.sync();
                    } else {
                        event.shouldFillAltar = false;
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/integration/BloodMagicIntegration$IntegrateBloodMagic;", "", "()V", "boostBloodPowers", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "health", "", "reduceMagicPower", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "factor", "WitcheryResurrected"})
    private static final class IntegrateBloodMagic {
        public static final IntegrateBloodMagic INSTANCE;

        public final void reduceMagicPower(@Nullable EntityLivingBase entity, float factor) {
            if (entity instanceof EntityPlayer) {
                int count;
                SoulNetwork soulNetwork;
                SoulNetwork soulNetwork2 = soulNetwork = NetworkHelper.getSoulNetwork((EntityPlayer)((EntityPlayer)entity));
                Intrinsics.checkExpressionValueIsNotNull((Object)soulNetwork2, (String)"soulNetwork");
                int essence = soulNetwork2.getCurrentEssence();
                int i = 5;
                for (count = 5000; essence > count; count *= i++) {
                    if (i != 7) continue;
                    break;
                }
                float multiplier = count;
                if (essence > count) {
                    multiplier = count += 850000;
                    if (essence > count) {
                        count *= 10;
                        multiplier = Integer.MAX_VALUE;
                    }
                }
                float reduction = RangesKt.coerceAtLeast((float)(multiplier * factor), (float)1.0f);
                soulNetwork.setCurrentEssence(RangesKt.coerceAtLeast((int)((int)((float)essence - reduction)), (int)0));
            }
        }

        public final void boostBloodPowers(@Nullable EntityPlayer player, float health) {
            SoulNetwork soulNetwork;
            SoulNetwork soulNetwork2 = soulNetwork = NetworkHelper.getSoulNetwork((EntityPlayer)player);
            Intrinsics.checkExpressionValueIsNotNull((Object)soulNetwork2, (String)"soulNetwork");
            soulNetwork2.setCurrentEssence(soulNetwork.getCurrentEssence() + (int)health * 100);
        }

        private IntegrateBloodMagic() {
        }

        static {
            IntegrateBloodMagic integrateBloodMagic;
            INSTANCE = integrateBloodMagic = new IntegrateBloodMagic();
        }
    }
}

