/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.symbol;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b&\u0018\u00002\u00020\u0001BC\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H&J \u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003H\u0016J\f\u0010'\u001a\u00020(*\u00020\u0011H\u0002R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006)"}, d2={"Lnet/msrandom/witchery/infusion/symbol/ProjectileSymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/SymbolEffect;", "spellCost", "", "curse", "", "fallsToEarth", "hasKnowledge", "cooldown", "isVisible", "(IZZZIZ)V", "color", "getColor", "()I", "setColor", "(I)V", "size", "", "getSize", "()F", "setSize", "(F)V", "timeToLive", "getTimeToLive", "setTimeToLive", "onCollision", "", "world", "Lnet/minecraft/world/World;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "spell", "Lnet/msrandom/witchery/entity/EntitySpellEffect;", "perform", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "level", "toRadians", "", "WitcheryResurrected"})
public abstract class ProjectileSymbolEffect
extends SymbolEffect {
    private int color;
    private float size;
    private int timeToLive;

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final float getSize() {
        return this.size;
    }

    public final void setSize(float f) {
        this.size = f;
    }

    public final int getTimeToLive() {
        return this.timeToLive;
    }

    public final void setTimeToLive(int n) {
        this.timeToLive = n;
    }

    private final double toRadians(float $this$toRadians) {
        return Math.toRadians($this$toRadians);
    }

    @Override
    public void perform(@NotNull World world, @NotNull EntityPlayer player, int level) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        double d = this.toRadians(player.rotationYaw);
        boolean bl = false;
        double d2 = -Math.sin(d);
        d = this.toRadians(player.rotationPitch);
        double d3 = d2;
        bl = false;
        double d4 = Math.cos(d);
        double motionX = d3 * d4;
        double d5 = this.toRadians(player.rotationPitch);
        boolean bl2 = false;
        double motionY = -Math.sin(d5);
        double d6 = this.toRadians(player.rotationYaw);
        boolean bl3 = false;
        double d7 = Math.cos(d6);
        d6 = this.toRadians(player.rotationPitch);
        d3 = d7;
        bl3 = false;
        d4 = Math.cos(d6);
        double motionZ = d3 * d4;
        double d8 = motionX * motionX + motionY * motionY + motionZ * motionZ;
        boolean bl4 = false;
        double speed = Math.sqrt(d8);
        Vec3d look = player.getLook(1.0f);
        EntitySpellEffect entity = new EntitySpellEffect(world, (EntityLivingBase)player, motionX, motionY, motionZ, this, level);
        if (this.timeToLive > 0) {
            entity.setLifeTime(this.timeToLive);
        }
        entity.setLocationAndAngles(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, entity.rotationYaw, entity.rotationPitch);
        entity.setPosition(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ);
        world.playEvent(1016, player.getPosition(), 0);
        entity.accelerationX = motionX / speed * 0.3;
        entity.accelerationY = motionY / speed * 0.3;
        entity.accelerationZ = motionZ / speed * 0.3;
        entity.posX = player.posX + look.x * 1.5;
        entity.posY = player.posY + (double)player.eyeHeight - 0.1 + look.y * 1.5;
        entity.posZ = player.posZ + look.z * 1.5;
        world.spawnEntity((Entity)entity);
    }

    public abstract void onCollision(@NotNull World var1, @NotNull EntityLivingBase var2, @NotNull RayTraceResult var3, @NotNull EntitySpellEffect var4);

    @JvmOverloads
    public ProjectileSymbolEffect(int spellCost, boolean curse, boolean fallsToEarth, boolean hasKnowledge, int cooldown, boolean isVisible) {
        super(spellCost, curse, fallsToEarth, hasKnowledge, cooldown, isVisible);
        this.color = 0xFF0000;
        this.size = 1.0f;
        this.timeToLive = -1;
    }

    public /* synthetic */ ProjectileSymbolEffect(int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 1;
        }
        if ((n3 & 2) != 0) {
            bl = false;
        }
        if ((n3 & 4) != 0) {
            bl2 = false;
        }
        if ((n3 & 8) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = true;
        }
        this(n, bl, bl2, bl3, n2, bl4);
    }

    @JvmOverloads
    public ProjectileSymbolEffect(int spellCost, boolean curse, boolean fallsToEarth, boolean hasKnowledge, int cooldown) {
        this(spellCost, curse, fallsToEarth, hasKnowledge, cooldown, false, 32, null);
    }

    @JvmOverloads
    public ProjectileSymbolEffect(int spellCost, boolean curse, boolean fallsToEarth, boolean hasKnowledge) {
        this(spellCost, curse, fallsToEarth, hasKnowledge, 0, false, 48, null);
    }

    @JvmOverloads
    public ProjectileSymbolEffect(int spellCost, boolean curse, boolean fallsToEarth) {
        this(spellCost, curse, fallsToEarth, false, 0, false, 56, null);
    }

    @JvmOverloads
    public ProjectileSymbolEffect(int spellCost, boolean curse) {
        this(spellCost, curse, false, false, 0, false, 60, null);
    }

    @JvmOverloads
    public ProjectileSymbolEffect(int spellCost) {
        this(spellCost, false, false, false, 0, false, 62, null);
    }

    @JvmOverloads
    public ProjectileSymbolEffect() {
        this(0, false, false, false, 0, false, 63, null);
    }
}

