/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.symbol;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/witchery/infusion/symbol/NoxSymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/SymbolEffect;", "()V", "perform", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "level", "", "WitcheryResurrected"})
public final class NoxSymbolEffect
extends SymbolEffect {
    @Override
    public void perform(@NotNull World world, @NotNull EntityPlayer player, int level) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        for (BlockPos pos : WitcheryUtils.rangeTo(new BlockPos(player.posX - (double)10, player.posY - (double)10, player.posZ - (double)10), new BlockPos(player.posX + (double)10, player.posY + (double)10, player.posZ + (double)10))) {
            IBlockState state = world.getBlockState(pos);
            if (!((double)state.getLightValue((IBlockAccess)world, pos) > 0.8)) continue;
            IBlockState iBlockState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            if (!WitcheryUtils.canBreak(iBlockState) || !WitcheryUtils.isBlockBreakable(world, pos, state)) continue;
            world.setBlockToAir(pos);
            if (state.getBlock().quantityDropped(world.rand) <= 0) continue;
            state.getBlock().dropBlockAsItem(world, pos, state, 0);
        }
    }

    public NoxSymbolEffect() {
        super(50, false, false, false, 0, false, 32, null);
    }
}

