/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.symbol;

import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDoor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockPlanks;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/msrandom/witchery/infusion/symbol/CaveInimicumSymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/ProjectileSymbolEffect;", "()V", "canDeflect", "", "getCanDeflect", "()Z", "onCollision", "", "world", "Lnet/minecraft/world/World;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "spell", "Lnet/msrandom/witchery/entity/EntitySpellEffect;", "WitcheryResurrected"})
public final class CaveInimicumSymbolEffect
extends ProjectileSymbolEffect {
    @Override
    public boolean getCanDeflect() {
        return false;
    }

    @Override
    public void onCollision(@NotNull World world, @NotNull EntityLivingBase caster, @NotNull RayTraceResult hit, @NotNull EntitySpellEffect spell) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)caster, (String)"caster");
        Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
        Intrinsics.checkParameterIsNotNull((Object)((Object)spell), (String)"spell");
        if (hit.typeOfHit == RayTraceResult.Type.BLOCK) {
            SymbolEffect.Companion.applyBlockEffect(world, caster, hit, spell.getEffectLevel(), new BiConsumer<BlockPos, IBlockState>(world, hit){
                final /* synthetic */ World $world;
                final /* synthetic */ RayTraceResult $hit;

                public final void accept(@NotNull BlockPos pos, @NotNull IBlockState state) {
                    Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                    Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                    BlockPos p = pos;
                    Block block = state.getBlock();
                    Block newBlockID = Blocks.AIR;
                    if (block == Blocks.DIRT) {
                        newBlockID = Blocks.STONE;
                    } else if (block == Blocks.GRASS) {
                        newBlockID = Blocks.STONE;
                    } else if (block == Blocks.MYCELIUM) {
                        newBlockID = Blocks.STONE;
                    } else if (block == Blocks.COBBLESTONE) {
                        newBlockID = Blocks.STONE;
                    } else if (block == Blocks.PLANKS) {
                        newBlockID = Blocks.STONE;
                    } else if (block instanceof WitcheryBlockPlanks) {
                        newBlockID = Blocks.STONE;
                    } else if (block == Blocks.STONEBRICK) {
                        newBlockID = Blocks.BRICK_BLOCK;
                    } else if (block == Blocks.SAND) {
                        newBlockID = Blocks.SANDSTONE;
                    } else if (block == Blocks.CLAY) {
                        newBlockID = Blocks.HARDENED_CLAY;
                    } else if (block instanceof BlockDoor && state.getMaterial() != Material.IRON) {
                        if ((BlockDoor.EnumDoorHalf)state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER) {
                            BlockPos blockPos = p.down();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"p.down()");
                            p = blockPos;
                        }
                        this.$world.setBlockToAir(p);
                        this.$world.setBlockToAir(p.up());
                        ItemDoor.placeDoor((World)this.$world, (BlockPos)p, (EnumFacing)this.$hit.sideHit, (Block)((Block)Blocks.IRON_DOOR), (boolean)false);
                    }
                    if (newBlockID != Blocks.AIR) {
                        Block block2 = newBlockID;
                        Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"newBlockID");
                        this.$world.setBlockState(p, block2.getDefaultState());
                    }
                }
                {
                    this.$world = world;
                    this.$hit = rayTraceResult;
                }
            });
        }
    }

    public CaveInimicumSymbolEffect() {
        super(0, false, false, false, 0, false, 63, null);
        this.setColor(0x303030);
        this.setSize(3.0f);
    }
}

