/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.symbol;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.DemonicDamageSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/witchery/infusion/symbol/CarnosaDiemSymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/SymbolEffect;", "()V", "perform", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "level", "", "WitcheryResurrected"})
public final class CarnosaDiemSymbolEffect
extends SymbolEffect {
    @Override
    public void perform(@NotNull World world, @NotNull EntityPlayer player, int level) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        float damage = player.getMaxHealth() * 0.1f;
        player.attackEntityFrom((DamageSource)new DemonicDamageSource((Entity)player), damage);
        player.playSound(SoundEvents.ENTITY_ENDERDRAGON_GROWL, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
        ((WorldServer)world).spawnParticle(EnumParticleTypes.REDSTONE, player.posX, player.posY, player.posZ, 20, 1.0, 2.0, 1.0, 0.0, new int[0]);
        playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), RangesKt.coerceAtMost((int)(playerEx.infusionPower.getCurrentPower() + 10), (int)playerEx.infusionPower.getMaxPower()), playerEx.infusionPower.getMaxPower());
        Infusion.syncPlayer(world, player);
        IntegrationManager.boostBloodPowers(player, damage);
    }

    public CarnosaDiemSymbolEffect() {
        super(1, true, false, true, 0, false, 32, null);
    }
}

