/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.symbol;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.msrandom.witchery.block.entity.WaterContainer;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lnet/msrandom/witchery/infusion/symbol/AguamentiSymbolEffect;", "Lnet/msrandom/witchery/infusion/symbol/ProjectileSymbolEffect;", "()V", "onCollision", "", "world", "Lnet/minecraft/world/World;", "caster", "Lnet/minecraft/entity/EntityLivingBase;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "spell", "Lnet/msrandom/witchery/entity/EntitySpellEffect;", "setBlock", "pos", "Lnet/minecraft/util/math/BlockPos;", "setIfAir", "WitcheryResurrected"})
public final class AguamentiSymbolEffect
extends ProjectileSymbolEffect {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCollision(@NotNull World world, @NotNull EntityLivingBase caster, @NotNull RayTraceResult hit, @NotNull EntitySpellEffect spell) {
        BlockPos blockPos;
        block10: {
            block9: {
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                    Intrinsics.checkParameterIsNotNull((Object)caster, (String)"caster");
                    Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)spell), (String)"spell");
                    if (spell.getEffectLevel() != 1) break block8;
                    WorldProvider worldProvider = world.provider;
                    Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                    if (!worldProvider.isNether()) break block9;
                }
                WorldProvider worldProvider = world.provider;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                if (!worldProvider.isNether() || spell.getEffectLevel() != 3) break block10;
            }
            if (hit.typeOfHit == RayTraceResult.Type.ENTITY) {
                Entity entity = hit.entityHit;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"hit.entityHit");
                BlockPos blockPos2 = entity.getPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"hit.entityHit.position");
                this.setBlock(world, blockPos2);
                return;
            }
            if (hit.typeOfHit != RayTraceResult.Type.BLOCK) return;
            TileEntity container = world.getTileEntity(hit.getBlockPos());
            if (container instanceof WaterContainer) {
                ((WaterContainer)container).fillContainer();
                return;
            }
            BlockPos blockPos3 = hit.getBlockPos().offset(hit.sideHit);
            IBlockState iBlockState = world.getBlockState(hit.getBlockPos());
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(hit.blockPos)");
            Material material = iBlockState.getMaterial();
            Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"world.getBlockState(hit.blockPos).material");
            BlockPos blockPos4 = blockPos3.down(!material.isSolid() && hit.sideHit == EnumFacing.UP ? 1 : 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"hit.blockPos.offset(hit.\u2026 EnumFacing.UP) 1 else 0)");
            this.setBlock(world, blockPos4);
            return;
        }
        WorldProvider worldProvider = world.provider;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        if (worldProvider.isNether()) return;
        if (hit.typeOfHit == RayTraceResult.Type.ENTITY) {
            Entity entity = hit.entityHit;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"hit.entityHit");
            blockPos = entity.getPosition();
        } else {
            blockPos = hit.getBlockPos().offset(hit.sideHit);
        }
        BlockPos pos = blockPos;
        IBlockState iBlockState = world.getBlockState(hit.getBlockPos());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(hit.blockPos)");
        Material material = iBlockState.getMaterial();
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"world.getBlockState(hit.blockPos).material");
        if (material.isSolid() && hit.sideHit == EnumFacing.UP) {
            pos = pos.down();
        }
        BlockPos blockPos5 = pos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"pos");
        this.setBlock(world, blockPos5);
        BlockPos blockPos6 = pos.up();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"pos.up()");
        this.setIfAir(world, blockPos6);
        BlockPos blockPos7 = pos.east();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos7, (String)"pos.east()");
        this.setIfAir(world, blockPos7);
        BlockPos blockPos8 = pos.west();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos8, (String)"pos.west()");
        this.setIfAir(world, blockPos8);
        BlockPos blockPos9 = pos.south();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos9, (String)"pos.south()");
        this.setIfAir(world, blockPos9);
        BlockPos blockPos10 = pos.north();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos10, (String)"pos.north()");
        this.setIfAir(world, blockPos10);
        BlockPos blockPos11 = pos.down();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos11, (String)"pos.down()");
        this.setIfAir(world, blockPos11);
    }

    private final void setBlock(World world, BlockPos pos) {
        if (WitcheryUtils.isBlockBreakable$default(world, pos, null, 2, null)) {
            BlockDynamicLiquid blockDynamicLiquid = Blocks.FLOWING_WATER;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockDynamicLiquid, (String)"Blocks.FLOWING_WATER");
            world.setBlockState(pos, blockDynamicLiquid.getDefaultState());
        }
    }

    private final void setIfAir(World world, BlockPos pos) {
        if (world.isAirBlock(pos)) {
            this.setBlock(world, pos);
        }
    }

    public AguamentiSymbolEffect() {
        super(0, false, false, false, 0, false, 63, null);
        this.setColor(0x11F3FF);
        this.setSize(2.0f);
    }
}

