/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.spirit;

import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.util.EnumParticleTypes;
import net.msrandom.witchery.block.entity.TileEntityFetish;
import net.msrandom.witchery.entity.EntitySpectre;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.EntityUtil;

public class InfusedSpiritSentinelEffect
extends InfusedSpiritEffect {
    @Override
    public int getCooldownTicks() {
        return 600;
    }

    @Override
    public double getRadius() {
        return 8.0;
    }

    @Override
    public boolean doUpdateEffect(TileEntityFetish fetish, boolean alarm, List<EntityLivingBase> entities) {
        if (alarm) {
            int number = entities.size() > 1 ? 1 : 2;
            for (EntityLivingBase entity : entities) {
                for (int i = 0; i < number; ++i) {
                    EntitySpectre creature = (EntitySpectre)Infusion.spawnCreature(fetish.getWorld(), EntitySpectre.class, entity.getPosition(), entity, 1, 1, EnumParticleTypes.SPELL_INSTANT, WitcherySounds.ENTITY_SPECTRE_AMBIENT);
                    if (creature == null) continue;
                    EntityUtil.setTarget((EntityLiving)creature, entity);
                    creature.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)creature, entity.getClass(), 0, true, false, null));
                    creature.setTimeToLive(600);
                    creature.onInitialSpawn(creature.world.getDifficultyForLocation(creature.getPosition()), null);
                }
            }
        }
        return alarm;
    }
}

