/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.spirit;

import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityFetish;
import net.msrandom.witchery.infusion.spirit.SpiritEffectRecipe;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.registry.WitcheryIdentityRegistry;
import net.msrandom.witchery.resources.SpiritEffectManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

public abstract class InfusedSpiritEffect
implements Comparable<InfusedSpiritEffect> {
    public static final WitcheryIdentityRegistry<ResourceLocation, InfusedSpiritEffect> REGISTRY = new WitcheryIdentityRegistry(5);

    public static boolean tryBindFetish(World world, BlockPos position, ItemStack stack, ListMultimap<Class<? extends EntityCreature>, EntityCreature> ghosts) {
        for (SpiritEffectRecipe recipe : SpiritEffectManager.INSTANCE.getEffects()) {
            if (!recipe.matches(ghosts)) continue;
            recipe.getResult().bindFetish(world, position, stack, recipe.getGhosts(), ghosts);
            return true;
        }
        return false;
    }

    public void bindFetish(World world, BlockPos position, ItemStack stack, Object2IntMap<Class<? extends EntityCreature>> requirement, ListMultimap<Class<? extends EntityCreature>, EntityCreature> ghosts) {
        for (Object2IntMap.Entry entry2 : requirement.object2IntEntrySet()) {
            List list2 = ghosts.get(entry2.getKey());
            for (int i = 0; i < list2.size() && i < entry2.getIntValue(); ++i) {
                EntityCreature entity = (EntityCreature)list2.get(i);
                entity.setDead();
                entity.world.playSound(null, entity.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)entity);
            }
        }
        if (this.bindToItem(stack)) {
            EntityItem entity = new EntityItem(world, (double)position.getX() + 0.5, (double)position.getY() + 1.5, (double)position.getZ() + 0.5, stack);
            entity.motionX = 0.0;
            entity.motionY = 0.3;
            entity.motionZ = 0.0;
            world.spawnEntity((Entity)entity);
            entity.world.playSound(null, entity.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 1.5f, EnumParticleTypes.SPELL), (Entity)entity);
        }
    }

    public boolean bindToItem(ItemStack stack) {
        WitcheryUtils.getOrCreateTag(stack).setString("SpiritEffect", ((ResourceLocation)REGISTRY.getKey(this)).toString());
        return true;
    }

    public int getCooldownTicks() {
        return -1;
    }

    public boolean isNearTo(EntityPlayer player) {
        for (TileEntity tile : player.world.loadedTileEntityList) {
            if (!(tile instanceof TileEntityFetish)) continue;
            TileEntityFetish fetish = (TileEntityFetish)tile;
            if (!(player.getDistanceSq(tile.getPos()) <= 256.0) || fetish.getEffect() != this) continue;
            return true;
        }
        return false;
    }

    public boolean isVoodooProtection() {
        return false;
    }

    public boolean doUpdateEffect(TileEntityFetish fetish, boolean alarm, List<EntityLivingBase> entities) {
        return true;
    }

    public boolean isRedstoneSignaller() {
        return false;
    }

    public double getRadius() {
        return 0.0;
    }

    @Override
    public int compareTo(@NotNull InfusedSpiritEffect o) {
        return Integer.compare(REGISTRY.getId(this), REGISTRY.getId(o));
    }
}

