/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.spirit;

import com.google.common.collect.ListMultimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityDeath;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.item.ItemDeathsClothes;
import net.msrandom.witchery.item.ItemDeathsHand;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class InfusedSpiritDeathEffect
extends InfusedSpiritEffect {
    @Override
    public void bindFetish(World world, BlockPos position, ItemStack stack, Object2IntMap<Class<? extends EntityCreature>> requirement, ListMultimap<Class<? extends EntityCreature>, EntityCreature> ghosts) {
        EntityPlayer deathPlayer = this.findDeathPlayer(world);
        if (deathPlayer != null) {
            WitcheryIngredientItem.teleportToLocation(position, world.provider.getDimension(), (Entity)deathPlayer, true);
            deathPlayer.playSound(SoundEvents.ENTITY_WITHER_SPAWN, 0.5f, 0.4f / (deathPlayer.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(deathPlayer.posX, deathPlayer.posY, deathPlayer.posZ, 0.5f, 1.5f, EnumParticleTypes.SPELL_INSTANT), (Entity)deathPlayer);
        } else {
            EntityDeath death = new EntityDeath(world);
            death.setLocationAndAngles((double)position.getX() + 0.5, (double)position.getY() + 0.1, (double)position.getZ() + 0.5, 0.0f, 0.0f);
            death.enablePersistence();
            world.spawnEntity((Entity)death);
            death.playSound(SoundEvents.ENTITY_WITHER_SPAWN, 0.5f, 0.4f / (death.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(death.posX, death.posY, death.posZ, 0.5f, 1.5f, EnumParticleTypes.SPELL_INSTANT), (Entity)death);
        }
    }

    @Override
    public boolean bindToItem(ItemStack stack) {
        return false;
    }

    private EntityPlayer findDeathPlayer(World world) {
        for (EntityPlayer player : world.playerEntities) {
            if (!ItemDeathsClothes.isFullSetWorn((EntityLivingBase)player) || !(player.getHeldItemMainhand().getItem() instanceof ItemDeathsHand) && !(player.getHeldItemOffhand().getItem() instanceof ItemDeathsHand)) continue;
            return player;
        }
        return null;
    }
}

