/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public class SoundCreatureAbility
extends CreatureAbility {
    private final SoundEvent sound;

    public SoundCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, SoundEvent sound) {
        super(serializer);
        this.sound = sound;
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        world.playSound(null, player.getPosition(), this.sound, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<SoundCreatureAbility> {
        @Override
        public SoundCreatureAbility read(JsonObject json) {
            return new SoundCreatureAbility(this, (SoundEvent)SoundEvent.REGISTRY.getObject((Object)new ResourceLocation(json.get("sound").getAsString())));
        }

        @Override
        public SoundCreatureAbility read(PacketBuffer buffer) {
            return new SoundCreatureAbility(this, (SoundEvent)SoundEvent.REGISTRY.getObjectById(buffer.readVarInt()));
        }

        @Override
        public void write(PacketBuffer buffer, SoundCreatureAbility ability) {
            buffer.writeVarInt(SoundEvent.REGISTRY.getIDForObject((Object)ability.sound));
        }
    }
}

