/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public class ShootArrowCreatureAbility
extends CreatureAbility {
    public ShootArrowCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer) {
        super(serializer);
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        if (!world.isRemote) {
            float f = (float)elapsedTicks / 20.0f;
            if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
                f = 1.0f;
            }
            world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, player.getSoundCategory(), 1.0f, 1.0f / (world.rand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            EntityArrow arrow = ((ItemArrow)Items.ARROW).createArrow(world, new ItemStack(Items.ARROW), (EntityLivingBase)player);
            arrow.shoot((Entity)player, player.rotationPitch, player.rotationYaw, 0.0f, f * 3.0f, 1.0f);
            if (f == 1.0f) {
                arrow.setIsCritical(true);
            }
            arrow.setKnockbackStrength(1);
            arrow.setDamage(arrow.getDamage() + 1.0);
            world.spawnEntity((Entity)arrow);
        }
    }
}

