/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public class PotionCreatureAbility
extends CreatureAbility {
    private final Potion potion;
    private final int duration;
    private final int amplifier;

    public PotionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, Potion potion, int duration, int amplifier) {
        super(serializer);
        this.potion = potion;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        player.addPotionEffect(new PotionEffect(this.potion, this.duration, this.amplifier));
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<PotionCreatureAbility> {
        @Override
        public PotionCreatureAbility read(JsonObject json) {
            JsonElement amplifier = json.get("amplifier");
            return new PotionCreatureAbility(this, Potion.getPotionFromResourceLocation((String)json.get("potion").getAsString()), json.get("duration").getAsInt(), amplifier == null ? 0 : amplifier.getAsInt());
        }

        @Override
        public PotionCreatureAbility read(PacketBuffer buffer) {
            return new PotionCreatureAbility(this, Potion.getPotionById((int)buffer.readVarInt()), buffer.readVarInt(), buffer.readVarInt());
        }

        @Override
        public void write(PacketBuffer buffer, PotionCreatureAbility ability) {
            buffer.writeVarInt(Potion.getIdFromPotion((Potion)ability.potion));
            buffer.writeVarInt(ability.duration);
            buffer.writeVarInt(ability.amplifier);
        }
    }
}

