/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.util.WitcheryUtils;

public class LightningRechargeCreatureAbility
extends CreatureAbility {
    private final int increase;

    public LightningRechargeCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int increase) {
        super(serializer);
        this.increase = increase;
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        if (event.getSource() == DamageSource.LIGHTNING_BOLT) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            int maxPower = playerEx.infusionPower.getMaxPower();
            playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), Math.min(playerEx.infusionPower.getCurrentPower() + this.increase, maxPower), maxPower);
            Infusion.syncPlayer(world, player);
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<LightningRechargeCreatureAbility> {
        @Override
        public LightningRechargeCreatureAbility read(JsonObject json) {
            JsonElement increase = json.get("increase");
            return new LightningRechargeCreatureAbility(this, increase == null ? 25 : increase.getAsInt());
        }

        @Override
        public LightningRechargeCreatureAbility read(PacketBuffer buffer) {
            return new LightningRechargeCreatureAbility(this, buffer.readVarInt());
        }

        @Override
        public void write(PacketBuffer buffer, LightningRechargeCreatureAbility ability) {
            buffer.writeVarInt(ability.increase);
        }
    }
}

