/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public abstract class FireballsCreatureAbility
extends CreatureAbility {
    private final int count;

    public FireballsCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int count) {
        super(serializer);
        this.count = count;
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        world.playEvent(1008, player.getPosition(), 0);
        for (int i = 0; i < this.count; ++i) {
            double motionX = -Math.sin(Math.toRadians(player.rotationYaw)) * Math.cos(Math.toRadians(player.rotationPitch));
            double motionY = -Math.sin(Math.toRadians(player.rotationPitch));
            double motionZ = Math.cos(Math.toRadians(player.rotationYaw)) * Math.cos(Math.toRadians(player.rotationPitch));
            EntityFireball fireball = this.makeFireball(world, player, motionX, motionY, motionZ);
            fireball.setLocationAndAngles(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, fireball.rotationYaw, fireball.rotationPitch);
            fireball.setPosition(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ);
            double speed = MathHelper.sqrt((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            fireball.accelerationX = motionX / speed * 0.1;
            fireball.accelerationY = motionY / speed * 0.1;
            fireball.accelerationZ = motionZ / speed * 0.1;
            Vec3d vec3 = player.getLook(1.0f);
            fireball.posX = player.posX + vec3.x;
            fireball.posY = player.posY + (double)(player.height / 2.0f) + 0.5;
            fireball.posZ = player.posZ + vec3.z;
            world.spawnEntity((Entity)fireball);
        }
    }

    protected abstract EntityFireball makeFireball(World var1, EntityPlayer var2, double var3, double var5, double var7);

    public static abstract class Serializer
    implements CreatureAbility.AbilitySerializer<FireballsCreatureAbility> {
        @Override
        public FireballsCreatureAbility read(JsonObject json) {
            JsonElement count = json.get("count");
            return new FireballsCreatureAbility(this, count == null ? 1 : count.getAsInt()){

                @Override
                protected EntityFireball makeFireball(World world, EntityPlayer player, double motionX, double motionY, double motionZ) {
                    return this.makeFireball(world, player, motionX, motionY, motionZ);
                }
            };
        }

        @Override
        public FireballsCreatureAbility read(PacketBuffer buffer) {
            return new FireballsCreatureAbility(this, buffer.readVarInt()){

                @Override
                protected EntityFireball makeFireball(World world, EntityPlayer player, double motionX, double motionY, double motionZ) {
                    return this.makeFireball(world, player, motionX, motionY, motionZ);
                }
            };
        }

        @Override
        public void write(PacketBuffer buffer, FireballsCreatureAbility ability) {
            buffer.writeVarInt(ability.count);
        }

        protected abstract EntityFireball makeFireball(World var1, EntityPlayer var2, double var3, double var5, double var7);
    }
}

