/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.util.WitcheryUtils;

public class FireProtectionCreatureAbility
extends CreatureAbility {
    private final int cost;
    private final int duration;
    private final int amplifier;

    public FireProtectionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int cost, int duration, int amplifier) {
        super(serializer);
        this.cost = cost;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        if (event.getSource().isFireDamage() && event.isCancelable()) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            int currentEnergy = playerEx.infusionPower.getCurrentPower();
            if (currentEnergy >= this.cost && !player.isPotionActive(MobEffects.FIRE_RESISTANCE)) {
                playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), currentEnergy - this.cost, playerEx.infusionPower.getMaxPower());
                player.addPotionEffect(new PotionEffect(MobEffects.FIRE_RESISTANCE, this.duration, this.amplifier));
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<FireProtectionCreatureAbility> {
        @Override
        public FireProtectionCreatureAbility read(JsonObject json) {
            JsonElement cost = json.get("cost");
            JsonElement duration = json.get("duration");
            JsonElement amplifier = json.get("amplifier");
            return new FireProtectionCreatureAbility(this, cost == null ? 3 : cost.getAsInt(), duration == null ? 200 : duration.getAsInt(), amplifier == null ? 0 : amplifier.getAsInt());
        }

        @Override
        public FireProtectionCreatureAbility read(PacketBuffer buffer) {
            return new FireProtectionCreatureAbility(this, buffer.readVarInt(), buffer.readVarInt(), buffer.readVarInt());
        }

        @Override
        public void write(PacketBuffer buffer, FireProtectionCreatureAbility ability) {
            buffer.writeVarInt(ability.cost);
            buffer.writeVarInt(ability.duration);
            buffer.writeVarInt(ability.amplifier);
        }
    }
}

