/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.creature.CreatureAbility;

public class ExplosionCreatureAbility
extends CreatureAbility {
    private final int powerUp;
    private final float radius;

    public ExplosionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int powerUp, float radius) {
        super(serializer);
        this.powerUp = powerUp;
        this.radius = radius;
    }

    @Override
    public int activateCost(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        return elapsedTicks >= this.powerUp ? 1 : 0;
    }

    @Override
    public void onActivate(World world, EntityPlayer player, int elapsedTicks, RayTraceResult mop) {
        if (!world.isRemote) {
            double posX = player.posX;
            double posY = player.posY;
            double posZ = player.posZ;
            world.createExplosion((Entity)player, posX, posY, posZ, this.radius * (float)(elapsedTicks >= this.powerUp ? 2 : 1), world.getGameRules().getBoolean("mobGriefing"));
        }
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<ExplosionCreatureAbility> {
        @Override
        public ExplosionCreatureAbility read(JsonObject json) {
            JsonElement powerUp = json.get("power_up");
            JsonElement radius = json.get("radius");
            return new ExplosionCreatureAbility(this, powerUp == null ? 60 : powerUp.getAsInt(), radius == null ? 3.0f : radius.getAsFloat());
        }

        @Override
        public ExplosionCreatureAbility read(PacketBuffer buffer) {
            return new ExplosionCreatureAbility(this, buffer.readVarInt(), buffer.readFloat());
        }

        @Override
        public void write(PacketBuffer buffer, ExplosionCreatureAbility ability) {
            buffer.writeVarInt(ability.powerUp);
            buffer.writeFloat(ability.radius);
        }
    }
}

