/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.creature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.util.WitcheryUtils;

public class DrownPreventionCreatureAbility
extends CreatureAbility {
    private final int cost;
    private final int duration;
    private final int amplifier;
    private final int air;

    public DrownPreventionCreatureAbility(CreatureAbility.AbilitySerializer<?> serializer, int cost, int duration, int amplifier, int air) {
        super(serializer);
        this.cost = cost;
        this.duration = duration;
        this.amplifier = amplifier;
        this.air = air;
    }

    @Override
    public void onDamage(World world, EntityPlayer player, LivingHurtEvent event) {
        if (!world.isRemote && event.getSource() == DamageSource.DROWN) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            int currentEnergy = playerEx.infusionPower.getCurrentPower();
            if (currentEnergy >= this.cost) {
                playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), currentEnergy - this.cost, playerEx.infusionPower.getMaxPower());
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                player.addPotionEffect(new PotionEffect(MobEffects.WATER_BREATHING, this.duration, this.amplifier));
                player.setAir(this.air);
                event.setCanceled(true);
            }
        }
        super.onDamage(world, player, event);
    }

    public static class Serializer
    implements CreatureAbility.AbilitySerializer<DrownPreventionCreatureAbility> {
        @Override
        public DrownPreventionCreatureAbility read(JsonObject json) {
            JsonElement amplifier = json.get("amplifier");
            return new DrownPreventionCreatureAbility(this, json.get("cost").getAsInt(), json.get("duration").getAsInt(), amplifier == null ? 0 : amplifier.getAsInt(), json.get("air").getAsInt());
        }

        @Override
        public DrownPreventionCreatureAbility read(PacketBuffer buffer) {
            return new DrownPreventionCreatureAbility(this, buffer.readVarInt(), buffer.readVarInt(), buffer.readVarInt(), buffer.readVarInt());
        }

        @Override
        public void write(PacketBuffer buffer, DrownPreventionCreatureAbility ability) {
            buffer.writeVarInt(ability.cost);
            buffer.writeVarInt(ability.duration);
            buffer.writeVarInt(ability.amplifier);
            buffer.writeVarInt(ability.air);
        }
    }
}

