/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.brew;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.RayTraceResult;
import net.msrandom.witchery.infusion.brew.InfusedBrewEffect;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.util.CreatureUtil;

public class InfusedBrewGraveEffect
extends InfusedBrewEffect {
    private static final String LAST_USE_TIME_KEY = "WitcheryBrewGraveTime";
    private static final long COOLDOWN_TICKS = 200L;

    public InfusedBrewGraveEffect() {
        super(16);
    }

    @Override
    public boolean tryUseEffect(EntityPlayer player, RayTraceResult mop) {
        if (this.isActive(player)) {
            EntityLiving living;
            NBTTagCompound nbtPlayer = player.getEntityData();
            long lastUseTicks = nbtPlayer.getLong(LAST_USE_TIME_KEY);
            long currentServerTime = MinecraftServer.getCurrentTimeMillis() / 50L;
            if (currentServerTime - lastUseTicks > 200L && mop != null && mop.typeOfHit == RayTraceResult.Type.ENTITY && CreatureUtil.isUndead(mop.entityHit) && !PotionEnslaved.isMobEnslavedBy(living = (EntityLiving)mop.entityHit, player)) {
                PotionEnslaved.setEnslaverForMob(living, player);
                nbtPlayer.setLong(LAST_USE_TIME_KEY, currentServerTime);
                return true;
            }
        }
        return false;
    }
}

