/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion.brew;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.registry.WitcheryIdentityRegistry;

public abstract class InfusedBrewEffect {
    public static final WitcheryIdentityRegistry<ResourceLocation, InfusedBrewEffect> REGISTRY = new WitcheryIdentityRegistry();
    private static final String BREW_TYPE_KEY = "WitcheryType";
    private static final String BREW_START_KEY = "WitcheryStart";
    private static final String BREW_MINS_LEFT_KEY = "WitcheryRemaining";
    public final int imageMapX;
    public final int imageMapY;

    protected InfusedBrewEffect(int imageY) {
        this.imageMapX = 16;
        this.imageMapY = imageY;
    }

    public static InfusedBrewEffect getActiveBrew(EntityPlayer player) {
        if (player != null) {
            NBTTagCompound nbtPlayer = player.getEntityData();
            return InfusedBrewEffect.getActiveBrew(nbtPlayer);
        }
        return null;
    }

    public static InfusedBrewEffect getActiveBrew(NBTTagCompound compound) {
        if (compound != null && compound.hasKey(BREW_TYPE_KEY)) {
            return (InfusedBrewEffect)REGISTRY.get(new ResourceLocation(compound.getString(BREW_TYPE_KEY)));
        }
        return null;
    }

    public static long getActiveBrewStartTime(NBTTagCompound nbtPlayer) {
        if (nbtPlayer != null) {
            return nbtPlayer.getLong(BREW_START_KEY);
        }
        return 0L;
    }

    public static String getMinutesRemaining(NBTTagCompound nbtPlayer) {
        if (nbtPlayer != null) {
            long minsLeft = nbtPlayer.getLong(BREW_MINS_LEFT_KEY);
            return String.format("%d", minsLeft);
        }
        return "";
    }

    public static void setActiveBrew(InfusedBrewEffect brew, EntityPlayer player, boolean sync) {
        if (player != null) {
            NBTTagCompound nbtPlayer = player.getEntityData();
            InfusedBrewEffect.setActiveBrew(player.world, player, nbtPlayer, brew, sync);
        }
    }

    public static void setActiveBrew(World world, EntityPlayer player, NBTTagCompound nbtPlayer, InfusedBrewEffect brew, boolean sync) {
        if (nbtPlayer != null && !world.isRemote) {
            ResourceLocation it = (ResourceLocation)REGISTRY.getKey(brew);
            if (it != null) {
                nbtPlayer.setString(BREW_TYPE_KEY, it.toString());
            }
            nbtPlayer.setLong(BREW_START_KEY, world.getTotalWorldTime());
            if (sync) {
                Infusion.syncPlayer(world, player);
            }
        }
    }

    public static void setActiveBrewInfo(NBTTagCompound nbtPlayer, ResourceLocation brewID, long startTime) {
        nbtPlayer.setString(BREW_TYPE_KEY, brewID.toString());
        nbtPlayer.setLong(BREW_MINS_LEFT_KEY, startTime);
    }

    public static void checkActiveEffects(World world, EntityPlayer player, NBTTagCompound nbtPlayer, boolean sync) {
        InfusedBrewEffect activeEffect;
        if (nbtPlayer != null && !world.isRemote && (activeEffect = InfusedBrewEffect.getActiveBrew(nbtPlayer)) != null) {
            long startTime = nbtPlayer.getLong(BREW_START_KEY);
            if (world.getTotalWorldTime() > startTime + 144000L) {
                nbtPlayer.removeTag(BREW_START_KEY);
                nbtPlayer.removeTag(BREW_TYPE_KEY);
                Infusion.syncPlayer(world, player);
                return;
            }
            if (sync) {
                Infusion.syncPlayer(world, player);
            }
        }
    }

    public boolean tryUseEffect(EntityPlayer player, RayTraceResult mop) {
        return this.isActive(player);
    }

    public boolean isActive(EntityPlayer player) {
        return InfusedBrewEffect.getActiveBrew(player) == this;
    }
}

