/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;

public class PlayerEffects {
    public static final String KEY_EFFECTS = "witchery.effects";
    public static final PlayerEffect IMP_FIRE_TOUCH;
    public static final PlayerEffect IMP_EVAPORATION;
    public static final PlayerEffect IMP_METLING_TOUCH;
    private static final ArrayList<PlayerEffect> effects;

    public static void removeAll(EntityPlayer player) {
        player.getEntityData().removeTag(KEY_EFFECTS);
    }

    public static void onUpdate(EntityPlayer player) {
        NBTTagCompound nbtPlayer;
        if (player.world.getTotalWorldTime() % 20L == 3L && (nbtPlayer = player.getEntityData()) != null && nbtPlayer.hasKey(KEY_EFFECTS)) {
            NBTTagCompound nbtEffects = nbtPlayer.getCompoundTag(KEY_EFFECTS);
            for (PlayerEffect effect : effects) {
                effect.update(nbtEffects, player);
            }
            if (nbtEffects.isEmpty()) {
                nbtPlayer.removeTag(KEY_EFFECTS);
            }
        }
    }

    public static void onHarvestDrops(EntityPlayer player, BlockEvent.HarvestDropsEvent event) {
        NBTTagCompound nbtPlayer = player.getEntityData();
        if (nbtPlayer != null && nbtPlayer.hasKey(KEY_EFFECTS)) {
            NBTTagCompound nbtEffects = nbtPlayer.getCompoundTag(KEY_EFFECTS);
            for (PlayerEffect effect : effects) {
                effect.harvest(nbtEffects, event, player);
            }
            if (nbtEffects.isEmpty()) {
                nbtPlayer.removeTag(KEY_EFFECTS);
            }
        }
    }

    public static void onInteract(EntityPlayer player, PlayerInteractEvent event) {
        NBTTagCompound nbtPlayer = player.getEntityData();
        if (nbtPlayer != null && nbtPlayer.hasKey(KEY_EFFECTS)) {
            NBTTagCompound nbtEffects = nbtPlayer.getCompoundTag(KEY_EFFECTS);
            for (PlayerEffect effect : effects) {
                effect.interact(nbtEffects, event, player);
            }
            if (nbtEffects.isEmpty()) {
                nbtPlayer.removeTag(KEY_EFFECTS);
            }
        }
    }

    static {
        effects = new ArrayList();
        IMP_FIRE_TOUCH = new PlayerEffect("witchery.imp.firetouch"){

            @Override
            protected void doInteract(EntityPlayer player, PlayerInteractEvent event) {
                World world = player.world;
                if (world.rand.nextDouble() < 0.2 && !world.isAirBlock(event.getPos())) {
                    BlockPos pos = event.getPos().offset(Objects.requireNonNull(event.getFace()));
                    int par4 = pos.getX();
                    int par5 = pos.getY();
                    int par6 = pos.getZ();
                    if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                        pos.add(-(world.rand.nextInt(3) + 1), 0, -(world.rand.nextInt(3) + 1));
                    }
                    if (world.isAirBlock(pos) && !world.isAirBlock(pos.down())) {
                        world.playSound((double)par4 + 0.5, (double)par5 + 0.5, (double)par6 + 0.5, SoundEvents.BLOCK_FIRE_AMBIENT, player.getSoundCategory(), 1.0f, world.rand.nextFloat() * 0.4f + 0.8f, false);
                        world.setBlockState(pos, Blocks.FIRE.getDefaultState());
                    }
                }
            }
        };
        IMP_EVAPORATION = new PlayerEffect("witchery.imp.evaporation"){

            @Override
            protected void doUpdate(EntityPlayer player) {
                if (player.world.rand.nextInt(5) == 0) {
                    int midX = MathHelper.floor((double)player.posX);
                    int midY = MathHelper.floor((double)player.posY);
                    int midZ = MathHelper.floor((double)player.posZ);
                    int R = 3;
                    int RSq = 9;
                    boolean found = false;
                    for (int x = midX - R; x <= midX + R; ++x) {
                        for (int z = midZ - R; z <= midZ + R; ++z) {
                            for (int y = midY + 2; y >= midY - 1; --y) {
                                if (!(player.getDistanceSq((double)x, (double)y, (double)z) <= (double)RSq)) continue;
                                BlockPos pos = new BlockPos(x, y, z);
                                Block block = BlockUtil.getBlock(player.world, x, y, z).getBlock();
                                if (block != Blocks.WATER && block != Blocks.FLOWING_WATER || !player.world.isAirBlock(pos.up())) continue;
                                player.world.setBlockToAir(pos);
                                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)x, (double)(y + 1), (double)z, 1.0f, 1.0f, EnumParticleTypes.EXPLOSION_NORMAL), player.world, x, y + 1, z);
                                found = true;
                            }
                        }
                    }
                    if (found) {
                        player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 1.0f, 2.6f + (player.world.rand.nextFloat() - player.world.rand.nextFloat()) * 0.8f);
                    }
                }
            }
        };
        IMP_METLING_TOUCH = new PlayerEffect("witchery.im.meltingtouch"){

            @Override
            protected void doHarvest(EntityPlayer player, BlockEvent.HarvestDropsEvent event) {
                ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
                for (ItemStack drop : event.getDrops()) {
                    ItemStack smeltedDrop = FurnaceRecipes.instance().getSmeltingResult(drop);
                    if (!smeltedDrop.isEmpty()) {
                        ItemStack smelted = smeltedDrop.copy();
                        if (player.world.rand.nextDouble() < 0.25) {
                            smelted.grow(1);
                        }
                        newDrops.add(smelted);
                        continue;
                    }
                    newDrops.add(drop);
                }
                event.getDrops().clear();
                for (ItemStack newDrop : newDrops) {
                    event.getDrops().add(newDrop);
                }
            }
        };
    }

    public static abstract class PlayerEffect {
        protected final String unlocalizedName;

        protected PlayerEffect(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
            effects.add(this);
        }

        public void interact(NBTTagCompound nbtEffects, PlayerInteractEvent event, EntityPlayer player) {
            if (nbtEffects.hasKey(this.unlocalizedName)) {
                this.doInteract(player, event);
            }
        }

        protected void doInteract(EntityPlayer p0, PlayerInteractEvent p1) {
        }

        public void harvest(NBTTagCompound nbtEffects, BlockEvent.HarvestDropsEvent event, EntityPlayer player) {
            if (nbtEffects.hasKey(this.unlocalizedName)) {
                this.doHarvest(player, event);
            }
        }

        protected void doHarvest(EntityPlayer p0, BlockEvent.HarvestDropsEvent p1) {
        }

        public void applyTo(EntityPlayer player, int durationTicks) {
            NBTTagCompound nbtPlayer = player.getEntityData();
            if (nbtPlayer != null) {
                if (!nbtPlayer.hasKey(PlayerEffects.KEY_EFFECTS)) {
                    nbtPlayer.setTag(PlayerEffects.KEY_EFFECTS, (NBTBase)new NBTTagCompound());
                }
                NBTTagCompound nbtEffects = nbtPlayer.getCompoundTag(PlayerEffects.KEY_EFFECTS);
                nbtEffects.setInteger(this.unlocalizedName, durationTicks);
            }
        }

        private void removeFrom(NBTTagCompound nbtEffects) {
            if (nbtEffects.hasKey(this.unlocalizedName)) {
                nbtEffects.removeTag(this.unlocalizedName);
            }
        }

        private void update(NBTTagCompound nbtEffects, EntityPlayer player) {
            if (nbtEffects.hasKey(this.unlocalizedName)) {
                int remainingTicks = nbtEffects.getInteger(this.unlocalizedName);
                int newTicks = Math.max(remainingTicks - 20, 0);
                if (newTicks == 0) {
                    this.removeFrom(nbtEffects);
                } else {
                    nbtEffects.setInteger(this.unlocalizedName, newTicks);
                    this.doUpdate(player);
                }
            }
        }

        protected void doUpdate(EntityPlayer p0) {
        }
    }
}

