/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircleRepulsive;
import net.msrandom.witchery.util.EarthItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class OverworldInfusion
extends Infusion {
    @Override
    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
        int blockZ;
        int blockY;
        int blockX;
        BlockPos pos;
        Block block;
        if (event.getDistance() > 3.0f && ((block = world.getBlockState(pos = new BlockPos(blockX = MathHelper.floor((double)player.posX), blockY = MathHelper.floor((double)player.posY) - 1, blockZ = MathHelper.floor((double)player.posZ))).getBlock()) == Blocks.GRASS || block == Blocks.MYCELIUM || block == Blocks.GRAVEL || block == Blocks.SAND || block == Blocks.SNOW)) {
            if (player.isSneaking()) {
                if (this.consumeCharges(world, player, 10)) {
                    event.setDistance(0.0f);
                    int EXPLOSION_STRENGTH = 3;
                    world.createExplosion((Entity)player, player.posX, (double)blockY + 0.5, player.posZ, (float)EXPLOSION_STRENGTH, true);
                }
            } else if (this.consumeCharges(world, player, 5)) {
                event.setDistance(0.0f);
                world.setBlockToAir(pos);
                ItemStack itemstack = new ItemStack(block, 1);
                EntityItem blockEntity = new EntityItem(world, (double)blockX, (double)blockY, (double)blockZ, itemstack);
                world.spawnEntity((Entity)blockEntity);
            }
        }
    }

    @Override
    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (world.isRemote) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            int posX = MathHelper.floor((double)player.posX);
            int posY = MathHelper.floor((double)player.posY);
            int posZ = MathHelper.floor((double)player.posZ);
            boolean isWearingMetalArmour = false;
            for (int i = 0; i < 5; ++i) {
                ItemStack heldStack = otherLivingEntity.getItemStackFromSlot(EntityEquipmentSlot.values()[i]);
                if (!EarthItems.instance().isMatch(heldStack)) continue;
                isWearingMetalArmour = true;
                break;
            }
            if (isWearingMetalArmour) {
                double ACCELERATION = 3.0;
                if (player.isSneaking()) {
                    if (this.consumeCharges(world, player, 4)) {
                        Vec3d look = player.getLookVec();
                        double motionX = look.x * 0.8 * ACCELERATION;
                        double motionY = 1.5;
                        double motionZ = look.z * 0.8 * ACCELERATION;
                        if (otherLivingEntity instanceof EntityPlayerMP) {
                            EntityPlayerMP targetPlayer = (EntityPlayerMP)otherLivingEntity;
                            WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                        } else {
                            otherLivingEntity.motionX = motionX;
                            otherLivingEntity.motionY = motionY;
                            otherLivingEntity.motionZ = motionZ;
                        }
                    }
                } else if (this.consumeCharges(world, player, 2)) {
                    Vec3d look = player.getLookVec();
                    double motionX = look.x * 0.8 * 3.0;
                    double motionY = 0.30000000000000004;
                    double motionZ = look.z * 0.8 * 3.0;
                    if (otherLivingEntity instanceof EntityPlayerMP) {
                        EntityPlayerMP targetPlayer = (EntityPlayerMP)otherLivingEntity;
                        WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), targetPlayer);
                    } else {
                        otherLivingEntity.motionX = motionX;
                        otherLivingEntity.motionY = motionY;
                        otherLivingEntity.motionZ = motionZ;
                    }
                }
            }
        }
    }

    @Override
    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
        if (!world.isRemote) {
            int elapsedTicks = this.getMaxItemUseDuration() - countdown;
            int seconds = elapsedTicks / 20;
            if (player.isSneaking()) {
                if (seconds >= 2 && elapsedTicks % 4 == 0 && this.consumeCharges(world, player, 1)) {
                    int AreaOfEffect = 6;
                    List entities = world.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(player.posX - 6.0, player.posY - 6.0, player.posZ - 6.0, player.posX + (double)AreaOfEffect, player.posY + (double)AreaOfEffect, player.posZ + (double)AreaOfEffect));
                    for (EntityItem entity : entities) {
                        if (!EarthItems.instance().isMatch(entity.getItem())) continue;
                        double d0 = 8.0;
                        double motionX = 0.0;
                        double motionY = 0.0;
                        double motionZ = 0.0;
                        double d2 = (player.posX - entity.posX) / d0;
                        double d3 = (player.posY + (double)player.getEyeHeight() - entity.posY) / d0;
                        double d4 = (player.posZ - entity.posZ) / d0;
                        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                        double d6 = 2.0;
                        d6 *= d6;
                        boolean oldClip = entity.noClip;
                        entity.noClip = true;
                        entity.move(MoverType.SELF, motionX += d2 / Math.max(Math.abs(d2), 0.0) * 1.0, motionY += d3 / Math.max(Math.abs(d2), 0.0) * 1.0, motionZ += d4 / Math.max(Math.abs(d2), 0.0) * 1.0);
                        entity.noClip = oldClip;
                    }
                    int AreaOfEffect2 = 6;
                    for (int x = (int)player.posX - AreaOfEffect2; x <= (int)player.posX + AreaOfEffect2; ++x) {
                        for (int y = (int)player.posY - 3; y <= (int)player.posY + 3; ++y) {
                            for (int z = (int)player.posZ - AreaOfEffect2; z <= (int)player.posZ + AreaOfEffect2; ++z) {
                                Item ingot;
                                BlockPos pos = new BlockPos(x, y, z);
                                Block id = world.getBlockState(pos).getBlock();
                                if (id == Blocks.AIR || Item.getItemFromBlock((Block)id) == Items.AIR || (ingot = EarthItems.instance().oreToIngot(id)) == null || !this.consumeCharges(world, player, 2)) continue;
                                world.setBlockState(pos, Blocks.STONE.getDefaultState(), 3);
                                world.spawnEntity((Entity)new EntityItem(world, (double)x, (double)y, (double)z, new ItemStack(ingot)));
                            }
                        }
                    }
                }
            } else if (seconds >= 2 && elapsedTicks % 20 == 0) {
                this.playSound(world, player, SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP);
            }
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        int seconds;
        if (world.isRemote) {
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        RayTraceResult hit = OtherwhereInfusion.doCustomRayTrace(world, player, true, 4.0);
        if (hit != null) {
            switch (hit.typeOfHit) {
                case ENTITY: {
                    if (player.isSneaking() || !(hit.entityHit instanceof EntityLiving) || !this.consumeCharges(world, player, 2)) break;
                    EntityLiving entity = (EntityLiving)hit.entityHit;
                    if (itemstack != null && EarthItems.instance().isMatch(itemstack)) {
                        entity.entityDropItem(itemstack, 2.0f);
                        entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    }
                    return;
                }
                case BLOCK: {
                    Item ingot;
                    Block blockID2;
                    int DEPTH = 3;
                    if (!player.isSneaking() && hit.sideHit == EnumFacing.UP && world.getBlockState(hit.getBlockPos().down(10)).getMaterial().isSolid() && this.consumeCharges(world, player, 2)) {
                        for (int h = 0; h < 6; ++h) {
                            BlockPos originY = hit.getBlockPos().down(h + 3);
                            IBlockState state = world.getBlockState(hit.getBlockPos());
                            if (!WitcheryUtils.canBreak(state)) continue;
                            world.setBlockToAir(hit.getBlockPos());
                            if (WitcheryUtils.canBreak(world.getBlockState(originY))) {
                                world.setBlockState(originY, state, 3);
                            }
                            AxisAlignedBB bounds = new AxisAlignedBB((double)hit.getBlockPos().getX(), (double)hit.getBlockPos().getY(), (double)hit.getBlockPos().getZ(), (double)(hit.getBlockPos().getX() + 1), (double)(hit.getBlockPos().getY() + 2), (double)(hit.getBlockPos().getZ() + 1));
                            for (Entity entity2 : world.getEntitiesWithinAABB(Entity.class, bounds)) {
                                if (entity2 instanceof EntityLivingBase) {
                                    entity2.setPositionAndUpdate(entity2.posX, entity2.posY + (double)DEPTH, entity2.posZ);
                                    continue;
                                }
                                entity2.setPosition(entity2.posX, entity2.posY + 3.0, entity2.posZ);
                            }
                        }
                    } else if (!player.isSneaking() && hit.sideHit != EnumFacing.DOWN && hit.sideHit != EnumFacing.UP) {
                        if (this.isThrowableRock(world, hit.getBlockPos(), hit.sideHit) && this.consumeCharges(world, player, 3)) {
                            world.setBlockToAir(hit.getBlockPos());
                            world.playSound(null, hit.getBlockPos(), SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)hit.getBlockPos().getX(), (double)hit.getBlockPos().getY(), (double)hit.getBlockPos().getZ(), 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), world, hit.getBlockPos(), 8.0);
                            EntityWitchProjectile rockEntity = new EntityWitchProjectile(world, (EntityLivingBase)player, new ItemStack(WitcheryIngredientItems.ROCK));
                            rockEntity.shoot((Entity)player, player.rotationPitch, player.rotationYaw, 0.0f, 1.5f, 1.0f);
                            rockEntity.setPosition((double)hit.getBlockPos().getX() + 0.5, (double)hit.getBlockPos().getY() + 0.5, (double)hit.getBlockPos().getZ() + 0.5);
                            world.spawnEntity((Entity)rockEntity);
                        }
                    } else if (player.isSneaking() && this.consumeCharges(world, player, 2) && (blockID2 = world.getBlockState(new BlockPos(hit.getBlockPos().getX(), hit.getBlockPos().getY(), hit.getBlockPos().getZ())).getBlock()) != Blocks.AIR && Item.getItemFromBlock((Block)blockID2) != Items.AIR && (ingot = EarthItems.instance().oreToIngot(blockID2)) != null) {
                        world.setBlockState(hit.getBlockPos(), Blocks.STONE.getDefaultState(), 3);
                        world.spawnEntity((Entity)new EntityItem(world, (double)hit.getBlockPos().getX(), (double)hit.getBlockPos().getY(), (double)hit.getBlockPos().getZ(), new ItemStack(ingot, 2, 0)));
                    }
                    return;
                }
            }
        }
        if ((seconds = elapsedTicks / 20) >= 2 && !player.isSneaking() && this.consumeCharges(world, player, 6 * seconds)) {
            Shockwave.SHOCKWAVES.add(new Shockwave(player, 2 * seconds));
        } else {
            this.playFailSound(world, player);
        }
    }

    private boolean isThrowableRock(World world, BlockPos pos, EnumFacing sideHit) {
        Block[] blocks = new Block[]{Blocks.DIRT, Blocks.GRASS, Blocks.STONE, Blocks.COBBLESTONE, Blocks.SAND, Blocks.GRAVEL, Blocks.SANDSTONE, Blocks.STONE_SLAB, Blocks.BRICK_BLOCK, Blocks.MOSSY_COBBLESTONE, Blocks.GRASS, Blocks.STONE_STAIRS, Blocks.CLAY, Blocks.SOUL_SAND, Blocks.STONEBRICK, Blocks.BRICK_STAIRS, Blocks.STONE_BRICK_STAIRS, Blocks.MYCELIUM, Blocks.NETHER_BRICK, Blocks.NETHER_BRICK_STAIRS, Blocks.SANDSTONE_STAIRS, Blocks.HARDENED_CLAY, Blocks.COAL_BLOCK, Blocks.NETHERRACK};
        Block blockID = world.getBlockState(pos).getBlock();
        if (!Arrays.asList(blocks).contains(blockID)) {
            return false;
        }
        return !world.getBlockState(pos.offset(sideHit)).getMaterial().isSolid();
    }

    public static class Shockwave {
        public static final List<Shockwave> SHOCKWAVES = new ArrayList<Shockwave>();
        final BlockPos center;
        final EntityPlayer creator;
        final int maxRadius;
        final int MIN_RADIUS = 2;
        int stage = 0;

        public Shockwave(EntityPlayer creator, int maxRadius) {
            this.center = new BlockPos((int)creator.posX, (int)creator.posY - 1, (int)creator.posZ);
            this.creator = creator;
            this.maxRadius = maxRadius + 2;
        }

        public boolean process(World world) {
            if (this.stage++ == 0) {
                this.drawCircle(world, this.center, this.stage + 2, 1);
            } else {
                this.drawCircle(world, this.center.up(2), this.stage + 2, -1);
                this.drawCircle(world, this.center.up(), this.stage + 2 - 1, -1);
            }
            if (this.stage < this.maxRadius) {
                this.drawCircle(world, this.center, this.stage + 2 + 1, 2);
            } else {
                this.drawCircle(world, this.center.up(), this.stage + 2, -1);
            }
            int r = this.stage + 2;
            AxisAlignedBB bounds = new AxisAlignedBB(this.center.add(-r, 1, -r), this.center.add(r, 4, r));
            for (EntityLivingBase entity : world.getEntitiesWithinAABB(EntityLivingBase.class, bounds)) {
                double dist = entity.getDistance((double)this.center.getX(), (double)this.center.getY(), (double)this.center.getZ());
                if (!(dist <= (double)(r + 1)) || !(dist >= (double)r)) continue;
                entity.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)this.creator), 8.0f);
                RiteEffectProtectionCircleRepulsive.push((Entity)entity, this.center);
            }
            return this.stage == this.maxRadius;
        }

        protected void drawCircle(World world, BlockPos pos, int radius, int height2) {
            int x = radius;
            int radiusError = 1 - x;
            for (int z = 0; x >= z; ++z) {
                this.drawPixel(world, pos.add(x, 0, z), height2);
                this.drawPixel(world, pos.add(z, 0, x), height2);
                this.drawPixel(world, pos.add(-x, 0, z), height2);
                this.drawPixel(world, pos.add(-z, 0, x), height2);
                this.drawPixel(world, pos.add(-x, 0, -z), height2);
                this.drawPixel(world, pos.add(-z, 0, -x), height2);
                this.drawPixel(world, pos.add(x, 0, -z), height2);
                this.drawPixel(world, pos.add(z, 0, -x), height2);
                if (radiusError < 0) {
                    radiusError += 2 * z + 1;
                    continue;
                }
                radiusError += 2 * (z - --x + 1);
            }
        }

        protected void drawPixel(World world, BlockPos pos, int height2) {
            if (height2 > 0) {
                if (world.isAirBlock(pos.down(1)) || world.getBlockState(pos.up()).getMaterial().isSolid()) {
                    return;
                }
                for (int i = 0; i < 2; ++i) {
                    BlockPos p = pos.down(i);
                    IBlockState blockID = world.getBlockState(p);
                    if (WitcheryUtils.canBreak(blockID)) {
                        world.setBlockToAir(p);
                    }
                    if (!WitcheryUtils.canBreak(world.getBlockState(p.up(height2)))) continue;
                    world.setBlockState(p.up(height2), blockID, 3);
                }
            } else {
                if (world.isAirBlock(pos) || world.getBlockState(pos.up(height2 - 1)).getMaterial().isSolid()) {
                    return;
                }
                for (int i = 1; i >= 0; --i) {
                    BlockPos p = pos.down(i);
                    IBlockState blockID = world.getBlockState(p);
                    if (WitcheryUtils.canBreak(blockID)) {
                        world.setBlockToAir(p);
                    }
                    if (!WitcheryUtils.canBreak(world.getBlockState(p.up(height2)))) continue;
                    world.setBlockState(p.up(height2), blockID, 3);
                }
            }
        }
    }
}

