/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.util.DimensionalLocation;
import net.msrandom.witchery.util.WitcheryUtils;

public class OtherwhereInfusion
extends Infusion {
    private static final String RECALL_LOCATON_KEY = "WitcheryRecall";
    private static final int SAVE_RECALL_POINT_THRESHOLD = 60;

    public static void teleportEntity(EntityPlayer entityPlayer, RayTraceResult hitMOP) {
        EntityPlayerMP player;
        if (hitMOP != null && entityPlayer instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed(player = (EntityPlayerMP)entityPlayer)) {
            switch (hitMOP.typeOfHit) {
                case ENTITY: {
                    player.setPositionAndUpdate(hitMOP.hitVec.x, hitMOP.hitVec.y, hitMOP.hitVec.z);
                    break;
                }
                case BLOCK: {
                    double hitx = hitMOP.hitVec.x;
                    double hity = hitMOP.hitVec.y;
                    double hitz = hitMOP.hitVec.z;
                    switch (hitMOP.sideHit) {
                        case DOWN: {
                            hity -= 2.0;
                        }
                        case EAST: {
                            hitz -= 0.5;
                            break;
                        }
                        case WEST: {
                            hitz += 0.5;
                            break;
                        }
                        case NORTH: {
                            hitx -= 0.5;
                            break;
                        }
                        case SOUTH: {
                            hitx += 0.5;
                        }
                    }
                    player.fallDistance = 0.0f;
                    player.setPositionAndUpdate(hitx, hity, hitz);
                    break;
                }
            }
        }
    }

    public static RayTraceResult doCustomRayTrace(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedBlock = OtherwhereInfusion.raytraceBlocks(world, player, collisionFlag, reachDistance);
        RayTraceResult pickedEntity = OtherwhereInfusion.raytraceEntities(world, player, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        Vec3d playerPosition = player.getPositionEyes(1.0f);
        double dBlock = pickedBlock.hitVec.distanceTo(playerPosition);
        double dEntity = pickedEntity.hitVec.distanceTo(playerPosition);
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public static RayTraceResult raytraceEntities(World world, EntityPlayer player, double reachDistance) {
        Entity hit = null;
        Vec3d rotation = player.getLookVec();
        Vec3d start = player.getPositionEyes(1.0f);
        Vec3d end = start.add(rotation.x * reachDistance, rotation.y * reachDistance, rotation.z * reachDistance);
        double closestEntity = reachDistance;
        for (Entity entity : world.getEntitiesWithinAABBExcludingEntity((Entity)player, player.getEntityBoundingBox().grow(1.1 * reachDistance))) {
            double hitDistance;
            RayTraceResult interception;
            if (!entity.canBeCollidedWith() || (interception = entity.getEntityBoundingBox().grow((double)entity.getCollisionBorderSize()).calculateIntercept(start, end)) == null || !((hitDistance = start.distanceTo(interception.hitVec)) < closestEntity)) continue;
            hit = entity;
            closestEntity = hitDistance;
        }
        return hit == null ? null : new RayTraceResult(hit);
    }

    private static boolean isConnectionClosed(EntityPlayerMP player) {
        return player.connection.netManager.isChannelOpen();
    }

    public static RayTraceResult raytraceBlocks(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        Vec3d playerPosition = player.getPositionEyes(1.0f);
        Vec3d playerLook = player.getLookVec();
        Vec3d playerViewOffset = new Vec3d(playerPosition.x + playerLook.x * reachDistance, playerPosition.y + playerLook.y * reachDistance, playerPosition.z + playerLook.z * reachDistance);
        return world.rayTraceBlocks(playerPosition, playerViewOffset, collisionFlag, !collisionFlag, false);
    }

    private static RayTraceResult raytraceUpBlocks(World world, EntityLivingBase player, double reachDistance) {
        Vec3d playerPosition = player.getPositionEyes(1.0f);
        Vec3d playerUp = new Vec3d(0.0, 1.0, 0.0);
        Vec3d playerViewOffset = new Vec3d(playerPosition.x + playerUp.x * reachDistance, playerPosition.y + playerUp.y * reachDistance, playerPosition.z + playerUp.z * reachDistance);
        return world.rayTraceBlocks(playerPosition, playerViewOffset, true, false, false);
    }

    @Override
    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (world.isRemote) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            if (player.isSneaking()) {
                DimensionalLocation recallLocation = this.recallLocation(player.getEntityData());
                if (recallLocation != null && recallLocation.dimension != WitcheryDimensions.SPIRIT_WORLD.getType().getId() && recallLocation.dimension != WitcheryDimensions.TORMENT.getType().getId() && recallLocation.dimension != WitcheryDimensions.MIRROR.getType().getId() && !WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && !WitcheryDimensions.TORMENT.isCurrentDimension(world) && !WitcheryDimensions.MIRROR.isCurrentDimension(world) && PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 2)) {
                    if (player instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed((EntityPlayerMP)player)) {
                        player.fallDistance = 0.0f;
                        WitcheryIngredientItem.teleportToLocation(recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension, (Entity)player, true);
                        otherLivingEntity.fallDistance = 0.0f;
                        if (PotionEnderInhibition.canTeleport((Entity)otherLivingEntity, 2)) {
                            WitcheryIngredientItem.teleportToLocation(recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension, (Entity)otherLivingEntity, true);
                        }
                    }
                } else {
                    world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                }
            } else if (PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 2)) {
                double hikeModified2;
                double HIKE_HEIGHT = 8.0;
                RayTraceResult hitMOP = OtherwhereInfusion.raytraceUpBlocks(world, (EntityLivingBase)player, HIKE_HEIGHT);
                double hikeModified = hitMOP == null ? HIKE_HEIGHT : Math.min((double)hitMOP.getBlockPos().getY() - otherLivingEntity.posY - 2.0, HIKE_HEIGHT);
                RayTraceResult hitMOP2 = OtherwhereInfusion.raytraceUpBlocks(world, otherLivingEntity, HIKE_HEIGHT);
                double d = hikeModified2 = hitMOP2 == null ? HIKE_HEIGHT : Math.min((double)hitMOP2.getBlockPos().getY() - otherLivingEntity.posY - 2.0, HIKE_HEIGHT);
                if (player instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed((EntityPlayerMP)player) && hikeModified > 0.0 && hikeModified2 > 0.0) {
                    WitcheryIngredientItem.teleportToLocation(player.posX, player.posY + hikeModified, player.posZ, player.dimension, (Entity)player, true);
                    if (PotionEnderInhibition.canTeleport((Entity)otherLivingEntity, 2)) {
                        WitcheryIngredientItem.teleportToLocation(otherLivingEntity.posX, otherLivingEntity.posY + hikeModified2, otherLivingEntity.posZ, otherLivingEntity.dimension, (Entity)otherLivingEntity, true);
                    }
                }
            }
        }
    }

    @Override
    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (player.isSneaking() && elapsedTicks == 60) {
            if (!world.isRemote) {
                player.sendMessage(new TextComponentTranslation(this.getTranslationKey() + ".recall_prompt", new Object[0]).setStyle(new Style().setColor(TextFormatting.GRAY)));
            }
            player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_PLING, player.getSoundCategory(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        } else if (!player.isSneaking() && elapsedTicks > 0 && elapsedTicks % 20 == 0) {
            int MAX_TELEPORT_DISTANCE = 40 + 20 * (elapsedTicks / 20);
            RayTraceResult hitMOP = OtherwhereInfusion.doCustomRayTrace(world, player, true, MAX_TELEPORT_DISTANCE);
            if (hitMOP != null) {
                player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                if (!world.isRemote) {
                    player.sendMessage(new TextComponentTranslation(this.getTranslationKey() + ".teleport_prompt", new Object[0]).setStyle(new Style().setColor(TextFormatting.GRAY)));
                }
            } else {
                player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (world.isRemote) {
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (player.isSneaking() && elapsedTicks >= 60) {
            this.storeLocation(player.getEntityData(), player);
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        } else if (player.isSneaking()) {
            DimensionalLocation recallLocation = this.recallLocation(player.getEntityData());
            if (recallLocation != null && recallLocation.dimension != WitcheryDimensions.SPIRIT_WORLD.getType().getId() && recallLocation.dimension != WitcheryDimensions.TORMENT.getType().getId() && recallLocation.dimension != WitcheryDimensions.MIRROR.getType().getId() && !WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && !WitcheryDimensions.TORMENT.isCurrentDimension(world) && !WitcheryDimensions.MIRROR.isCurrentDimension(world) && PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 2)) {
                if (player instanceof EntityPlayerMP && OtherwhereInfusion.isConnectionClosed((EntityPlayerMP)player)) {
                    player.fallDistance = 0.0f;
                    WitcheryIngredientItem.teleportToLocation(recallLocation.posX, recallLocation.posY, recallLocation.posZ, recallLocation.dimension, (Entity)player, true);
                    Infusion.setCooldown(world, itemstack, 1500);
                }
            } else {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        } else {
            int MAX_TELEPORT_DISTANCE = 40 + 20 * (elapsedTicks / 20);
            RayTraceResult hitMOP = OtherwhereInfusion.doCustomRayTrace(world, player, true, MAX_TELEPORT_DISTANCE);
            if (hitMOP != null && PotionEnderInhibition.canTeleport((Entity)player, 2) && this.consumeCharges(world, player, 1)) {
                world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ENDERMEN_TELEPORT, player.getSoundCategory(), 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryUtils.addNewParticles(world, EnumParticleTypes.PORTAL, player.posX, player.posY, player.posZ, 0.0, 20, 0.5, 2.0);
                OtherwhereInfusion.teleportEntity(player, hitMOP);
                world.playSound(null, player.getPosition(), SoundEvents.ENTITY_ENDERMEN_TELEPORT, player.getSoundCategory(), 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryUtils.addNewParticles(world, EnumParticleTypes.PORTAL, player.posX, player.posY, player.posZ, 0.0, 20, 0.5, 2.0);
                Infusion.setCooldown(world, itemstack, 1500);
            } else {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
                if (hitMOP == null) {
                    player.sendMessage(new TextComponentTranslation(this.getTranslationKey() + ".teleport_too_far", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                }
            }
        }
    }

    private void storeLocation(NBTTagCompound nbt, EntityPlayer player) {
        DimensionalLocation location = new DimensionalLocation((Entity)player);
        location.saveToNBT(nbt, RECALL_LOCATON_KEY);
        if (!player.world.isRemote) {
            player.sendMessage(new TextComponentTranslation(this.getTranslationKey() + ".recall_set", new Object[]{WitcheryUtils.getFormattedName(player.world.provider.getDimensionType()), MathHelper.floor((double)location.posX), MathHelper.floor((double)location.posY), MathHelper.floor((double)location.posZ)}).setStyle(new Style().setColor(TextFormatting.GRAY)));
        }
    }

    private DimensionalLocation recallLocation(NBTTagCompound nbtTag) {
        DimensionalLocation location = new DimensionalLocation(nbtTag, RECALL_LOCATON_KEY);
        if (!location.isValid) {
            return null;
        }
        return location;
    }
}

