/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockBarrier;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.EntityUtil;

public class LightInfusion
extends Infusion {
    protected static final int BARRIER_TICKS_TO_LIVE_ = 200;
    private static final int BARRIER_RADIUS = 2;
    private static final int BARRIER_HEIGHT = 3;
    private static final boolean BARRIER_BLOCKS_PLAYERS = true;
    private static final int AGGRO_DROP_RADIUS = 20;

    public static void placeBarrierShield(World world, EntityPlayer player, RayTraceResult hitMOP) {
        double f1 = Math.cos(Math.toRadians(-player.rotationYaw) - Math.PI);
        double f2 = Math.sin(Math.toRadians(-player.rotationYaw) - Math.PI);
        Vec3d loc = new Vec3d(f2, 0.0, f1);
        Material material = world.getBlockState(hitMOP.getBlockPos()).getMaterial();
        int yPlus = 1;
        if (!material.isSolid()) {
            yPlus = 0;
        }
        LightInfusion.drawBarrierBlockColumn(world, player, hitMOP.getBlockPos().getX(), hitMOP.getBlockPos().getY() + yPlus, hitMOP.getBlockPos().getZ());
        loc = loc.rotateYaw((float)Math.toRadians(90.0));
        int newX = MathHelper.floor((double)((double)hitMOP.getBlockPos().getX() + 0.5 + loc.x * 1.0));
        int newZ = MathHelper.floor((double)((double)hitMOP.getBlockPos().getZ() + 0.5 + loc.z * 1.0));
        LightInfusion.drawBarrierBlockColumn(world, player, newX, hitMOP.getBlockPos().getY() + yPlus, newZ);
        loc = loc.rotateYaw((float)Math.toRadians(180.0));
        newX = MathHelper.floor((double)((double)hitMOP.getBlockPos().getX() + 0.5 + loc.x * 1.0));
        newZ = MathHelper.floor((double)((double)hitMOP.getBlockPos().getZ() + 0.5 + loc.z * 1.0));
        LightInfusion.drawBarrierBlockColumn(world, player, newX, hitMOP.getBlockPos().getY() + yPlus, newZ);
    }

    private static boolean setBlockIfNotSolid(World world, BlockPos pos) {
        if (world.getBlockState(pos).getMaterial().isReplaceable()) {
            BlockBarrier.setBlock(world, pos, 200, true, null);
            return true;
        }
        return false;
    }

    private static void drawBarrierBlockColumn(World world, EntityPlayer player, int posX, int posY, int posZ) {
        for (int offsetPosY = posY; offsetPosY < posY + 3; ++offsetPosY) {
            BlockPos pos = new BlockPos(posX, offsetPosY, posZ);
            IBlockState state = world.getBlockState(pos);
            Material material = state.getMaterial();
            Block blockID = state.getBlock();
            if (!material.isReplaceable() && blockID != WitcheryBlocks.BARRIER) continue;
            BlockBarrier.setBlock(world, pos, 200, true, player);
        }
    }

    @Override
    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (world.isRemote) {
            return;
        }
        if (otherEntity instanceof EntityLivingBase) {
            EntityLivingBase otherLivingEntity = (EntityLivingBase)otherEntity;
            int posX = (int)otherEntity.posX;
            int UPSHIFT = 4;
            int posY = (int)otherEntity.posY + UPSHIFT;
            int posZ = (int)otherEntity.posZ;
            BlockPos pos = new BlockPos(posX, posY, posZ);
            if (world.isAirBlock(pos) && world.isAirBlock(pos.up()) && world.isAirBlock(new BlockPos(posX, posY + 2, posZ)) && world.isAirBlock(pos.east()) && world.isAirBlock(pos.east().up()) && world.isAirBlock(new BlockPos(posX + 1, posY + 2, posZ)) && world.isAirBlock(pos.south()) && world.isAirBlock(pos.south().up()) && world.isAirBlock(new BlockPos(posX, posY + 2, posZ + 1)) && world.isAirBlock(pos.west()) && world.isAirBlock(pos.west().up()) && world.isAirBlock(new BlockPos(posX - 1, posY + 2, posZ)) && world.isAirBlock(pos.north()) && world.isAirBlock(pos.north().up()) && world.isAirBlock(new BlockPos(posX, posY + 2, posZ - 1)) && this.consumeCharges(world, player, 5)) {
                this.drawFilledCircle(world, posX, posZ, posY - 1, 2, null);
                for (int y = posY; y < posY + 3; ++y) {
                    this.drawCircle(world, posX, posZ, y, null);
                }
                this.drawFilledCircle(world, posX, posZ, posY + 3, 2, null);
                otherLivingEntity.setPositionAndUpdate((double)posX, (double)posY, (double)posZ);
            }
        }
    }

    @Override
    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
        if (world.isRemote) {
            if (!player.isRiding()) {
                int var7;
                int var6;
                int var5 = MathHelper.floor((double)player.posX);
                if (world.getBlockState(new BlockPos(var5, var6 = MathHelper.floor((double)(player.posY - 2.0)), var7 = MathHelper.floor((double)player.posZ))).getBlock() != Blocks.ICE) {
                    if (player.onGround) {
                        if (!player.isInWater()) {
                            player.motionX *= 1.6500000476837158;
                            player.motionZ *= 1.6500000476837158;
                        } else {
                            player.motionX *= (double)1.1f;
                            player.motionZ *= (double)1.1f;
                        }
                    }
                } else {
                    player.motionX *= (double)1.1f;
                    player.motionZ *= (double)1.1f;
                }
            }
            return;
        }
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (elapsedTicks % 30 == 0 && elapsedTicks > 19) {
            this.bendLightAroundPlayer(world, player, this.consumeCharges(world, player, 1));
        }
    }

    protected void bendLightAroundPlayer(World world, EntityPlayer player, boolean active) {
        if (active) {
            player.addPotionEffect(new PotionEffect(MobEffects.INVISIBILITY, 30, 0, true, true));
            int r = 20;
            AxisAlignedBB bounds = new AxisAlignedBB(player.posX - (double)r, player.posY, player.posZ - (double)r, player.posX + (double)r, player.posY + 2.0, player.posZ + (double)r);
            for (EntityLiving entity : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                if (entity.getAttackTarget() != player || !(entity.getDistance(player.posX, player.posY, player.posZ) <= (double)r)) continue;
                EntityUtil.dropAttackTarget(entity);
            }
        } else {
            player.removePotionEffect(MobEffects.INVISIBILITY);
        }
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        RayTraceResult hitMOP;
        if (world.isRemote) {
            return;
        }
        this.bendLightAroundPlayer(world, player, false);
        int elapsedTicks = this.getMaxItemUseDuration() - countdown;
        if (elapsedTicks < 20 && player.isSneaking() && (hitMOP = OtherwhereInfusion.doCustomRayTrace(world, player, true, 16.0)) != null) {
            switch (hitMOP.typeOfHit) {
                case ENTITY: {
                    if (!(hitMOP.entityHit instanceof EntityLivingBase)) break;
                    EntityLivingBase otherLivingEntity = (EntityLivingBase)hitMOP.entityHit;
                    if (!this.consumeCharges(world, player, 3)) break;
                    int posX = (int)otherLivingEntity.posX;
                    int posY = (int)otherLivingEntity.posY;
                    int posZ = (int)otherLivingEntity.posZ;
                    this.drawFilledCircle(world, posX, posZ, posY - 1, 1, player);
                    for (int y = posY; y < posY + 3; ++y) {
                        this.drawCircle(world, posX, posZ, y, player);
                    }
                    this.drawFilledCircle(world, posX, posZ, posY + 3, 2, player);
                    break;
                }
                case BLOCK: {
                    int i;
                    if (hitMOP.sideHit == EnumFacing.UP && this.consumeCharges(world, player, 3)) {
                        LightInfusion.placeBarrierShield(world, player, hitMOP);
                        break;
                    }
                    if (hitMOP.sideHit == EnumFacing.UP || !this.consumeCharges(world, player, 3)) break;
                    int sproutExtent = 16;
                    boolean isInitialBlockSolid = world.getBlockState(hitMOP.getBlockPos()).getMaterial().isSolid();
                    int n = i = hitMOP.sideHit != EnumFacing.UP || isInitialBlockSolid ? 1 : 0;
                    while (i < sproutExtent && LightInfusion.setBlockIfNotSolid(world, hitMOP.getBlockPos().offset(hitMOP.sideHit, i))) {
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    protected void drawCircle(World world, int x0, int z0, int y, EntityPlayer player) {
        int x = 2;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawPixel(world, x + x0, z + z0, y, player);
            this.drawPixel(world, z + x0, x + z0, y, player);
            this.drawPixel(world, -x + x0, z + z0, y, player);
            this.drawPixel(world, -z + x0, x + z0, y, player);
            this.drawPixel(world, -x + x0, -z + z0, y, player);
            this.drawPixel(world, -z + x0, -x + z0, y, player);
            this.drawPixel(world, x + x0, -z + z0, y, player);
            this.drawPixel(world, z + x0, -x + z0, y, player);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawFilledCircle(World world, int x0, int z0, int y, int radius, EntityPlayer player) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, -x + x0, x + x0, z + z0, y, player);
            this.drawLine(world, -z + x0, z + x0, x + z0, y, player);
            this.drawLine(world, -x + x0, x + x0, -z + z0, y, player);
            this.drawLine(world, -z + x0, z + x0, -x + z0, y, player);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, int x1, int x2, int z, int y, EntityPlayer player) {
        for (int x3 = x1; x3 <= x2; ++x3) {
            this.drawPixel(world, x3, z, y, player);
        }
    }

    protected void drawPixel(World world, int x, int z, int y, EntityPlayer player) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.getBlockState(pos);
        Material material = state.getMaterial();
        if (!material.isSolid() || state.getBlock() == WitcheryBlocks.BARRIER || material == Material.AIR) {
            BlockBarrier.setBlock(world, pos, 200, true, player);
        }
    }
}

