/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.entity.EntityIllusion;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPlayerSync;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.registry.WitcheryIdentityRegistry;
import net.msrandom.witchery.util.WitcheryUtils;

public class Infusion {
    public static final WitcheryIdentityRegistry<ResourceLocation, Infusion> REGISTRY = new WitcheryIdentityRegistry(4);
    public static final Infusion DEFUSED = new Infusion();
    public static final String INFUSION_NEXTSYNC = "WitcheryResyncLook";

    public static void dropEntityItemWithRandomChoice(EntityLivingBase entity, ItemStack par1ItemStack, boolean par2) {
        if (par1ItemStack.isEmpty() || entity == null) {
            return;
        }
        EntityItem entityitem = new EntityItem(entity.world, entity.posX, entity.posY - (double)0.3f + (double)entity.getEyeHeight(), entity.posZ, par1ItemStack);
        entityitem.setPickupDelay(40);
        if (par2) {
            float f2 = entity.world.rand.nextFloat() * 0.5f;
            float f3 = entity.world.rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.motionX = -MathHelper.sin((float)f3) * f2;
            entityitem.motionZ = MathHelper.cos((float)f3) * f2;
            entityitem.motionY = 0.2f;
        } else {
            float f = 0.3f;
            entityitem.motionX = -MathHelper.sin((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            entityitem.motionZ = MathHelper.cos((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f;
            entityitem.motionY = -MathHelper.sin((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f2 = entity.world.rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.motionX += Math.cos(f2) * (double)(f *= entity.world.rand.nextFloat());
            entityitem.motionY += (double)((entity.world.rand.nextFloat() - entity.world.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f2) * (double)f;
        }
        entity.world.spawnEntity((Entity)entityitem);
    }

    public static EntityCreature spawnCreature(World world, Class<? extends EntityCreature> creatureType, EntityLivingBase victim, int minRange, int maxRange, EnumParticleTypes effect, SoundEvent effectSound) {
        return Infusion.spawnCreature(world, creatureType, victim.getPosition(), victim, minRange, maxRange, effect, effectSound);
    }

    public static void spawnCreature(World world, Class<? extends EntityCreature> creatureType, BlockPos pos, EntityPlayer victim, int minRange, int maxRange) {
        Infusion.spawnCreature(world, creatureType, pos, (EntityLivingBase)victim, minRange, maxRange, null, null);
    }

    public static EntityCreature spawnCreature(World world, Class<? extends EntityCreature> creatureType, BlockPos pos, EntityLivingBase victim, int minRange, int maxRange, EnumParticleTypes effect, @Nullable SoundEvent effectSound) {
        if (!world.isRemote) {
            int hy;
            int az;
            int activeRadius = maxRange - minRange;
            int ax = world.rand.nextInt(activeRadius * 2 + 1);
            if (ax > activeRadius) {
                ax += minRange * 2;
            }
            if ((az = world.rand.nextInt(activeRadius * 2 + 1)) > activeRadius) {
                az += minRange * 2;
            }
            BlockPos p = pos.add(ax - maxRange, 0, az - maxRange);
            while (!world.isAirBlock(p) && p.getY() < pos.getY() + 8) {
                p = p.up();
            }
            while (world.isAirBlock(p) && p.getY() > 0) {
                p = p.down();
            }
            for (hy = 0; world.isAirBlock(p.up(hy + 1)) && hy < 6; ++hy) {
            }
            if (hy >= 2) {
                try {
                    Constructor<? extends EntityCreature> ctor = creatureType.getConstructor(World.class);
                    EntityCreature creature = ctor.newInstance(world);
                    if (victim instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)victim;
                        if (creature instanceof EntityIllusion) {
                            ((EntityIllusion)creature).setVictimId(player.getUniqueID());
                        } else if (creature instanceof EntityNightmare) {
                            ((EntityNightmare)creature).setVictimId(player.getUniqueID());
                            creature.setAttackTarget(victim);
                        }
                    }
                    double x = (double)p.getX() + 0.5;
                    double y = (double)p.getY() + 1.05;
                    double z = (double)p.getZ() + 0.5;
                    creature.setLocationAndAngles(x, y, z, 0.0f, 0.0f);
                    world.spawnEntity((Entity)creature);
                    if (effect != null) {
                        if (effectSound != null) {
                            world.playSound(null, x, y, z, effectSound, creature.getSoundCategory(), 0.5f, 0.4f / ((float)world.rand.nextDouble() * 0.4f + 0.8f));
                        }
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(x, y, z, 1.0f, creature.height, effect), world, x, y, z, 16.0);
                    }
                    return creature;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isOnCooldown(World world, ItemStack stack) {
        NBTTagCompound nbtTag;
        if (!world.isRemote && (nbtTag = stack.getTagCompound()) != null && nbtTag.hasKey("WitcheryCooldown")) {
            long currentTime = MinecraftServer.getCurrentTimeMillis();
            return currentTime < nbtTag.getLong("WitcheryCooldown");
        }
        return false;
    }

    public static void setCooldown(World world, ItemStack stack, int milliseconds) {
        if (!world.isRemote) {
            NBTTagCompound nbtTag;
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            if ((nbtTag = stack.getTagCompound()) != null) {
                long currentTime = MinecraftServer.getCurrentTimeMillis();
                nbtTag.setLong("WitcheryCooldown", currentTime + (long)milliseconds);
            }
        }
    }

    @Deprecated
    public static void setCurrentEnergy(EntityPlayer player, int currentEnergy) {
        if (!player.world.isRemote) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            playerEx.infusionPower = new InfusionPower(playerEx.infusionPower.getInfusionType(), currentEnergy, playerEx.infusionPower.getMaxPower());
            Infusion.syncPlayer(player.world, player);
        }
    }

    public static void syncPlayer(World world, EntityPlayer player) {
        if (!world.isRemote) {
            WitcheryNetworkChannel.sendTo(new PacketPlayerSync(player), (EntityPlayerMP)player);
        }
    }

    @Deprecated
    public static int getCurrentEnergy(EntityPlayer player) {
        return WitcheryUtils.getExtension((EntityPlayer)player).infusionPower.getCurrentPower();
    }

    @Deprecated
    public static int getMaxEnergy(EntityPlayer player) {
        return WitcheryUtils.getExtension((EntityPlayer)player).infusionPower.getMaxPower();
    }

    public static void reducePowerLevels(EntityLivingBase entity, float reduction) {
        if (!entity.world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int maxEnergy = Infusion.getMaxEnergy(player);
            int currentEnergy = Infusion.getCurrentEnergy(player);
            if (maxEnergy > 0 && currentEnergy > 0) {
                Infusion.setCurrentEnergy(player, Math.min(currentEnergy - Math.min((int)((float)maxEnergy * reduction), 1), 0));
            }
        }
        IntegrationManager.reduceMagicPower(entity, reduction);
    }

    public static boolean acquireEnergy(World world, EntityPlayer player, int cost, boolean showMessages) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        if (playerEx.infusionPower.getInfusionType() == DEFUSED) {
            if (showMessages) {
                player.sendMessage(new TextComponentTranslation("infusion.witchery.no_infusion", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
            return false;
        }
        if (player.capabilities.isCreativeMode || playerEx.infusionPower.getCurrentPower() >= cost) {
            if (!player.capabilities.isCreativeMode) {
                Infusion.setCurrentEnergy(player, playerEx.infusionPower.getCurrentPower() - cost);
            }
            return true;
        }
        if (showMessages) {
            player.sendMessage(new TextComponentTranslation("infusion.witchery.insufficient_infusion_power", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
        return false;
    }

    public void onHurt(EntityPlayer player, LivingHurtEvent event) {
    }

    public void onFalling(World world, EntityPlayer player, LivingFallEvent event) {
    }

    public boolean isValidForSpells() {
        return false;
    }

    protected boolean consumeCharges(World world, EntityPlayer player, int cost) {
        if (player.capabilities.isCreativeMode) {
            return true;
        }
        int charges = Infusion.getCurrentEnergy(player);
        if (charges - cost < 0) {
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            Infusion.clearInfusion(player);
            return false;
        }
        Infusion.setCurrentEnergy(player, charges - cost);
        return true;
    }

    public void onLeftClickEntity(World world, EntityPlayer player, Entity otherEntity) {
        if (!world.isRemote) {
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    public int getMaxItemUseDuration() {
        return 400;
    }

    public void onUsingItemTick(World world, EntityPlayer player, int countdown) {
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer player, int countdown) {
        if (!world.isRemote) {
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
        }
    }

    public void playSound(World world, EntityPlayer player, SoundEvent sound) {
        WitcheryUtils.playSoundAt(player, sound, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
    }

    public void playFailSound(World world, EntityPlayer player) {
        this.playSound(world, player, SoundEvents.BLOCK_NOTE_SNARE);
    }

    public static void clearInfusion(EntityPlayer player) {
        DEFUSED.infuse(player, 0);
    }

    public void infuse(EntityPlayer player, int charges) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        playerEx.infusionPower = new InfusionPower(this, charges, charges);
        playerEx.creaturePower = null;
        if (!player.world.isRemote) {
            Infusion.syncPlayer(player.world, player);
        }
    }

    @Deprecated
    public static Infusion getInfusion(EntityPlayer $this$getInfusion) {
        return WitcheryUtils.getExtension((EntityPlayer)$this$getInfusion).infusionPower.getInfusionType();
    }

    public String getTranslationKey() {
        ResourceLocation key = (ResourceLocation)REGISTRY.getKey(this);
        return key == null ? "infusion.witchery.unknown" : "infusion." + key.getNamespace() + "." + key.getPath();
    }
}

