/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.infusion;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.infusion.creature.CreaturePower;
import net.msrandom.witchery.infusion.creature.CreaturePowerData;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.resources.CreaturePowerManager;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lnet/msrandom/witchery/infusion/InfernalInfusion;", "Lnet/msrandom/witchery/infusion/Infusion;", "()V", "isValidForSpells", "", "onFalling", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "event", "Lnet/minecraftforge/event/entity/living/LivingFallEvent;", "onHurt", "Lnet/minecraftforge/event/entity/living/LivingHurtEvent;", "onLeftClickEntity", "otherEntity", "Lnet/minecraft/entity/Entity;", "onPlayerStoppedUsing", "itemstack", "Lnet/minecraft/item/ItemStack;", "countdown", "", "trySacrificeCreature", "creature", "Lnet/minecraft/entity/EntityLiving;", "Companion", "WitcheryResurrected"})
public final class InfernalInfusion
extends Infusion {
    private static final int MAX_CHARGES = 20;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isValidForSpells() {
        return true;
    }

    @Override
    public void onLeftClickEntity(@NotNull World world, @NotNull EntityPlayer player, @NotNull Entity otherEntity) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)otherEntity, (String)"otherEntity");
        if (!world.isRemote && otherEntity instanceof EntityLivingBase) {
            if (player.isSneaking()) {
                if (PotionEnslaved.canCreatureBeEnslaved((EntityLivingBase)otherEntity)) {
                    EntityLiving entityLiving = (EntityLiving)otherEntity;
                    if (PotionEnslaved.isMobEnslavedBy(entityLiving, player)) {
                        if (this.consumeCharges(world, player, 1)) {
                            this.trySacrificeCreature(world, player, entityLiving);
                        }
                    } else if (this.consumeCharges(world, player, 5)) {
                        PotionEnslaved.setEnslaverForMob(entityLiving, player);
                        EntityUtil.dropAttackTarget((EntityLiving)otherEntity);
                        entityLiving.world.playSound(null, entityLiving.getPosition(), SoundEvents.ENTITY_ZOMBIE_INFECT, player.getSoundCategory(), 0.5f, 0.4f / (entityLiving.world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL, entityLiving.posX, entityLiving.posY, entityLiving.posZ, 0.0, 20, 1.0, 2.0);
                    }
                } else {
                    SoundEvent soundEvent = SoundEvents.BLOCK_NOTE_SNARE;
                    Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.BLOCK_NOTE_SNARE");
                    WitcheryUtils.playSoundAt(player, soundEvent, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            } else {
                int r = 50;
                if (this.consumeCharges(world, player, 1)) {
                    int minionCount = 0;
                    AxisAlignedBB bounds = new AxisAlignedBB(player.posX - (double)r, player.posY - 15.0, player.posZ - (double)r, player.posX + (double)r, player.posY + 15.0, player.posZ + (double)r);
                    for (EntityLiving nearbyLivingEntity : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                        if (!PotionEnslaved.isMobEnslavedBy(nearbyLivingEntity, player)) continue;
                        ++minionCount;
                        EntityLiving entityLiving = nearbyLivingEntity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)entityLiving, (String)"nearbyLivingEntity");
                        entityLiving.setAttackTarget((EntityLivingBase)otherEntity);
                        if (!(nearbyLivingEntity instanceof EntityCreature)) continue;
                        ((EntityCreature)nearbyLivingEntity).setRevengeTarget((EntityLivingBase)otherEntity);
                        if (!(nearbyLivingEntity instanceof EntityZombie) && !(nearbyLivingEntity instanceof EntityCreeper)) continue;
                        nearbyLivingEntity.tasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)nearbyLivingEntity, ((EntityLivingBase)otherEntity).getClass(), false));
                    }
                    if (minionCount > 0) {
                        world.playSound(null, ((EntityLivingBase)otherEntity).getPosition(), SoundEvents.ENTITY_PLAYER_BREATH, SoundCategory.PLAYERS, 0.5f, 0.4f / (otherEntity.world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryUtils.addNewParticles(world, EnumParticleTypes.CRIT, otherEntity.posX, otherEntity.posY, otherEntity.posZ, 0.0, 20, 0.5, 2.0);
                    }
                }
            }
        }
    }

    private final void trySacrificeCreature(World world, EntityPlayer player, EntityLiving creature) {
        CreaturePower power = CreaturePowerManager.INSTANCE.getPower((Entity)creature);
        if (power != null) {
            CreaturePowerData creaturePower;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            CreaturePowerData creaturePowerData = creaturePower = playerEx.creaturePower;
            playerEx.creaturePower = Intrinsics.areEqual((Object)(creaturePowerData != null ? creaturePowerData.getPower() : null), (Object)power) ? new CreaturePowerData(creaturePower.getEntityType(), RangesKt.coerceAtMost((int)(creaturePower.getCharges() + power.getSacrificeCharges()), (int)20)) : new CreaturePowerData(creature.getClass(), power.getSacrificeCharges());
            Infusion.syncPlayer(world, player);
            creature.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)((Entity)player), null), creature.getHealth() + 1.0f);
        } else {
            this.playFailSound(world, player);
        }
    }

    @Override
    public void onHurt(@NotNull EntityPlayer player, @NotNull LivingHurtEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Object object = WitcheryUtils.getExtension((EntityPlayer)player).creaturePower;
        if (object != null && (object = ((CreaturePowerData)object).getPower()) != null && (object = ((CreaturePower)object).getAbilities()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreatureAbility it = (CreatureAbility)element$iv;
                boolean bl = false;
                it.onDamage(player.world, player, event);
            }
        }
    }

    @Override
    public void onFalling(@NotNull World world, @NotNull EntityPlayer player, @NotNull LivingFallEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Object object = WitcheryUtils.getExtension((EntityPlayer)player).creaturePower;
        if (object != null && (object = ((CreaturePowerData)object).getPower()) != null && (object = ((CreaturePower)object).getAbilities()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreatureAbility it = (CreatureAbility)element$iv;
                boolean bl = false;
                it.onFalling(world, player, event);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPlayerStoppedUsing(@NotNull ItemStack itemstack, @NotNull World world, @NotNull EntityPlayer player, int countdown) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (!world.isRemote) {
            int elapsedTicks = this.getMaxItemUseDuration() - countdown;
            RayTraceResult hit = OtherwhereInfusion.doCustomRayTrace(world, player, true, 15.0);
            if (player.isSneaking()) {
                if (hit != null) {
                    if (hit.typeOfHit == RayTraceResult.Type.ENTITY) {
                        this.playFailSound(world, player);
                    } else if (hit.typeOfHit == RayTraceResult.Type.BLOCK && hit.sideHit == EnumFacing.UP) {
                        int minionCount = 0;
                        int r = 50;
                        AxisAlignedBB bounds = new AxisAlignedBB(player.posX - (double)r, player.posY - (double)15, player.posZ - (double)r, player.posX + (double)r, player.posY + (double)15, player.posZ + (double)r);
                        for (EntityLiving creature : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                            EntityLiving entityLiving = creature;
                            if (!(entityLiving instanceof EntityCreature)) {
                                entityLiving = null;
                            }
                            EntityCreature creature2 = (EntityCreature)entityLiving;
                            if (!PotionEnslaved.isMobEnslavedBy(creature, player)) continue;
                            ++minionCount;
                            EntityLiving entityLiving2 = creature;
                            Intrinsics.checkExpressionValueIsNotNull((Object)entityLiving2, (String)"creature");
                            entityLiving2.setAttackTarget((EntityLivingBase)null);
                            creature.setRevengeTarget((EntityLivingBase)null);
                            if (!(creature instanceof EntitySpider)) {
                                PathNavigate pathNavigate = creature.getNavigator();
                                BlockPos blockPos = hit.getBlockPos();
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"hit.blockPos");
                                double d = blockPos.getX();
                                BlockPos blockPos2 = hit.getBlockPos();
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"hit.blockPos");
                                double d2 = (double)blockPos2.getY() + 1.0;
                                BlockPos blockPos3 = hit.getBlockPos();
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"hit.blockPos");
                                if (pathNavigate.tryMoveToXYZ(d, d2, (double)blockPos3.getZ(), 1.0)) continue;
                            }
                            if (creature2 == null) continue;
                            creature2.getNavigator().getPathToPos(hit.getBlockPos());
                        }
                        if (minionCount > 0) {
                            BlockPos blockPos = hit.getBlockPos();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"hit.blockPos");
                            double d = blockPos.getX();
                            BlockPos blockPos4 = hit.getBlockPos();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"hit.blockPos");
                            double d3 = (double)blockPos4.getY() + 1.0;
                            BlockPos blockPos5 = hit.getBlockPos();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"hit.blockPos");
                            world.playSound(null, d, d3, (double)blockPos5.getZ(), SoundEvents.ENTITY_ITEM_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                            BlockPos blockPos6 = hit.getBlockPos();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"hit.blockPos");
                            double d4 = blockPos6.getX();
                            BlockPos blockPos7 = hit.getBlockPos();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos7, (String)"hit.blockPos");
                            double d5 = (double)blockPos7.getY() + 1.0;
                            BlockPos blockPos8 = hit.getBlockPos();
                            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos8, (String)"hit.blockPos");
                            WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_INSTANT, d4, d5, blockPos8.getZ(), 0.0, 20, 0.5, 2.0);
                        }
                    }
                } else {
                    this.playFailSound(world, player);
                }
            } else {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                CreaturePowerData creaturePower = playerEx.creaturePower;
                if (creaturePower != null) {
                    Iterable $this$sumBy$iv = creaturePower.getPower().getAbilities();
                    boolean $i$f$sumBy = false;
                    int sum$iv = 0;
                    for (Object element$iv : $this$sumBy$iv) {
                        void it;
                        CreatureAbility creatureAbility = (CreatureAbility)element$iv;
                        int n = sum$iv;
                        boolean bl = false;
                        int n2 = it.activateCost(world, player, elapsedTicks, hit);
                        sum$iv = n + n2;
                    }
                    int cost = sum$iv + 1;
                    if (creaturePower.getCharges() - cost >= 0 && this.consumeCharges(world, player, 1)) {
                        for (CreatureAbility ability : creaturePower.getPower().getAbilities()) {
                            ability.onActivate(world, player, elapsedTicks, hit);
                        }
                        if (!player.capabilities.isCreativeMode) {
                            playerEx.creaturePower = new CreaturePowerData(creaturePower.getEntityType(), creaturePower.getCharges() - cost);
                            Infusion.syncPlayer(world, player);
                        }
                    } else {
                        this.playFailSound(world, player);
                    }
                } else {
                    this.playFailSound(world, player);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/infusion/InfernalInfusion$Companion;", "", "()V", "MAX_CHARGES", "", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

