/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.extensions;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.extensions.WitcheryExtendedData;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.network.PacketExtendedVillagerSync;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.ResizingUtils;

public class VillagerExtendedData
extends WitcheryExtendedData<EntityVillager> {
    private int blood = 500;
    private boolean sleeping;
    private int sleepingTicks;

    @Override
    public void write(NBTTagCompound tag) {
        tag.setInteger("Blood", this.blood);
    }

    @Override
    public void read(NBTTagCompound tag) {
        this.blood = MathHelper.clamp((int)tag.getInteger("Blood"), (int)0, (int)500);
    }

    public int takeBlood(int quantity, EntityLivingBase player) {
        boolean isKnockedOut;
        PotionEffect potionEffect = ((EntityVillager)this.entity).getActivePotionEffect(WitcheryPotionEffects.PARALYSED);
        boolean bl = isKnockedOut = this.isSleeping() || potionEffect != null && potionEffect.getAmplifier() >= 4;
        if (!isKnockedOut) {
            quantity = (int)Math.ceil(0.66f * (float)quantity);
        }
        int remainder = Math.max(this.blood - quantity, 0);
        int taken = this.blood - remainder;
        this.setBlood(remainder);
        if (player instanceof EntityPlayer) {
            if (this.blood < (int)Math.ceil(250.0)) {
                ((EntityVillager)this.entity).attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.MAGIC.getDamageType(), (Entity)player), 1.3f);
            } else if (!isKnockedOut) {
                ((EntityVillager)this.entity).attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.MAGIC.getDamageType(), (Entity)player), 0.1f);
            }
        }
        return taken;
    }

    public void giveBlood(int quantity) {
        if (this.blood < 500) {
            this.setBlood(this.blood + quantity);
        }
    }

    public int getBlood() {
        return this.blood;
    }

    public void setBlood(int blood) {
        if (this.blood != blood) {
            this.blood = Math.max(Math.min(blood, 500), 0);
            this.sync();
        }
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    public void setSleeping(boolean sleeping) {
        if (this.sleeping != sleeping) {
            this.sleeping = sleeping;
            if (this.sleeping) {
                ResizingUtils.setSize(this.entity, 0.8f, 1.1f);
            } else {
                ResizingUtils.setSize(this.entity, 0.6f, 1.8f);
                if (this.sleepingTicks >= 2400) {
                    ((EntityVillager)this.entity).setHealth(((EntityVillager)this.entity).getMaxHealth());
                }
                if (this.sleepingTicks > 1200) {
                    this.giveBlood(this.sleepingTicks / 24);
                }
            }
            this.sleepingTicks = 0;
            this.sync();
        }
    }

    public void incrementSleepingTicks() {
        ++this.sleepingTicks;
    }

    public void sync() {
        if (!((EntityVillager)this.entity).world.isRemote && ((EntityVillager)this.entity).getHealth() > 0.0f && !((EntityVillager)this.entity).isDead) {
            WitcheryNetworkChannel.sendToAll(new PacketExtendedVillagerSync(this));
        }
    }
}

