/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.extensions;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.events.EventArgs;
import net.msrandom.witchery.common.CovenWitchData;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.entity.familiar.FamiliarInstance;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.extensions.WitcheryExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.PlayerEffects;
import net.msrandom.witchery.infusion.creature.CreaturePowerData;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.items.WitcheryBookItems;
import net.msrandom.witchery.network.PacketExtendedPlayerSync;
import net.msrandom.witchery.network.PacketPartialExtendedPlayerSync;
import net.msrandom.witchery.network.PacketPlayerStyle;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.prediction.Prediction;
import net.msrandom.witchery.prediction.PredictionData;
import net.msrandom.witchery.resources.CovenQuestManager;
import net.msrandom.witchery.resources.PredictionManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.Transformation;
import net.msrandom.witchery.transformation.TransformationType;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerExtendedData
extends WitcheryExtendedData<EntityPlayer> {
    public static final int MAX_HUMAN_BLOOD = 500;
    private static final long COOLDOWN_ESCAPE_1_TICKS = 6000L;
    private static final long COOLDOWN_ESCAPE_2_TICKS = 72000L;
    public final Map<TransformationType<?>, Transformation> transformations = new HashMap();
    private final ConcurrentMap<Potion, PotionEffect> incurablePotionEffectCache = new ConcurrentHashMap<Potion, PotionEffect>();
    private final Object2IntMap<PlayerEffects.PlayerEffect> playerEffects = new Object2IntOpenHashMap();
    public int cachedWorship = -1;
    private boolean getPlayerData;
    private boolean resetSleep;
    private int cachedSky;
    private long mirrorWorldEscapeCooldown1 = Long.MIN_VALUE;
    private long mirrorWorldEscapeCooldown2 = Long.MIN_VALUE;
    private int bottlingSkill;
    private int throwingSkill;
    @Nullable
    private AlternateForm currentForm;
    @Nullable
    public FamiliarInstance familiar;
    @NotNull
    public InfusionPower infusionPower = new InfusionPower(Infusion.DEFUSED, 0, 0);
    @Nullable
    public CreaturePowerData creaturePower;
    public final Set<CovenWitchData> coven = new LinkedHashSet<CovenWitchData>();
    public final List<PredictionData> predictions = new ArrayList<PredictionData>();
    public final Set<PotionEffect> permanentEffects = new HashSet<PotionEffect>();
    private boolean visitedNether;
    private boolean isFortuneTeller;
    private int humanBlood;
    private String lastPlayerSkin;
    private ResourceLocation locationSkin;
    private NBTTagList cachedInventory;
    private boolean inventoryCanBeRestored;
    private BlockPos mirrorWorldEntryPoint;
    private SpiritWorldData spiritData;
    private TormentWorldData tormentData;
    public int grotesqueTicks;

    @Override
    public void write(NBTTagCompound tag) {
        ResourceLocation form;
        tag.setInteger("BottlingSkill", this.bottlingSkill);
        tag.setInteger("ThrowingSkill", this.throwingSkill);
        if (this.currentForm != null && (form = (ResourceLocation)AlternateForm.REGISTRY.getKey(this.currentForm)) != null) {
            tag.setString("Form", form.toString());
        }
        if (this.familiar != null) {
            NBTTagCompound familiarTag = new NBTTagCompound();
            familiarTag.setString("Type", EntityList.getKey(this.familiar.getEntityType()).toString());
            familiarTag.setTag("Data", (NBTBase)this.familiar.getData());
            familiarTag.setByte("Color", (byte)this.familiar.getColor().getMetadata());
            familiarTag.setBoolean("Summoned", this.familiar.isSummoned());
            tag.setTag("Familiar", (NBTBase)familiarTag);
        }
        if (this.infusionPower.getInfusionType() != Infusion.DEFUSED) {
            NBTTagCompound infusionTag = new NBTTagCompound();
            infusionTag.setString("ID", ((ResourceLocation)Infusion.REGISTRY.getKey(this.infusionPower.getInfusionType())).toString());
            infusionTag.setInteger("CurrentPower", this.infusionPower.getCurrentPower());
            infusionTag.setInteger("MaxPower", this.infusionPower.getMaxPower());
            tag.setTag("Infusion", (NBTBase)infusionTag);
        }
        if (this.creaturePower != null) {
            NBTTagCompound creaturePowerTag = new NBTTagCompound();
            creaturePowerTag.setString("ID", EntityList.getKey(this.creaturePower.getEntityType()).toString());
            creaturePowerTag.setInteger("Charges", this.creaturePower.getCharges());
            tag.setTag("CreatureAbility", (NBTBase)creaturePowerTag);
        }
        tag.setBoolean("VisitedNether", this.hasVisitedNether());
        tag.setBoolean("FortuneTeller", this.isFortuneTeller());
        NBTTagList covenWitches = new NBTTagList();
        NBTTagList predictionData = new NBTTagList();
        NBTTagList permanentEffectData = new NBTTagList();
        for (CovenWitchData covenWitchData : this.coven) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setString("Name", covenWitchData.getName());
            nBTTagCompound.setInteger("Variant", covenWitchData.getVariant());
            nBTTagCompound.setUniqueId("ID", covenWitchData.getId());
            ResourceLocation quest = CovenQuestManager.INSTANCE.getRegistry().getKey(covenWitchData.getQuest());
            if (quest != null) {
                nBTTagCompound.setString("Quest", quest.toString());
            }
            covenWitches.appendTag((NBTBase)nBTTagCompound);
        }
        for (PredictionData predictionData2 : this.predictions) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            ResourceLocation id = PredictionManager.INSTANCE.getRegistry().getKey(predictionData2.getPrediction());
            if (id == null) continue;
            nBTTagCompound.setString("ID", id.toString());
            nBTTagCompound.setInteger("Time", predictionData2.getTicks());
            predictionData.appendTag((NBTBase)nBTTagCompound);
        }
        for (PotionEffect potionEffect : this.permanentEffects) {
            permanentEffectData.appendTag((NBTBase)potionEffect.writeCustomPotionEffectToNBT(new NBTTagCompound()));
        }
        tag.setTag("Coven", (NBTBase)covenWitches);
        tag.setTag("Predictions", (NBTBase)predictionData);
        tag.setTag("PermanentEffects", (NBTBase)permanentEffectData);
        NBTTagCompound transformationsTag = new NBTTagCompound();
        for (Map.Entry<TransformationType<?>, Transformation> entry2 : this.transformations.entrySet()) {
            if (entry2.getValue().getLevel() <= 0) continue;
            NBTTagCompound transformationTag = new NBTTagCompound();
            entry2.getValue().serialize(transformationTag);
            transformationsTag.setTag(((ResourceLocation)TransformationType.REGISTRY.getKey(entry2.getKey())).toString(), (NBTBase)transformationTag);
        }
        tag.setTag("Transformations", (NBTBase)transformationsTag);
        tag.setInteger("HumanBlood", this.humanBlood);
        if (this.cachedInventory != null) {
            tag.setTag("CachedInventory", (NBTBase)this.cachedInventory.copy());
            tag.setBoolean("CanRestoreInventory", this.inventoryCanBeRestored);
        }
        if (this.mirrorWorldEntryPoint != null) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setInteger("posX", this.mirrorWorldEntryPoint.getX());
            nBTTagCompound.setInteger("posY", this.mirrorWorldEntryPoint.getY());
            nBTTagCompound.setInteger("posZ", this.mirrorWorldEntryPoint.getZ());
            tag.setTag("MirrorWorldEntryPoint", (NBTBase)nBTTagCompound);
        }
        if (this.lastPlayerSkin != null) {
            tag.setString("LastPlayerSkin", this.lastPlayerSkin);
        }
        tag.setLong("MirrorEscape1", this.mirrorWorldEscapeCooldown1);
        tag.setLong("MirrorEscape2", this.mirrorWorldEscapeCooldown2);
        this.getSpiritData().write(tag);
        this.getTormentData().write(tag);
    }

    @Override
    public void read(NBTTagCompound tag) {
        int i;
        this.bottlingSkill = tag.getInteger("BottlingSkill");
        if (tag.hasKey("Form")) {
            this.currentForm = (AlternateForm)AlternateForm.REGISTRY.get(new ResourceLocation(tag.getString("Form")));
        }
        if (tag.hasKey("Familiar")) {
            NBTTagCompound familiarTag = tag.getCompoundTag("Familiar");
            Class type = EntityList.getClass((ResourceLocation)new ResourceLocation(familiarTag.getString("Type")));
            this.familiar = new FamiliarInstance(FamiliarType.REGISTRY.get(type), type, familiarTag.getCompoundTag("Data"), EnumDyeColor.byMetadata((int)familiarTag.getByte("Color")), familiarTag.getBoolean("Summoned"));
        }
        if (tag.hasKey("Infusion")) {
            NBTTagCompound infusionTag = tag.getCompoundTag("Infusion");
            this.infusionPower = new InfusionPower((Infusion)Infusion.REGISTRY.get(new ResourceLocation(infusionTag.getString("ID"))), infusionTag.getInteger("CurrentPower"), infusionTag.getInteger("MaxPower"));
        }
        if (tag.hasKey("CreatureAbility")) {
            NBTTagCompound creaturePowerTag = tag.getCompoundTag("CreatureAbility");
            this.creaturePower = new CreaturePowerData(EntityList.getClass((ResourceLocation)new ResourceLocation(creaturePowerTag.getString("ID"))), creaturePowerTag.getInteger("Charges"));
        }
        this.setVisitedNether(tag.getBoolean("VisitedNether"));
        this.setFortuneTeller(tag.getBoolean("FortuneTeller"));
        NBTTagList covenWitches = tag.getTagList("Coven", 10);
        NBTTagList predictionsData = tag.getTagList("Predictions", 10);
        NBTTagList permanentEffectData = tag.getTagList("PermanentEffects", 10);
        this.coven.clear();
        this.predictions.clear();
        this.permanentEffects.clear();
        for (i = 0; i < covenWitches.tagCount(); ++i) {
            NBTTagCompound witchData = covenWitches.getCompoundTagAt(i);
            this.coven.add(new CovenWitchData(witchData.getString("Name"), witchData.getInteger("Variant"), witchData.getUniqueId("ID"), witchData.hasKey("Quest") ? CovenQuestManager.INSTANCE.getRegistry().get(new ResourceLocation(witchData.getString("Quest"))) : null));
        }
        for (i = 0; i < predictionsData.tagCount(); ++i) {
            NBTTagCompound predictionTag = predictionsData.getCompoundTagAt(i);
            Prediction prediction = PredictionManager.INSTANCE.getRegistry().get(new ResourceLocation(predictionTag.getString("ID")));
            if (prediction == null) continue;
            PredictionData predictionData = new PredictionData(prediction);
            predictionData.setTicks(predictionTag.getInteger("Time"));
            this.predictions.add(predictionData);
        }
        for (i = 0; i < permanentEffectData.tagCount(); ++i) {
            this.permanentEffects.add(PotionEffect.readCustomPotionEffectFromNBT((NBTTagCompound)permanentEffectData.getCompoundTagAt(i)));
        }
        NBTTagCompound transformationsTag = tag.getCompoundTag("Transformations");
        for (String key : transformationsTag.getKeySet()) {
            TransformationType type = (TransformationType)TransformationType.REGISTRY.get(new ResourceLocation(key));
            Transformation transformation = (Transformation)type.getCreate().invoke((Object)this);
            transformation.deserialize(transformationsTag.getCompoundTag(key));
            this.transformations.put(type, transformation);
        }
        this.humanBlood = MathHelper.clamp((int)tag.getInteger("HumanBlood"), (int)0, (int)500);
        if (tag.hasKey("CachedInventory")) {
            this.cachedInventory = tag.getTagList("CachedInventory", 10);
            this.inventoryCanBeRestored = tag.getBoolean("CanRestoreInventory");
        }
        if (tag.hasKey("MirrorWorldEntryPoint")) {
            NBTTagCompound nbt = tag.getCompoundTag("DimCoords");
            BlockPos coord = null;
            if (nbt.hasKey("posX") && nbt.hasKey("posY") && nbt.hasKey("posZ")) {
                coord = new BlockPos(nbt.getInteger("posX"), nbt.getInteger("posY"), nbt.getInteger("posZ"));
            }
            this.mirrorWorldEntryPoint = coord;
        }
        if (tag.hasKey("LastPlayerSkin")) {
            this.lastPlayerSkin = tag.getString("LastPlayerSkin");
        }
        this.mirrorWorldEscapeCooldown1 = tag.getLong("MirrorEscape1");
        this.mirrorWorldEscapeCooldown2 = tag.getLong("MirrorEscape2");
        this.getSpiritData().read(tag);
        this.getTormentData().read(tag);
    }

    public String getOtherPlayerSkin() {
        return this.lastPlayerSkin == null ? "" : this.lastPlayerSkin;
    }

    public void setOtherPlayerSkin(String username) {
        this.lastPlayerSkin = username;
        this.locationSkin = null;
        this.sync();
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getOtherPlayerSkinLocation() {
        if (this.locationSkin == null) {
            String ownerName = this.getOtherPlayerSkin();
            this.locationSkin = ownerName.isEmpty() ? null : AbstractClientPlayer.getLocationSkin((String)ownerName);
        }
        return this.locationSkin;
    }

    public void cachePlayerInventory() {
        this.inventoryCanBeRestored = true;
    }

    public void backupPlayerInventory() {
        NBTTagList nbtInventory = new NBTTagList();
        ((EntityPlayer)this.entity).inventory.writeToNBT(nbtInventory);
        this.cachedInventory = nbtInventory;
    }

    public void restorePlayerInventoryFrom(PlayerExtendedData original) {
        if (original.cachedInventory != null && original.inventoryCanBeRestored) {
            ((EntityPlayer)this.entity).inventory.readFromNBT(original.cachedInventory);
        }
    }

    public int getBottlingSkill() {
        return this.bottlingSkill;
    }

    public void increaseBottlingSkill() {
        this.bottlingSkill = Math.min(this.bottlingSkill + 1, 100);
        if (this.bottlingSkill % 30 == 0) {
            ((EntityPlayer)this.entity).sendMessage((ITextComponent)new TextComponentTranslation("brew.witchery.brewing_skill_increase", new Object[0]));
        }
    }

    public int getThrowingSkill() {
        return this.bottlingSkill;
    }

    public int increaseThrowingSkill() {
        return this.getThrowingSkill();
    }

    public int getHumanBlood() {
        return this.humanBlood;
    }

    public void setHumanBlood(int blood) {
        if (this.humanBlood != blood) {
            this.humanBlood = MathHelper.clamp((int)blood, (int)0, (int)500);
            if (!((EntityPlayer)this.entity).world.isRemote) {
                WitcheryNetworkChannel.sendToAll(new PacketPartialExtendedPlayerSync(this, (EntityPlayer)this.entity));
            }
        }
    }

    public int takeHumanBlood(int quantity, EntityLivingBase attacker) {
        if (!((EntityPlayer)this.entity).isPlayerSleeping()) {
            quantity = (int)Math.ceil(0.66f * (float)quantity);
        }
        int remainder = Math.max(this.humanBlood - quantity, 0);
        int taken = this.humanBlood - remainder;
        this.setHumanBlood(remainder);
        if (this.humanBlood < (int)Math.ceil(250.0)) {
            ((EntityPlayer)this.entity).attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.MAGIC.getDamageType(), (Entity)attacker), 1.0f);
        } else if (!((EntityPlayer)this.entity).isPlayerSleeping()) {
            ((EntityPlayer)this.entity).attackEntityFrom((DamageSource)new EntityDamageSource(DamageSource.MAGIC.getDamageType(), (Entity)attacker), 0.1f);
        }
        return taken;
    }

    public void giveHumanBlood(int quantity) {
        if (this.humanBlood < 500) {
            this.setHumanBlood(this.humanBlood + quantity);
        }
    }

    public <T extends Transformation> T getTransformation(TransformationType<T> type) {
        return (T)this.transformations.computeIfAbsent(type, k -> (Transformation)k.getCreate().invoke((Object)this));
    }

    public boolean isTransformation(TransformationType<?> type) {
        return this.transformations.containsKey(type) && ((Transformation)this.getTransformation(type)).getLevel() > 0;
    }

    public void updateWorship() {
        if (this.cachedWorship >= 0) {
            ((EntityPlayer)this.entity).addPotionEffect(new PotionEffect(WitcheryPotionEffects.WORSHIP, 1200, this.cachedWorship, true, true));
            this.cachedWorship = -1;
        }
        this.processSync();
    }

    public void cacheIncurablePotionEffect(Collection<PotionEffect> activePotionEffects) {
        for (PotionEffect activeEffect : activePotionEffects) {
            WitcheryPotion potion;
            Potion potionID = activeEffect.getPotion();
            if (!(potionID instanceof WitcheryPotion) || activeEffect.getDuration() <= 5 || (potion = (WitcheryPotion)potionID).isCurable()) continue;
            this.incurablePotionEffectCache.put(activeEffect.getPotion(), activeEffect);
        }
    }

    public void clearCachedIncurablePotionEffect(Potion potion) {
        this.incurablePotionEffectCache.remove(potion);
    }

    public void restoreIncurablePotionEffects() {
        if (this.incurablePotionEffectCache.size() > 0) {
            Collection activeEffectList = ((EntityPlayer)this.entity).getActivePotionEffects();
            for (PotionEffect activeEffect : activeEffectList) {
                this.incurablePotionEffectCache.remove(activeEffect.getPotion());
            }
            for (PotionEffect restoredEffect : this.incurablePotionEffectCache.values()) {
                ((EntityPlayer)this.entity).addPotionEffect(new PotionEffect(restoredEffect));
            }
            this.incurablePotionEffectCache.clear();
        }
    }

    public void addWorship(int level) {
        this.cachedWorship = level;
    }

    public void sync() {
        if (!((EntityPlayer)this.entity).world.isRemote) {
            WitcheryNetworkChannel.sendTo(new PacketExtendedPlayerSync(this), (EntityPlayerMP)this.entity);
        }
    }

    @Nullable
    public AlternateForm getCurrentForm() {
        return this.currentForm;
    }

    public AlternateForm getEffectiveForm() {
        return this.getCurrentForm() == null ? WitcheryAlternateForms.PLAYER : this.getCurrentForm();
    }

    public void setCurrentForm(AlternateForm type) {
        if (this.currentForm != type) {
            AlternateForm old = this.currentForm;
            this.currentForm = type;
            if (!((EntityPlayer)this.entity).world.isRemote) {
                WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle((EntityPlayer)this.entity));
                ShapeShift.INSTANCE.initCurrentShift((EntityPlayer)this.entity);
            }
            AlternateForm.PLAYER_TRANSFORM_EVENT.accept((Object)this, (EventArgs)new AlternateForm.PlayerTransformEventArgs(type, old));
        }
    }

    public void scheduleSync() {
        this.getPlayerData = true;
    }

    public void processSync() {
        if (this.getPlayerData) {
            this.getPlayerData = false;
            for (EntityPlayer otherPlayer : ((EntityPlayer)this.entity).world.playerEntities) {
                if (otherPlayer == this.entity) continue;
                WitcheryNetworkChannel.sendTo(new PacketPlayerStyle(otherPlayer), (EntityPlayerMP)this.entity);
            }
        }
    }

    public void checkSleep(boolean start) {
        if (start) {
            if (this.isTransformation(WitcheryTransformations.VAMPIRE) && ((EntityPlayer)this.entity).isPlayerFullyAsleep() && ((EntityPlayer)this.entity).world.isDaytime()) {
                this.resetSleep = true;
                this.cachedSky = ((EntityPlayer)this.entity).world.getSkylightSubtracted();
                ((EntityPlayer)this.entity).world.setSkylightSubtracted(4);
            }
        } else if (this.resetSleep) {
            this.resetSleep = false;
            ((EntityPlayer)this.entity).world.setSkylightSubtracted(this.cachedSky);
        }
    }

    public boolean hasVampireBook() {
        for (ItemStack stack : ((EntityPlayer)this.entity).inventory.mainInventory) {
            if (stack.isEmpty() || stack.getItem() != WitcheryBookItems.IMMORTALS_OBSERVATIONS_BOOK) continue;
            return stack.hasTagCompound() && stack.getTagCompound().getInteger("Level") < 9;
        }
        return false;
    }

    public BlockPos getMirrorWorldEntryPoint() {
        return this.mirrorWorldEntryPoint;
    }

    public void setMirrorWorldEntryPoint(BlockPos pos) {
        this.mirrorWorldEntryPoint = pos;
    }

    public boolean isMirrorWorldEntryPoint(BlockPos pos) {
        return this.mirrorWorldEntryPoint == null || this.mirrorWorldEntryPoint.equals((Object)pos);
    }

    public boolean canEscapeMirrorWorld(int slot) {
        if (slot == 1) {
            return ((EntityPlayer)this.entity).world.getTotalWorldTime() < this.mirrorWorldEscapeCooldown1 + 6000L;
        }
        return slot != 2 || ((EntityPlayer)this.entity).world.getTotalWorldTime() < this.mirrorWorldEscapeCooldown2 + 72000L;
    }

    public void escapedMirrorWorld(int slot) {
        if (slot == 1) {
            this.mirrorWorldEscapeCooldown1 = ((EntityPlayer)this.entity).world.getTotalWorldTime();
        } else if (slot == 2) {
            this.mirrorWorldEscapeCooldown2 = ((EntityPlayer)this.entity).world.getTotalWorldTime();
        }
    }

    public long getCooldownSecs(int i) {
        if (i == 1) {
            return (this.mirrorWorldEscapeCooldown1 + 6000L - ((EntityPlayer)this.entity).world.getTotalWorldTime()) / 20L;
        }
        if (i == 2) {
            return (this.mirrorWorldEscapeCooldown2 + 72000L - ((EntityPlayer)this.entity).world.getTotalWorldTime()) / 20L;
        }
        return 0L;
    }

    public boolean isFortuneTeller() {
        return this.isFortuneTeller;
    }

    public void setFortuneTeller(boolean fortuneTeller) {
        this.isFortuneTeller = fortuneTeller;
    }

    public void setVisitedNether(boolean visitedNether) {
        this.visitedNether = visitedNether;
    }

    public boolean hasVisitedNether() {
        return this.visitedNether;
    }

    public SpiritWorldData getSpiritData() {
        if (this.spiritData == null) {
            this.spiritData = new SpiritWorldData((EntityPlayer)this.entity);
        }
        return this.spiritData;
    }

    public TormentWorldData getTormentData() {
        if (this.tormentData == null) {
            this.tormentData = new TormentWorldData();
        }
        return this.tormentData;
    }

    public void setTormentData(TormentWorldData tormentData) {
        this.tormentData = tormentData;
    }
}

