/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.passive.coven;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.passive.coven.CovenQuest;
import net.msrandom.witchery.entity.passive.coven.CovenQuestSerializer;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.resources.CovenQuestManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/msrandom/witchery/entity/passive/coven/FightPetCovenQuest;", "Lnet/msrandom/witchery/entity/passive/coven/CovenQuest;", "type", "Lnet/minecraft/entity/EntityType;", "item", "Lnet/minecraft/item/Item;", "equipment", "Ljava/util/EnumMap;", "Lnet/minecraft/inventory/EntityEquipmentSlot;", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/item/Item;Ljava/util/EnumMap;)V", "activate", "", "world", "Lnet/minecraft/world/World;", "witch", "Lnet/msrandom/witchery/entity/passive/coven/EntityCovenWitch;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "Serializer", "WitcheryResurrected"})
public final class FightPetCovenQuest
extends CovenQuest {
    private final EntityType<?> type;
    private final Item item;
    private final EnumMap<EntityEquipmentSlot, ItemStack> equipment;

    /*
     * WARNING - void declaration
     */
    @Override
    public void activate(@NotNull World world, @NotNull EntityCovenWitch witch, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)witch, (String)"witch");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Object pet = this.type.create(world);
        if (pet instanceof EntityLiving) {
            pet.setLocationAndAngles(witch.posX, witch.posY, witch.posZ, witch.rotationYaw, witch.rotationPitch);
            world.spawnEntity(pet);
            IAttributeInstance iAttributeInstance = ((EntityLiving)pet).getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
            Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"pet.getEntityAttribute(S\u2026terAttributes.MAX_HEALTH)");
            iAttributeInstance.setBaseValue(100.0);
            IAttributeInstance iAttributeInstance2 = ((EntityLiving)pet).getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
            Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"pet.getEntityAttribute(S\u2026Attributes.ATTACK_DAMAGE)");
            iAttributeInstance2.setBaseValue(5.0);
            Map map = this.equipment;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void slot;
                Map.Entry entry2;
                Map.Entry entry3 = entry2 = iterator.next();
                boolean bl2 = false;
                map = (EntityEquipmentSlot)entry3.getKey();
                entry3 = entry2;
                bl2 = false;
                ItemStack stack = (ItemStack)entry3.getValue();
                pet.setItemStackToSlot((EntityEquipmentSlot)slot, stack.copy());
            }
            ((EntityLiving)pet).setHealth(RangesKt.coerceAtLeast((float)((EntityLiving)pet).getMaxHealth(), (float)100.0f));
            if (!player.capabilities.isCreativeMode) {
                ((EntityLiving)pet).setAttackTarget((EntityLivingBase)player);
                ((EntityLiving)pet).setRevengeTarget((EntityLivingBase)player);
            }
            ItemStack stack = new ItemStack(this.item);
            ResourceLocation key = CovenQuestManager.INSTANCE.getRegistry().getKey(this);
            ((EntityLiving)pet).setCustomNameTag(new TextComponentTranslation("entity.witchery.coven_witch.pet", new Object[]{witch.getName()}).getFormattedText());
            ResourceLocation resourceLocation = key;
            ResourceLocation resourceLocation2 = key;
            stack.setStackDisplayName(new TextComponentTranslation("entity." + (resourceLocation != null ? resourceLocation.getNamespace() : null) + ".coven_witch." + (resourceLocation2 != null ? resourceLocation2.getPath() : null) + ".item", new Object[]{witch.getName()}).getFormattedText());
            WitcheryUtils.getOrCreateTag(stack).setUniqueId("WitcheryQuestOwnerID", witch.getUniqueID());
            NBTTagCompound extraDrops = new NBTTagCompound();
            stack.writeToNBT(extraDrops);
            NBTTagCompound data = ((EntityLiving)pet).getEntityData();
            if (!data.hasKey("WitcheryExtraDrops")) {
                data.setTag("WitcheryExtraDrops", (NBTBase)new NBTTagList());
            }
            data.getTagList("WitcheryExtraDrops", 10).appendTag((NBTBase)extraDrops);
            WitcheryUtils.addNewParticles(world, EnumParticleTypes.SPELL_MOB, ((Entity)pet).posX, ((Entity)pet).posY, ((Entity)pet).posZ, 0.0, 40, 2.0, 2.0);
        }
    }

    public FightPetCovenQuest(@NotNull EntityType<?> type, @NotNull Item item, @NotNull EnumMap<EntityEquipmentSlot, ItemStack> equipment) {
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull(equipment, (String)"equipment");
        super(null, 1);
        this.type = type;
        this.item = item;
        this.equipment = equipment;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/entity/passive/coven/FightPetCovenQuest$Serializer;", "Lnet/msrandom/witchery/entity/passive/coven/CovenQuestSerializer;", "Lnet/msrandom/witchery/entity/passive/coven/FightPetCovenQuest;", "()V", "read", "json", "Lcom/google/gson/JsonObject;", "WitcheryResurrected"})
    public static final class Serializer
    implements CovenQuestSerializer<FightPetCovenQuest> {
        public static final Serializer INSTANCE;

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FightPetCovenQuest read(@NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            EnumMap<EntityEquipmentSlot, ItemStack> equipment = new EnumMap<EntityEquipmentSlot, ItemStack>(EntityEquipmentSlot.class);
            JsonObject jsonObject = json.getAsJsonObject("equipment");
            if (jsonObject != null) {
                JsonObject jsonObject2 = jsonObject;
                boolean bl = false;
                boolean bl2 = false;
                JsonObject it = jsonObject2;
                boolean bl3 = false;
                Iterator iterator = it.entrySet().iterator();
                while (iterator.hasNext()) {
                    void var11_11;
                    void key;
                    Map.Entry entry2;
                    Map.Entry entry3 = entry2 = (Map.Entry)iterator.next();
                    boolean bl4 = false;
                    String string = (String)entry3.getKey();
                    entry3 = entry2;
                    bl4 = false;
                    JsonElement element = (JsonElement)entry3.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                    boolean bl5 = false;
                    void v1 = var11_11;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = v1.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                    EntityEquipmentSlot slot = EntityEquipmentSlot.valueOf((String)string2);
                    Map map = equipment;
                    JsonElement jsonElement = element;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"element");
                    JsonObject jsonObject3 = jsonElement.getAsJsonObject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject3, (String)"element.asJsonObject");
                    map.put(slot, WitcheryUtils.parseStack(jsonObject3));
                }
            }
            JsonElement jsonElement = json.get("pet");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json[\"pet\"]");
            EntityType<?> entityType = RegistryWrappers.ENTITIES.get(new ResourceLocation(jsonElement.getAsString()));
            if (entityType == null) {
                Intrinsics.throwNpe();
            }
            JsonElement jsonElement2 = json.get("drop");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json[\"drop\"]");
            Item item = RegistryWrappers.ITEMS.get(new ResourceLocation(jsonElement2.getAsString()));
            if (item == null) {
                Intrinsics.throwNpe();
            }
            return new FightPetCovenQuest(entityType, item, equipment);
        }

        private Serializer() {
        }

        static {
            Serializer serializer;
            INSTANCE = serializer = new Serializer();
        }
    }
}

