/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.passive.coven;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.common.CovenWitchData;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.ai.EntityAIMoveToRestrictionAndSit;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.passive.coven.CovenQuest;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.entity.passive.coven.WitchEntity;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.registry.WitcheryRegistry;
import net.msrandom.witchery.resources.CovenQuestManager;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.util.DataDelegate;
import net.msrandom.witchery.util.OptionalDataDelegate;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\f\u0018\u0000 r2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001rB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u00100\u001a\u00020\b2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000204H\u0014J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000206H\u0014J\u0018\u0010:\u001a\u0002042\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u000206H\u0016J\b\u0010>\u001a\u00020\bH\u0014J\u0012\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020@H\u0016J\b\u0010B\u001a\u000204H\u0014J\b\u0010C\u001a\u00020\bH\u0016J\n\u0010D\u001a\u0004\u0018\u00010EH\u0014J\u0012\u0010F\u001a\u0004\u0018\u00010E2\u0006\u0010G\u001a\u000208H\u0014J\b\u0010H\u001a\u00020IH\u0014J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020KH\u0002J\u0010\u0010M\u001a\u0002042\u0006\u0010N\u001a\u00020OH\u0017J\b\u0010P\u001a\u000204H\u0014J\u0010\u0010Q\u001a\u00020\b2\u0006\u00101\u001a\u000202H\u0002J\u0010\u0010R\u001a\u0002042\u0006\u0010S\u001a\u000208H\u0016J\u001c\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020W2\b\u0010X\u001a\u0004\u0018\u00010UH\u0016J\b\u0010Y\u001a\u000204H\u0016J\b\u0010Z\u001a\u000204H\u0002J\u0018\u0010[\u001a\u00020\b2\u0006\u00101\u001a\u0002022\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u0002042\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u0002042\u0006\u0010b\u001a\u00020cH\u0002J1\u0010d\u001a\u0002042\u0006\u0010L\u001a\u00020K2\u0006\u00101\u001a\u0002022\u0012\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020g0f\"\u00020gH\u0002\u00a2\u0006\u0002\u0010hJ\u0010\u0010i\u001a\u0002042\u0006\u0010j\u001a\u00020\bH\u0016J\u000e\u0010k\u001a\u0002042\u0006\u0010l\u001a\u00020\u0016J1\u0010m\u001a\u0002042\u0006\u0010L\u001a\u00020K2\u0006\u00101\u001a\u0002022\u0012\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020g0f\"\u00020gH\u0002\u00a2\u0006\u0002\u0010hJ\"\u0010n\u001a\u0002042\u0006\u0010o\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010K2\u0006\u00101\u001a\u000202H\u0002J\b\u0010p\u001a\u000204H\u0016J\u0010\u0010q\u001a\u0002042\u0006\u0010_\u001a\u00020`H\u0016R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR;\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\b0\b2\u000e\u0010\u0007\u001a\n \u000f*\u0004\u0018\u00010\b0\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R;\u0010\u001d\u001a\n \u000f*\u0004\u0018\u00010\u00160\u00162\u000e\u0010\u0007\u001a\n \u000f*\u0004\u0018\u00010\u00160\u00168B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u000e\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R/\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u0007\u001a\u0004\u0018\u00010#8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010+\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010,\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u000e\u001a\u0004\b-\u0010\u0018\"\u0004\b.\u0010\u001a\u00a8\u0006s"}, d2={"Lnet/msrandom/witchery/entity/passive/coven/EntityCovenWitch;", "Lnet/minecraft/entity/passive/EntityTameable;", "Lnet/minecraft/entity/IRangedAttackMob;", "Lnet/msrandom/witchery/entity/passive/coven/WitchEntity;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "<set-?>", "", "isDrinkingPotion", "()Z", "setDrinkingPotion", "(Z)V", "isDrinkingPotion$delegate", "Lnet/msrandom/witchery/util/DataDelegate;", "kotlin.jvm.PlatformType", "isQuestAccepted", "()Ljava/lang/Boolean;", "setQuestAccepted", "(Ljava/lang/Boolean;)V", "isQuestAccepted$delegate", "potionUseTimer", "", "getPotionUseTimer", "()I", "setPotionUseTimer", "(I)V", "quest", "Lnet/msrandom/witchery/entity/passive/coven/CovenQuest;", "questItemsNeeded", "getQuestItemsNeeded", "()Ljava/lang/Integer;", "setQuestItemsNeeded", "(Ljava/lang/Integer;)V", "questItemsNeeded$delegate", "Ljava/util/UUID;", "questOfferedTo", "getQuestOfferedTo", "()Ljava/util/UUID;", "setQuestOfferedTo", "(Ljava/util/UUID;)V", "questOfferedTo$delegate", "Lnet/msrandom/witchery/util/OptionalDataDelegate;", "timeToLive", "variant", "getVariant", "setVariant", "variant$delegate", "addToPlayerCoven", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "applyEntityAttributes", "", "applyPotionDamageCalculations", "", "source", "Lnet/minecraft/util/DamageSource;", "damage", "attackEntityWithRangedAttack", "target", "Lnet/minecraft/entity/EntityLivingBase;", "distanceFactor", "canDespawn", "createChild", "Lnet/minecraft/entity/EntityAgeable;", "other", "entityInit", "getCanSpawnHere", "getDeathSound", "Lnet/minecraft/util/SoundEvent;", "getHurtSound", "damageSourceIn", "getLootTable", "Lnet/minecraft/util/ResourceLocation;", "getMessage", "", "message", "handleStatusUpdate", "id", "", "initEntityAI", "isCovenFull", "onDeath", "damageSource", "onInitialSpawn", "Lnet/minecraft/entity/IEntityLivingData;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "livingData", "onLivingUpdate", "playWitchTalk", "processInteract", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "readFromData", "data", "Lnet/msrandom/witchery/common/CovenWitchData;", "say", "formatting", "", "", "(Ljava/lang/String;Lnet/minecraft/entity/player/EntityPlayer;[Ljava/lang/Object;)V", "setSwingingArms", "b", "setTimeToLive", "i", "talk", "talkQuest", "owner", "updateAITasks", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityCovenWitch
extends EntityTameable
implements IRangedAttackMob,
WitchEntity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private CovenQuest quest;
    private int timeToLive;
    private final OptionalDataDelegate questOfferedTo$delegate;
    private final DataDelegate isQuestAccepted$delegate;
    private final DataDelegate questItemsNeeded$delegate;
    @NotNull
    private final DataDelegate variant$delegate;
    @NotNull
    private final DataDelegate isDrinkingPotion$delegate;
    private int potionUseTimer;
    private static final float[] FACING;
    private static final DataParameter<Integer> VARIANT;
    private static final DataParameter<Boolean> AGGRESSIVE;
    private static final DataParameter<Optional<UUID>> QUEST_OFFER;
    private static final DataParameter<Boolean> QUEST_ACCEPTED;
    private static final DataParameter<Integer> ITEMS_NEEDED;
    private static final String[] FIRST_NAMES;
    private static final String[] SURNAMES;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityCovenWitch.class), "questOfferedTo", "getQuestOfferedTo()Ljava/util/UUID;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityCovenWitch.class), "isQuestAccepted", "isQuestAccepted()Ljava/lang/Boolean;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityCovenWitch.class), "questItemsNeeded", "getQuestItemsNeeded()Ljava/lang/Integer;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityCovenWitch.class), "variant", "getVariant()I")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityCovenWitch.class), "isDrinkingPotion", "isDrinkingPotion()Z"))};
        Companion = new Companion(null);
        FACING = new float[]{-45.0f, 45.0f, -135.0f, 135.0f, 180.0f, 0.0f};
        VARIANT = EntityDataManager.createKey(EntityCovenWitch.class, (DataSerializer)DataSerializers.VARINT);
        AGGRESSIVE = EntityDataManager.createKey(EntityCovenWitch.class, (DataSerializer)DataSerializers.BOOLEAN);
        QUEST_OFFER = EntityDataManager.createKey(EntityCovenWitch.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
        QUEST_ACCEPTED = EntityDataManager.createKey(EntityCovenWitch.class, (DataSerializer)DataSerializers.BOOLEAN);
        ITEMS_NEEDED = EntityDataManager.createKey(EntityCovenWitch.class, (DataSerializer)DataSerializers.VARINT);
        FIRST_NAMES = new String[]{"Abigail", "Agatha", "Agony", "Alcina", "Alcyone", "Alexandra", "Alexandria", "Alvira", "Amanita", "Amaranth", "Amarantha", "Ambrosia", "Amelia", "Amethyst", "Anastasia", "Andromeda", "Angel", "Angela", "Angelica", "Angelique", "Anna", "Arachne", "Aradia", "Aria", "Arianna", "Ariadne", "Ariel", "Artemis", "Artemisia", "Astrea", "Astrid", "Astoria", "Autumn", "Aurora", "Beatrix", "Bella", "Belladonna", "Belle", "Bernadette", "Beryl", "Bianca", "Blanche", "Bliss", "Calliope", "Callypso", "Calpurnia", "Camilla", "Carlotta", "Carmilla", "Caroline", "Carrie", "Cassandra", "Cassiopeia", "Catherine", "Cathy", "Cecelia", "Celeste", "Celia", "Charlotte", "Christine", "Circe", "Clara", "Claudia", "Cleopatra", "Columbia", "Coraline", "Cordelia", "Cornelia", "Crystal", "Daphne", "Daria", "Darla", "Delia", "Delilah", "Della", "Demetria", "Demonica", "Desdemona", "Desire", "Dolores", "Dora", "Dove", "Drusilla", "Dusk", "Ebony", "Echo", "Eden", "Elanore", "Electra", "Eldora", "Elena", "Eliza", "Eloise", "Elphaba", "Elspeth", "Elsinore", "Elvira", "Ember", "Emilie", "Ephemera", "Eranthe", "Eris", "Esmerelda", "Estrella", "Esther", "Eterna", "Eternity", "Eudora", "Euphemia", "Eva", "Evalina", "Evangeline", "Eve", "Granny", "Gabriella", "Gabrielle", "Garnet", "Genevieve", "Godiva", "Hathor", "Hecate", "Hecuba", "Helena", "Hepzibah", "Hesperia", "Hippolita", "Ianthe", "Icie", "Icy", "Inez", "Infinity", "Ione", "Iris", "Isabeau", "Isabella", "Isabelle", "Isadora", "Isis", "Isolde", "Istar", "Ivy", "Izora", "Jane", "Jeanette", "Jinx", "Jocasta", "Juliet", "Katrina", "Lavinia", "Layla", "Leona", "Lenora", "Lenore", "Leona", "Libitina", "Ligeia", "Lilah", "Lilith", "Lillian", "Lily", "Lolita", "Lorraine", "Lucinda", "Lucretia", "Luna", "Lydia", "Lyra", "Madeline", "Magdalena", "Magenta", "Mara", "Marcella", "Margaret", "Marguerita", "Maria", "Marie", "Marissa", "Martha", "Matilda", "Medea", "Medusa", "Melanie", "Melantha", "Melanthe", "Melinda", "Mercedes", "Merula", "Mildred", "Mina", "Minerva", "Miranda", "Miriam", "Moira", "Mordea", "Morgan", "Morgana", "Morticia", "Nadia", "Nadine", "Nerezza", "Nora", "Nyx", "Obsidia", "Octavia", "Odessa", "Olivia", "Opal", "Ophelia", "Pandora", "Patience", "Pearl", "Penelope", "Perenelle", "Permelia", "Persephone", "Pixie", "Phoenix", "Poppy", "Priscilla", "Prudence", "Rachel", "Rain", "Raven", "Regina", "Rita", "Rosa", "Rose", "Rosemary", "Rowena", "Ruby", "Sabrina", "Salem", "Samantha", "Sangria", "Scarlet", "Selena", "Selene", "Sephora", "Seraphina", "Serena", "Serenity", "Shannon", "Silver", "Simone", "Sophia", "Sybella", "Sybil", "Sylvia", "Tabitha", "Tempest", "Theda", "Theresa", "Thora", "Threnody", "Trinity", "Twilight", "Umbra", "Vaitiare", "Valerie", "Vanessa", "Verna", "Verona", "Veronica", "Vesta", "Victoria", "Violet", "Whisper", "Willow", "Winter", "Xenobia", "Zillah", "Zinnia"};
        SURNAMES = new String[]{"Adams", "Addams", "Argent", "Ashwood", "Balfour", "Barker", "Batby", "Bathory", "Batsford", "Batson", "Batstone", "Batt", "Baudelaire", "Black", "Blackbird", "Blackburn", "Blackcat", "Blacklock", "Blackmoore", "Blackstone", "Blackthorn", "Blackwell", "Blackwing", "Blackwolf", "Blackwood", "Blair", "Blood", "Bloodgood", "Bloodhart", "Bloodmoore", "Bloodsaw", "Bloodstone", "Bloodsworth", "Bloodwine", "Bloodworth", "Boggart", "Boggarty", "Bonebrake", "Bonehart", "Bonehill", "Bonella", "Boneman", "Bones", "Bonesmith", "Bonewits", "Borden", "Broom", "Broomwood", "Burton", "Byron", "Cackler", "Cain", "Calamity", "Castle", "Castleton", "Cemetary", "Chill", "Chillingwood", "Cobweb", "Coffin", "Coffinberry", "Coffins", "Cold", "Coldbridge", "Coldeman", "Coldstone", "Coldwell", "Cole", "Collins", "Constantine", "Corbett", "Corbin", "Corpse", "Corpseley", "Creak", "Creakey", "Creep", "Creeper", "Creeps", "Crepsley", "Crimson", "Cross", "Crossway", "Crosswicks", "Crow", "Crowden", "Crowe", "Crowley", "Darcy", "Dark", "Darke", "Darken", "Darkenwald", "Darkes", "Darkmoore", "Darkwell", "Darkwood", "Deadman", "Deadmond", "Deadmore", "Deadrick", "Deadwood", "DeAngelus", "Dearborn", "ModelDeath", "Deathridge", "Deathrow", "December", "Delambre", "DeLioncourt", "Demond", "Demonde", "Demonte", "DeMort", "DeRavin", "Devall", "Devane", "DeVille", "DeWinter", "Dracul", "Drago", "Drake", "Dread", "Drear", "Dreary", "Drelincourt", "DuLac", "Dumaine", "Dunsany", "Eldritch", "Fang", "Fanger", "Fate", "Faust", "February", "Fear", "Fearfield", "Fears", "Frankenstein", "Frost", "Fury", "Gautier", "Ghoul", "Ghoulson", "Ghost", "Ghosten", "Ghostley", "Giger", "Goblin", "Goth", "Gotham", "Gothard", "Gothberg", "Gravedigger", "Gravemaker", "Graves", "Gravesen", "Gravesgard", "Grey", "Greyson", "Greystone", "Grimmauld", "Grimm", "Grimmer", "Grimmes", "Grimmins", "Grimsbro", "Grimsby", "Grimsman", "Grimwood", "Harker", "Hart", "Haunt", "Haunter", "Haunton", "Haunty", "Hawk", "Hawke", "Havelock", "Heart", "Heartstrom", "Hemlock", "Hex", "Hexem", "Hexter", "Hexwood", "Hollow", "Holmes", "Holmwood", "Hugo", "Hunter", "Hyde", "January", "Jekyll", "Kenrick", "Kilgore", "Killar", "Killewich", "Killings", "LaCroix", "Lapidus", "LaRue", "LeFay", "LeStrange", "LeStrange", "Locke", "London", "Loveless", "Lovelock", "Lovett", "Lycan", "MacBeth", "Mandrake", "Marrow", "Masters", "Mist", "Misteri", "Moan", "Moon", "Moones", "Moonie", "Moonly", "Monet", "Monster", "Monstery", "Montague", "Montresor", "Morgan", "Morgue", "Moriarty", "Murdoc", "Murray", "Morrow", "Mort", "Mortella", "Munster", "Mysterios", "Night", "Nightchase", "Nightengale", "Nightingdale", "Nightman", "Nightwalker", "Nightwine", "Nocton", "Nox", "October", "Odd", "Odder", "Oddman", "Oddson", "Owl", "Owley", "Owlford", "Owlsey", "Pale", "Pale", "Paine", "Pains", "Payne", "Plague", "Poe", "Poe", "Poe", "Pyre", "Pyre", "Pyre", "Radcliffe", "Rain", "Raven", "Ravencraft", "Ravendale", "Ravenhorst", "Ravensloft", "Ravenway", "Rayne", "Reaper", "Redbone", "Redcross", "Redd", "Redfern", "Redgrave", "Redmond", "Redwine", "Redwolf", "Renfield", "Riven", "Rookwood", "Roth", "Ripley", "Ripper", "Salvatore", "Scar", "Scare", "Scarebrook", "Scares", "Scarey", "Scarlati", "Setzer", "Seward", "Shade", "Shademoore", "Shadow", "Shadows", "Shadowton", "Shelley", "Skeleton", "Skelinen", "Skellington", "Skelton", "Skull", "Skullman", "Specter", "Spectre", "Spellman", "Spider", "Spinner", "Spirite", "Spook", "Spook", "Spook", "Song", "Snow", "St. Claire", "St. Germaine", "Steele", "Sterling", "Stoker", "Storm", "Storme", "Stormfelt", "Stormwind", "Stormyr", "Stone", "Stonewall", "Strange", "Strangeman", "Strangeway", "Striker", "Swan", "Swann", "Teeth", "Tombs", "Tombstone", "Towers", "Trick", "Valancourt", "Valdemar", "Valentine", "Valentino", "Vamper", "Vamplers", "Vampouille", "Vamprine", "Vampyr", "Van Allen", "Van Gogh", "Van Halen", "Van Helgen", "Van Helsing", "Voorhees", "Webb", "Weird", "Weird", "West", "Westenra", "White", "Whitebone", "Whitemoon", "Whitewing", "Widdowes", "Wild", "Wildblood", "Wilde", "Winchester", "Windgate", "Windholm", "Windward", "Wing", "Wingblade", "Wingfield", "Winter", "Winterford", "Winterrose", "Winterwood", "Winters", "Witche", "Witcher", "Witchery", "Witchey", "Witchman", "Wither", "Wolf", "Wolfen", "Wolfmann", "Wolfram", "Wolfstone", "Wolftooth"};
    }

    private final UUID getQuestOfferedTo() {
        return (UUID)this.questOfferedTo$delegate.getValue((Entity)this, $$delegatedProperties[0]);
    }

    private final void setQuestOfferedTo(UUID uUID) {
        this.questOfferedTo$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[0], uUID);
    }

    private final Boolean isQuestAccepted() {
        return (Boolean)this.isQuestAccepted$delegate.getValue((Entity)this, $$delegatedProperties[1]);
    }

    private final void setQuestAccepted(Boolean bl) {
        this.isQuestAccepted$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[1], bl);
    }

    private final Integer getQuestItemsNeeded() {
        return (Integer)this.questItemsNeeded$delegate.getValue((Entity)this, $$delegatedProperties[2]);
    }

    private final void setQuestItemsNeeded(Integer n) {
        this.questItemsNeeded$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[2], n);
    }

    public final int getVariant() {
        return ((Number)this.variant$delegate.getValue((Entity)this, $$delegatedProperties[3])).intValue();
    }

    public final void setVariant(int n) {
        this.variant$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[3], n);
    }

    @Override
    public boolean isDrinkingPotion() {
        return (Boolean)this.isDrinkingPotion$delegate.getValue((Entity)this, $$delegatedProperties[4]);
    }

    @Override
    public void setDrinkingPotion(boolean bl) {
        this.isDrinkingPotion$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[4], bl);
    }

    @Override
    public int getPotionUseTimer() {
        return this.potionUseTimer;
    }

    @Override
    public void setPotionUseTimer(int n) {
        this.potionUseTimer = n;
    }

    private final void playWitchTalk() {
        this.playSound(this.rand.nextBoolean() ? WitcherySounds.ENTITY_BABA_DEATH : WitcherySounds.ENTITY_BABA_AMBIENT, 1.0f, 1.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getCanSpawnHere() {
        boolean living = this.world.checkNoEntityCollision(this.getEntityBoundingBox()) && this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox());
        int i = MathHelper.floor((double)this.posX);
        int j = MathHelper.floor((double)this.getEntityBoundingBox().minY);
        int k = MathHelper.floor((double)this.posZ);
        if (!living) return false;
        BlockPos blockPos = new BlockPos(i, j, k);
        if (!(this.getBlockPathWeight(blockPos) >= 0.0f)) return false;
        if (WitcheryConfigOptions.covenWitchSpawnWeight == 1) return true;
        if (this.world.rand.nextInt(WitcheryConfigOptions.covenWitchSpawnWeight) != 0) return false;
        return true;
    }

    @Nullable
    public IEntityLivingData onInitialSpawn(@NotNull DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        Intrinsics.checkParameterIsNotNull((Object)difficulty, (String)"difficulty");
        this.setCustomNameTag(FIRST_NAMES[this.rand.nextInt(FIRST_NAMES.length)] + ' ' + SURNAMES[this.rand.nextInt(SURNAMES.length)]);
        this.setVariant(this.rand.nextInt(5));
        return super.onInitialSpawn(difficulty, livingData);
    }

    protected void initEntityAI() {
        super.initEntityAI();
        this.aiSit = new EntityAISit((EntityTameable)this);
        this.tasks.addTask(1, (EntityAIBase)this.aiSit);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIMoveToRestrictionAndSit(this, 0.6));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(VARIANT, (Object)0);
        this.dataManager.register(AGGRESSIVE, (Object)false);
        this.dataManager.register(QUEST_OFFER, (Object)Optional.absent());
        this.dataManager.register(QUEST_ACCEPTED, (Object)false);
        this.dataManager.register(ITEMS_NEEDED, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.setBaseValue(30.0);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance2.setBaseValue(0.25);
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound tag) {
        block1: {
            UUID it;
            boolean bl;
            boolean bl2;
            UUID uUID;
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            super.writeEntityToNBT(tag);
            tag.setInteger("SkinType", this.getVariant());
            Boolean bl3 = this.isQuestAccepted();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"isQuestAccepted");
            tag.setBoolean("QuestAccepted", bl3.booleanValue());
            Integer n = this.getQuestItemsNeeded();
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"questItemsNeeded");
            tag.setInteger("QuestItemsNeeded", n.intValue());
            tag.setInteger("SuicideIn", this.timeToLive);
            UUID uUID2 = this.getQuestOfferedTo();
            if (uUID2 != null) {
                uUID = uUID2;
                bl2 = false;
                bl = false;
                it = uUID;
                boolean bl4 = false;
                tag.setUniqueId("QuestOffered", it);
            }
            ResourceLocation resourceLocation = CovenQuestManager.INSTANCE.getRegistry().getKey(this.quest);
            if (resourceLocation == null) break block1;
            uUID = resourceLocation;
            bl2 = false;
            bl = false;
            it = uUID;
            boolean bl5 = false;
            tag.setString("Quest", it.toString());
        }
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.readEntityFromNBT(tag);
        this.setVariant(tag.getInteger("SkinType"));
        this.setQuestAccepted(tag.getBoolean("QuestAccepted"));
        this.setQuestItemsNeeded(tag.getInteger("QuestItemsNeeded"));
        int n = this.timeToLive = tag.hasKey("SuicideIn") ? tag.getInteger("SuicideIn") : -1;
        if (tag.hasUniqueId("QuestOffered")) {
            this.setQuestOfferedTo(tag.getUniqueId("QuestOffered"));
        }
        if (tag.hasKey("Quest")) {
            this.quest = CovenQuestManager.INSTANCE.getRegistry().get(new ResourceLocation(tag.getString("Quest")));
        }
    }

    public final void setTimeToLive(int i) {
        this.timeToLive = i;
    }

    public void updateAITasks() {
        super.updateAITasks();
        if (this.world != null && !this.isDead && !this.world.isRemote && this.timeToLive != -1) {
            if (this.timeToLive > 0) {
                EntityCovenWitch entityCovenWitch = this;
                entityCovenWitch.timeToLive += -1;
                int cfr_ignored_0 = entityCovenWitch.timeToLive;
            }
            if (this.getAttackTarget() == null && this.timeToLive == 0) {
                this.world.playSound(null, this.getPosition(), SoundEvents.ENTITY_ENDERMEN_TELEPORT, this.getSoundCategory(), 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                this.world.setEntityState((Entity)this, (byte)16);
                this.setDead();
            }
        }
    }

    public void onDeath(@NotNull DamageSource damageSource) {
        EntityLivingBase owner;
        Intrinsics.checkParameterIsNotNull((Object)damageSource, (String)"damageSource");
        if (!this.world.isRemote && this.isTamed() && (owner = this.getOwner()) instanceof EntityPlayer) {
            Set<CovenWitchData> set2 = WitcheryUtils.getExtension((EntityPlayer)((EntityPlayer)owner)).coven;
            if (set2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<java.util.UUID>");
            }
            TypeIntrinsics.asMutableSet(set2).remove(this.getUniqueID());
        }
        super.onDeath(damageSource);
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        Intrinsics.checkParameterIsNotNull((Object)damageSourceIn, (String)"damageSourceIn");
        return SoundEvents.ENTITY_WITCH_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITCH_DEATH;
    }

    public void onLivingUpdate() {
        WitchEntity.Companion.doWitchAttack(this);
        super.onLivingUpdate();
    }

    protected float applyPotionDamageCalculations(@NotNull DamageSource source, float damage) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return source.getTrueSource() == this ? 0.0f : (source.isMagicDamage() ? super.applyPotionDamageCalculations(source, damage) * 0.15f : super.applyPotionDamageCalculations(source, damage));
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 15: {
                int n = this.rand.nextInt(35) + 10;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.world.spawnParticle(EnumParticleTypes.SPELL_WITCH, this.posX + this.rand.nextGaussian() * (double)0.13f, this.getEntityBoundingBox().maxY + 0.5 + this.rand.nextGaussian() * (double)0.13f, this.posZ + this.rand.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 16: {
                int n = 20;
                boolean bl = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n;
                while (n4 < n5) {
                    int it = n4++;
                    boolean bl3 = false;
                    this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * (double)2 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * (double)2 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.handleStatusUpdate(id);
            }
        }
    }

    public boolean processInteract(@NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        if (!(this.world.isRemote || this.isTamed() || this.isDrinkingPotion() || WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player))) {
            ItemStack stack = player.getHeldItem(hand);
            UUID id = this.getQuestOfferedTo();
            Boolean bl = this.isQuestAccepted();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isQuestAccepted");
            if (bl.booleanValue()) {
                if (Intrinsics.areEqual((Object)player.getUniqueID(), (Object)id)) {
                    if (this.isCovenFull(player)) {
                        this.setQuestAccepted(false);
                        this.setQuestOfferedTo(null);
                        this.quest = null;
                        this.say("full_coven", player, new Object[0]);
                    } else {
                        ItemStack itemStack = stack;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                        if (EntityCovenWitch.Companion.isQuestItemForEntity(itemStack, this)) {
                            int n;
                            if (player.capabilities.isCreativeMode) {
                                CovenQuest covenQuest = this.quest;
                                n = covenQuest != null ? covenQuest.getItemsNeeded() : 1;
                            } else {
                                int n2;
                                CovenQuest covenQuest = this.quest;
                                if (covenQuest != null) {
                                    int n3 = covenQuest.getItemsNeeded();
                                    int n4 = stack.getCount();
                                    boolean bl2 = false;
                                    boolean bl3 = false;
                                    int p1 = n3;
                                    boolean bl4 = false;
                                    n2 = RangesKt.coerceAtMost((int)n4, (int)p1);
                                } else {
                                    n2 = 1;
                                }
                                int value = n2;
                                stack.shrink(value);
                                n = value;
                            }
                            int itemsUsed = n;
                            EntityCovenWitch entityCovenWitch = this;
                            entityCovenWitch.setQuestItemsNeeded(entityCovenWitch.getQuestItemsNeeded() - itemsUsed);
                            Integer n5 = this.getQuestItemsNeeded();
                            if (n5 != null && n5 == 0) {
                                if (this.addToPlayerCoven(player)) {
                                    player.sendMessage(new TextComponentTranslation(this.getMessage("joined_coven"), new Object[]{this.getCustomNameTag()}).setStyle(new Style().setColor(TextFormatting.BLUE)));
                                } else {
                                    player.sendMessage(new TextComponentTranslation(this.getMessage("tricked"), new Object[]{this.getCustomNameTag()}).setStyle(new Style().setColor(TextFormatting.BLUE)));
                                    this.setRevengeTarget((EntityLivingBase)player);
                                    this.setAttackTarget((EntityLivingBase)player);
                                    this.setDrinkingPotion(true);
                                    this.quest = null;
                                    this.setQuestAccepted(false);
                                    this.setQuestOfferedTo(null);
                                }
                            } else {
                                player.sendMessage(new TextComponentTranslation(this.getMessage("items_needed"), new Object[]{this.getCustomNameTag(), this.getQuestItemsNeeded()}).setStyle(new Style().setColor(TextFormatting.BLUE)));
                            }
                            this.playWitchTalk();
                        } else {
                            this.say("task_not_finished", player, new Object[0]);
                        }
                    }
                } else {
                    this.say("begone", player, new Object[0]);
                }
            } else if (Intrinsics.areEqual((Object)player.getUniqueID(), (Object)id) ^ true) {
                this.enablePersistence();
                if (this.isCovenFull(player)) {
                    this.say("full_coven", player, new Object[0]);
                } else if (CovenQuestManager.INSTANCE.getRegistry().getSize() == 0 || Familiars.getActiveFamiliarType(player) == null) {
                    this.say("not_interested_" + (this.rand.nextInt(3) + 1), player, new Object[0]);
                } else {
                    this.setQuestOfferedTo(player.getUniqueID());
                    WitcheryRegistry<ResourceLocation, CovenQuest> witcheryRegistry = CovenQuestManager.INSTANCE.getRegistry();
                    Random random = this.rand;
                    Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"rand");
                    ResourceLocation questType = witcheryRegistry.getRandom(random);
                    if (questType == null) {
                        this.say("not_interested_1", player, new Object[0]);
                    } else {
                        CovenQuest quest;
                        this.quest = quest = CovenQuestManager.INSTANCE.getRegistry().get(questType);
                        if (quest != null) {
                            this.setQuestItemsNeeded(quest.getItemsNeeded());
                            String string = questType.getNamespace();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"questType.namespace");
                            this.talkQuest(string, questType.getPath(), player);
                        }
                    }
                }
            } else if (this.isCovenFull(player)) {
                this.setQuestOfferedTo(null);
                this.say("full_coven", player, new Object[0]);
            } else {
                this.setQuestAccepted(true);
                CovenQuest covenQuest = this.quest;
                if (covenQuest != null) {
                    CovenQuest covenQuest2 = covenQuest;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    CovenQuest it = covenQuest2;
                    boolean bl7 = false;
                    World world = this.world;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                    it.activate(world, this, player);
                    if (it.getStartText() != null) {
                        ResourceLocation type = CovenQuestManager.INSTANCE.getRegistry().getKey(it);
                        ResourceLocation resourceLocation = type;
                        if (resourceLocation == null) {
                        } else {
                            String string = resourceLocation.getNamespace();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(type ?: return@let).namespace");
                            this.talkQuest(string, it.getStartText(), player);
                        }
                    }
                }
                this.playWitchTalk();
            }
        }
        return true;
    }

    private final void say(String message, EntityPlayer player, Object ... formatting) {
        String string = this.getMessage(message);
        Object[] objectArray = new Object[2];
        String string2 = this.getCustomNameTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"customNameTag");
        objectArray[0] = string2;
        objectArray[1] = formatting;
        this.talk(string, player, objectArray);
    }

    private final void talkQuest(String owner, String message, EntityPlayer player) {
        String string = "entity." + owner + ".coven_witch.quest." + message;
        Object[] objectArray = new Object[1];
        String string2 = this.getCustomNameTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"customNameTag");
        objectArray[0] = string2;
        this.talk(string, player, objectArray);
    }

    private final String getMessage(String message) {
        return "entity.witchery.coven_witch.say." + message;
    }

    private final boolean isCovenFull(EntityPlayer player) {
        return WitcheryUtils.getExtension((EntityPlayer)player).coven.size() >= 6;
    }

    private final void talk(String message, EntityPlayer player, Object ... formatting) {
        player.sendMessage(new TextComponentTranslation(message, Arrays.copyOf(formatting, formatting.length)).setStyle(new Style().setColor(TextFormatting.BLUE)));
        this.playWitchTalk();
    }

    protected boolean canDespawn() {
        if (this.isTamed()) {
            Entity player = (Entity)this.getOwner();
            return player == null || player.getDistanceSq((Entity)this) > 4096.0 || super.canDespawn();
        }
        return super.canDespawn();
    }

    private final boolean addToPlayerCoven(EntityPlayer player) {
        Set<CovenWitchData> coven;
        Set<CovenWitchData> set2 = coven = WitcheryUtils.getExtension((EntityPlayer)player).coven;
        if (set2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Set<java.util.UUID>");
        }
        if (set2.contains(this.getUniqueID())) {
            return false;
        }
        Collection collection = coven;
        String string = this.getCustomNameTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"customNameTag");
        int n = this.getVariant();
        UUID uUID = this.getUniqueID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"uniqueID");
        CovenWitchData covenWitchData = new CovenWitchData(string, n, uUID, this.quest);
        boolean bl = false;
        collection.add(covenWitchData);
        this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
        this.world.setEntityState((Entity)this, (byte)16);
        this.setDead();
        return true;
    }

    private final void readFromData(CovenWitchData data) {
        this.setCustomNameTag(data.getName());
        this.setVariant(data.getVariant());
        this.setUniqueId(data.getId());
        this.quest = data.getQuest();
    }

    @NotNull
    protected ResourceLocation getLootTable() {
        ResourceLocation resourceLocation = LootTableList.ENTITIES_WITCH;
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceLocation, (String)"LootTableList.ENTITIES_WITCH");
        return resourceLocation;
    }

    public void attackEntityWithRangedAttack(@NotNull EntityLivingBase target, float distanceFactor) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (!this.isDrinkingPotion()) {
            EntityPotion potion = new EntityPotion(this.world, (EntityLivingBase)this, PotionUtils.addPotionToItemStack((ItemStack)new ItemStack((Item)Items.SPLASH_POTION), (PotionType)PotionTypes.HARMING));
            potion.rotationPitch += 20.0f;
            double d0 = target.posY + (double)target.getEyeHeight() - (double)1.1f - this.posY;
            double d1 = target.posX + target.motionX - this.posX;
            double d3 = target.posZ + target.motionZ - this.posZ;
            float f = MathHelper.sqrt((double)(d1 * d1 + d3 * d3));
            if (f >= 8.0f && !target.isPotionActive(MobEffects.SLOWNESS)) {
                potion.setItem(PotionUtils.addPotionToItemStack((ItemStack)new ItemStack((Item)Items.SPLASH_POTION), (PotionType)PotionTypes.SLOWNESS));
            } else if (target.getHealth() >= 8.0f && !target.isPotionActive(MobEffects.POISON)) {
                potion.setItem(PotionUtils.addPotionToItemStack((ItemStack)new ItemStack((Item)Items.SPLASH_POTION), (PotionType)PotionTypes.POISON));
            } else if (f <= 3.0f && !target.isPotionActive(MobEffects.WEAKNESS) && this.rand.nextFloat() < 0.25f) {
                potion.setItem(PotionUtils.addPotionToItemStack((ItemStack)new ItemStack((Item)Items.SPLASH_POTION), (PotionType)PotionTypes.WEAKNESS));
            }
            potion.shoot(d1, d0 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
            this.world.spawnEntity((Entity)potion);
        }
    }

    public void setSwingingArms(boolean b) {
    }

    @Nullable
    public EntityAgeable createChild(@NotNull EntityAgeable other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return null;
    }

    public EntityCovenWitch(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.timeToLive = -1;
        DataParameter<Optional<UUID>> dataParameter = QUEST_OFFER;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"QUEST_OFFER");
        this.questOfferedTo$delegate = new OptionalDataDelegate<UUID>(dataParameter);
        DataParameter<Boolean> dataParameter2 = QUEST_ACCEPTED;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter2, (String)"QUEST_ACCEPTED");
        this.isQuestAccepted$delegate = new DataDelegate<Boolean>(dataParameter2);
        DataParameter<Integer> dataParameter3 = ITEMS_NEEDED;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter3, (String)"ITEMS_NEEDED");
        this.questItemsNeeded$delegate = new DataDelegate<Integer>(dataParameter3);
        DataParameter<Integer> dataParameter4 = VARIANT;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter4, (String)"VARIANT");
        this.variant$delegate = new DataDelegate<Integer>(dataParameter4);
        DataParameter<Boolean> dataParameter5 = AGGRESSIVE;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter5, (String)"AGGRESSIVE");
        this.isDrinkingPotion$delegate = new DataDelegate<Boolean>(dataParameter5);
    }

    public static final /* synthetic */ void access$setAiSit$p(EntityCovenWitch $this, EntityAISit entityAISit) {
        $this.aiSit = entityAISit;
    }

    public static final /* synthetic */ void access$setQuest$p(EntityCovenWitch $this, CovenQuest covenQuest) {
        $this.quest = covenQuest;
    }

    @JvmStatic
    public static final void summonCoven(@NotNull World world, @NotNull EntityPlayer player, @NotNull BlockPos target, int ticks) {
        Companion.summonCoven(world, player, target, ticks);
    }

    @JvmStatic
    public static final void summonCovenMember(@NotNull World world, @NotNull EntityPlayer player, int ttlSecs) {
        Companion.summonCovenMember(world, player, ttlSecs);
    }

    @JvmStatic
    @NotNull
    public static final RiteHandler.Result processCovenSummon(@Nullable EntityPlayer player, int index, @NotNull BlockPos position) {
        return Companion.processCovenSummon(player, index, position);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0007J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u000eH\u0007J \u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020\u000eH\u0007R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR2\u0010\r\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\u0010\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00120\u0012 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011 \u0006*.\u0012(\u0012&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00120\u0012 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR2\u0010\u0014\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lnet/msrandom/witchery/entity/passive/coven/EntityCovenWitch$Companion;", "", "()V", "AGGRESSIVE", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "FACING", "", "FIRST_NAMES", "", "", "[Ljava/lang/String;", "ITEMS_NEEDED", "", "QUEST_ACCEPTED", "QUEST_OFFER", "Lcom/google/common/base/Optional;", "Ljava/util/UUID;", "SURNAMES", "VARIANT", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "isQuestItemForEntity", "stack", "Lnet/minecraft/item/ItemStack;", "questGiver", "Lnet/msrandom/witchery/entity/passive/coven/EntityCovenWitch;", "processCovenSummon", "Lnet/msrandom/witchery/rite/RiteHandler$Result;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "index", "position", "Lnet/minecraft/util/math/BlockPos;", "summonCoven", "", "world", "Lnet/minecraft/world/World;", "target", "ticks", "summonCovenMember", "ttlSecs", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().creature(EnumCreatureType.CREATURE).size(0.6f, 1.95f).egg(0x111111, 11523).render(properties.1.INSTANCE);
        }

        @JvmStatic
        public final void summonCoven(@NotNull World world, @NotNull EntityPlayer player, @NotNull BlockPos target, int ticks) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            if (ticks > 0 && ticks % 20 == 0) {
                int witchIndex = ticks / 20 - 1;
                Set<CovenWitchData> coven = WitcheryUtils.getExtension((EntityPlayer)player).coven;
                if (witchIndex >= coven.size()) {
                    return;
                }
                Set<CovenWitchData> set2 = coven;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"coven");
                CovenWitchData witchData = (CovenWitchData)CollectionsKt.elementAt((Iterable)set2, (int)witchIndex);
                EntityCovenWitch witch = null;
                Iterator iterator = world.getEntitiesWithinAABB(EntityCovenWitch.class, player.getEntityBoundingBox().grow(64.0, 16.0, 64.0)).iterator();
                while (iterator.hasNext()) {
                    EntityCovenWitch witchAround;
                    EntityCovenWitch entityCovenWitch = witchAround = (EntityCovenWitch)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityCovenWitch, (String)"witchAround");
                    if (!entityCovenWitch.isTamed() || witchAround.getOwner() != player || !Intrinsics.areEqual((Object)witchAround.getUniqueID(), (Object)witchData.getId())) continue;
                    witch = witchAround;
                    break;
                }
                boolean spawn = false;
                if (witch == null) {
                    witch = new EntityCovenWitch(world);
                    CovenWitchData covenWitchData = witchData;
                    Intrinsics.checkExpressionValueIsNotNull((Object)covenWitchData, (String)"witchData");
                    witch.readFromData(covenWitchData);
                    witch.setTamed(true);
                    witch.setOwnerId(player.getUniqueID());
                    spawn = true;
                }
                TileEntity closest = null;
                double bestDistSq = 0.0;
                for (TileEntity tile : world.loadedTileEntityList) {
                    if (!(tile instanceof TileEntityCauldron)) continue;
                    BlockPos blockPos = tile.getPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"tile.getPos()");
                    double d = blockPos.getX();
                    BlockPos blockPos2 = tile.getPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"tile.getPos()");
                    double d2 = blockPos2.getY();
                    BlockPos blockPos3 = tile.getPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"tile.getPos()");
                    double dist = player.getDistanceSq(d, d2, (double)blockPos3.getZ());
                    if (closest != null && !(dist < bestDistSq)) continue;
                    closest = tile;
                    bestDistSq = dist;
                }
                if (closest != null && bestDistSq <= 81.0) {
                    witch.setHomePosAndDistance(closest.getPos(), 3);
                    int maxRange = 3;
                    int minRange = 1;
                    int activeRadius = maxRange - minRange;
                    int ax = world.rand.nextInt(activeRadius * 2 + 1);
                    if (ax > activeRadius) {
                        ax += minRange * 2;
                    }
                    BlockPos blockPos = closest.getPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"closest.pos");
                    int nx = blockPos.getX() - maxRange + ax;
                    int az = world.rand.nextInt(activeRadius * 2 + 1);
                    if (az > activeRadius) {
                        az += minRange * 2;
                    }
                    BlockPos blockPos4 = closest.getPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"closest.pos");
                    int nz = blockPos4.getZ() - maxRange + az;
                    double d = nx;
                    BlockPos blockPos5 = closest.getPos();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"closest.pos");
                    witch.setPositionAndRotation(d, 0.01 + (double)blockPos5.getY(), nz, 0.0f, 0.0f);
                } else {
                    witch.setPositionAndRotation(0.5 + (double)target.getX() + (double)world.rand.nextInt(3) - 1.5, 0.01 + (double)target.getY(), 0.5 + (double)target.getZ() + (double)world.rand.nextInt(3) - 1.5, 0.0f, 0.0f);
                }
                witch.aiSit.resetTask();
                witch.setTimeToLive(1200);
                if (spawn) {
                    world.spawnEntity((Entity)witch);
                }
                witch.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (witch.world.rand.nextFloat() * 0.4f + 0.8f));
                world.setEntityState((Entity)witch, (byte)16);
            }
        }

        @JvmStatic
        public final void summonCovenMember(@NotNull World world, @NotNull EntityPlayer player, int ttlSecs) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Set<CovenWitchData> coven = WitcheryUtils.getExtension((EntityPlayer)player).coven;
            if (coven.isEmpty()) {
                SoundEvent soundEvent = SoundEvents.BLOCK_NOTE_SNARE;
                Intrinsics.checkExpressionValueIsNotNull((Object)soundEvent, (String)"SoundEvents.BLOCK_NOTE_SNARE");
                WitcheryUtils.playSoundAt(player, soundEvent, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            } else {
                BlockPos pos;
                int i2;
                int l;
                int n;
                int n2;
                int k;
                int j;
                int i;
                List entities;
                List list2 = entities = world.getEntitiesWithinAABB(EntityCovenWitch.class, player.getEntityBoundingBox().grow(64.0, 16.0, 64.0));
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"entities");
                List list3 = list2;
                boolean bl = false;
                Collections.shuffle(list3);
                Iterator iterator = entities.iterator();
                while (iterator.hasNext()) {
                    EntityCovenWitch witch;
                    EntityCovenWitch entityCovenWitch = witch = (EntityCovenWitch)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityCovenWitch, (String)"witch");
                    if (!entityCovenWitch.isTamed() || witch.getOwner() != player) continue;
                    i = MathHelper.floor((double)player.posX) - 2;
                    j = MathHelper.floor((double)player.posZ) - 2;
                    k = MathHelper.floor((double)player.getEntityBoundingBox().minY);
                    int n3 = 0;
                    n2 = 4;
                    while (n3 <= n2) {
                        int n4 = 0;
                        n = 4;
                        while (n4 <= n) {
                            pos = new BlockPos(i + l, k, j + i2);
                            if ((l < 1 || i2 < 1 || l > 3 || i2 > 3) && world.getBlockState(pos.down()).isSideSolid((IBlockAccess)world, pos.down(), EnumFacing.UP)) {
                                IBlockState iBlockState = world.getBlockState(pos);
                                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
                                if (!iBlockState.isNormalCube()) {
                                    IBlockState iBlockState2 = world.getBlockState(pos.up());
                                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"world.getBlockState(pos.up())");
                                    if (!iBlockState2.isNormalCube()) {
                                        WitcheryIngredientItem.teleportToLocation((double)(i + l) + 0.5, (double)k, (double)(j + i2) + 0.5, player.dimension, (Entity)witch, true);
                                        witch.getNavigator().clearPath();
                                        return;
                                    }
                                }
                            }
                            ++i2;
                        }
                        ++l;
                    }
                }
                Set<CovenWitchData> set2 = coven;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"coven");
                CovenWitchData witchData = (CovenWitchData)CollectionsKt.elementAt((Iterable)set2, (int)world.rand.nextInt(coven.size()));
                EntityCovenWitch witch = new EntityCovenWitch(world);
                i = MathHelper.floor((double)player.posX) - 2;
                j = MathHelper.floor((double)player.posZ) - 2;
                k = MathHelper.floor((double)player.getEntityBoundingBox().minY);
                n2 = 4;
                block3: for (l = 0; l <= n2; ++l) {
                    n = 4;
                    for (i2 = 0; i2 <= n; ++i2) {
                        pos = new BlockPos(i + l, k, j + i2);
                        if (l >= 1 && i2 >= 1 && l <= 3 && i2 <= 3 || !world.getBlockState(pos.down()).isSideSolid((IBlockAccess)world, pos.down(), EnumFacing.UP)) continue;
                        IBlockState iBlockState = world.getBlockState(pos);
                        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
                        if (iBlockState.isNormalCube()) continue;
                        IBlockState iBlockState3 = world.getBlockState(pos.up());
                        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState3, (String)"world.getBlockState(pos.up())");
                        if (iBlockState3.isNormalCube()) continue;
                        witch.setLocationAndAngles((double)(i + l) + 0.5, k, (double)(j + i2) + 0.5, 0.0f, 0.0f);
                        continue block3;
                    }
                }
                witch.setTamed(true);
                witch.setOwnerId(player.getUniqueID());
                CovenWitchData covenWitchData = witchData;
                Intrinsics.checkExpressionValueIsNotNull((Object)covenWitchData, (String)"witchData");
                witch.readFromData(covenWitchData);
                witch.setTimeToLive(ttlSecs * 20);
                world.spawnEntity((Entity)witch);
                witch.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (witch.world.rand.nextFloat() * 0.4f + 0.8f));
                world.setEntityState((Entity)witch, (byte)16);
            }
        }

        private final boolean isQuestItemForEntity(ItemStack stack, EntityCovenWitch questGiver) {
            if (questGiver != null && !stack.isEmpty()) {
                CovenQuest covenQuest = questGiver.quest;
                if (covenQuest == null) {
                    Intrinsics.throwNpe();
                }
                if (covenQuest.isQuestItem(stack)) {
                    return true;
                }
                if (stack.hasTagCompound()) {
                    NBTTagCompound nbtRoot;
                    NBTTagCompound nBTTagCompound = nbtRoot = stack.getTagCompound();
                    if (nBTTagCompound == null) {
                        Intrinsics.throwNpe();
                    }
                    if (nBTTagCompound.hasUniqueId("WitcheryQuestOwnerID")) {
                        return Intrinsics.areEqual((Object)questGiver.getPersistentID(), (Object)nbtRoot.getUniqueId("WitcheryQuestOwnerID"));
                    }
                }
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public final RiteHandler.Result processCovenSummon(@Nullable EntityPlayer player, int index, @NotNull BlockPos position) {
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            if (player != null) {
                Set<CovenWitchData> coven = WitcheryUtils.getExtension((EntityPlayer)player).coven;
                List entities = player.world.getEntitiesWithinAABB(EntityCovenWitch.class, player.getEntityBoundingBox().grow(64.0, 16.0, 64.0));
                Set<CovenWitchData> set2 = coven;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"coven");
                CovenWitchData witchData = (CovenWitchData)CollectionsKt.elementAt((Iterable)set2, (int)index);
                EntityCovenWitch witch = null;
                Iterator iterator = entities.iterator();
                while (iterator.hasNext()) {
                    EntityCovenWitch witchAround;
                    EntityCovenWitch entityCovenWitch = witchAround = (EntityCovenWitch)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityCovenWitch, (String)"witchAround");
                    if (!entityCovenWitch.isTamed() || witchAround.getOwner() != player || !Intrinsics.areEqual((Object)witchAround.getUniqueID(), (Object)witchData.getId())) continue;
                    witch = witchAround;
                    break;
                }
                boolean spawn = false;
                if (witch == null) {
                    World world = player.world;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"player.world");
                    witch = new EntityCovenWitch(world);
                    CovenWitchData covenWitchData = witchData;
                    Intrinsics.checkExpressionValueIsNotNull((Object)covenWitchData, (String)"witchData");
                    witch.readFromData(covenWitchData);
                    witch.setTamed(true);
                    witch.setOwnerId(player.getUniqueID());
                    spawn = true;
                }
                witch.setPositionAndRotation(0.5 + (double)position.getX(), 0.01 + (double)position.getY(), 0.5 + (double)position.getZ(), FACING[index], 0.0f);
                witch.rotationYawHead = witch.rotationYaw;
                witch.renderYawOffset = witch.rotationYaw;
                witch.prevRotationYaw = witch.rotationYaw;
                witch.aiSit.setSitting(true);
                witch.setTimeToLive(300);
                if (spawn) {
                    player.world.spawnEntity((Entity)witch);
                }
                witch.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (witch.world.rand.nextFloat() * 0.4f + 0.8f));
                player.world.setEntityState((Entity)witch, (byte)16);
            }
            return RiteHandler.Result.COMPLETED;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

