/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.passive;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.ai.EntityAIDimensionalFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAISitAndStay;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.entity.passive.EntityToad;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 ]2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001]B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\fH\u0014J\u0010\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001dH\u0014J\b\u00100\u001a\u00020!H\u0014J\u0018\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020&H\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0014J\n\u00106\u001a\u0004\u0018\u000105H\u0014J\n\u00107\u001a\u0004\u0018\u000108H\u0014J\b\u00109\u001a\u00020&H\u0016J\u0012\u0010:\u001a\u0004\u0018\u0001052\u0006\u0010;\u001a\u00020$H\u0014J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J\b\u0010>\u001a\u00020&H\u0014J\b\u0010?\u001a\u00020\u001dH\u0016J\b\u0010@\u001a\u00020\u001dH\u0016J\b\u0010A\u001a\u00020\u001dH\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020\bH\u0016J\b\u0010D\u001a\u00020!H\u0014J\u0010\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020!H\u0016J\u0018\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0014J\u0018\u0010N\u001a\u00020\f2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020!2\u0006\u0010T\u001a\u00020UH\u0016J\u0016\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\fJ\u0018\u0010X\u001a\u00020\f2\u0006\u0010Y\u001a\u00020=2\u0006\u0010Z\u001a\u00020=H\u0016J\b\u0010[\u001a\u00020!H\u0014J\u0010\u0010\\\u001a\u00020!2\u0006\u0010T\u001a\u00020UH\u0016R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u001c\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lnet/msrandom/witchery/entity/passive/EntityToad;", "Lnet/minecraft/entity/passive/EntityTameable;", "Lnet/msrandom/witchery/entity/familiar/Familiar;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "colorParameter", "Lnet/minecraft/network/datasync/DataParameter;", "", "getColorParameter", "()Lnet/minecraft/network/datasync/DataParameter;", "familiarProperty", "", "getFamiliarProperty", "familiarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "getFamiliarType", "()Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "follow", "Lnet/msrandom/witchery/entity/ai/EntityAIDimensionalFollowOwner;", "isTemp", "()Z", "names", "", "", "getNames", "()[Ljava/lang/String;", "poisoned", "timeToLive", "", "wander", "Lnet/minecraft/entity/ai/EntityAIWanderAvoidWater;", "applyEntityAttributes", "", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "canDespawn", "canMateWith", "animal", "Lnet/minecraft/entity/passive/EntityAnimal;", "createChild", "Lnet/minecraft/entity/EntityAgeable;", "mate", "decreaseAirSupply", "air", "entityInit", "fall", "distance", "damageMultiplier", "getAmbientSound", "Lnet/minecraft/util/SoundEvent;", "getDeathSound", "getDropItem", "Lnet/minecraft/item/Item;", "getEyeHeight", "getHurtSound", "damageSourceIn", "getOwner", "Lnet/minecraft/entity/EntityLivingBase;", "getSoundVolume", "getTalkInterval", "getTotalArmorValue", "getVerticalFaceSpeed", "handleStatusUpdate", "id", "initEntityAI", "isBreedingItem", "stack", "Lnet/minecraft/item/ItemStack;", "onUpdate", "playStepSound", "pos", "Lnet/minecraft/util/math/BlockPos;", "block", "Lnet/minecraft/block/Block;", "processInteract", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "setTimeToLive", "i", "shouldAttackEntity", "target", "owner", "updateAITasks", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityToad
extends EntityTameable
implements Familiar<EntityToad> {
    private int timeToLive;
    private boolean poisoned;
    private EntityAIDimensionalFollowOwner follow;
    private EntityAIWanderAvoidWater wander;
    private static final String[] NAMES;
    private static final DataParameter<Byte> COLOR;
    private static final DataParameter<Boolean> FAMILIAR;
    public static final Companion Companion;

    protected void initEntityAI() {
        super.initEntityAI();
        this.follow = new EntityAIDimensionalFollowOwner(this, 1.0, 10.0f, 2.0f);
        this.wander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAISitAndStay(this));
        EntityAIDimensionalFollowOwner entityAIDimensionalFollowOwner = this.follow;
        if (entityAIDimensionalFollowOwner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"follow");
        }
        this.tasks.addTask(3, (EntityAIBase)entityAIDimensionalFollowOwner);
        this.tasks.addTask(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.ROTTEN_FLESH, false));
        EntityAIWanderAvoidWater entityAIWanderAvoidWater = this.wander;
        if (entityAIWanderAvoidWater == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wander");
        }
        this.tasks.addTask(5, (EntityAIBase)entityAIWanderAvoidWater);
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public final void setTimeToLive(int i, boolean poisoned) {
        this.timeToLive = i;
        this.poisoned = poisoned;
    }

    public final boolean isTemp() {
        return this.timeToLive != -1;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance.setBaseValue(0.2);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance2.setBaseValue(10.0);
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + (this.isFamiliar() ? 5 : 0);
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    @Override
    @Nullable
    public FamiliarType<EntityToad> getFamiliarType() {
        return WitcheryFamiliars.getToad();
    }

    @Override
    @NotNull
    public DataParameter<Boolean> getFamiliarProperty() {
        DataParameter<Boolean> dataParameter = FAMILIAR;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"FAMILIAR");
        return dataParameter;
    }

    @Override
    @Nullable
    public DataParameter<Byte> getColorParameter() {
        return COLOR;
    }

    @Override
    @NotNull
    public String[] getNames() {
        return NAMES;
    }

    @Nullable
    public EntityLivingBase getOwner() {
        return this.getFamiliarOwner(super.getOwner());
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.isDead && !this.world.isRemote && this.timeToLive != -1) {
            EntityToad entityToad = this;
            entityToad.timeToLive += -1;
            if (entityToad.timeToLive == 0) {
                this.setDead();
                if (this.poisoned) {
                    List list2;
                    List list3 = list2 = this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox().expand(3.0, 2.0, 3.0));
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"list");
                    Collection collection = list3;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        for (EntityLivingBase entity : list2) {
                            double d0 = this.getDistanceSq((Entity)entity);
                            if (!(d0 < 9.0)) continue;
                            entity.addPotionEffect(new PotionEffect(MobEffects.POISON, 60, 0));
                        }
                    }
                    this.playSound(SoundEvents.ENTITY_SLIME_JUMP, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)4);
                }
                this.world.setEntityState((Entity)this, (byte)5);
            }
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(COLOR, (Object)((byte)this.rand.nextInt(16)));
        this.dataManager.register(FAMILIAR, (Object)false);
    }

    public void handleStatusUpdate(byte id) {
        if (!this.handleDismissParticles(id)) {
            boolean poison;
            byte status = id;
            boolean bl = poison = status == 4;
            if (poison || status == 5) {
                if (poison) {
                    int n = 20;
                    boolean bl2 = false;
                    int n2 = 0;
                    n2 = 0;
                    int n3 = n;
                    while (n2 < n3) {
                        int it = n2++;
                        boolean bl3 = false;
                        this.world.spawnParticle(EnumParticleTypes.SLIME, this.posX + this.world.rand.nextDouble() * (double)2 - 0.5, this.posY + this.world.rand.nextDouble() * (double)2 * 0.5, this.posZ + (double)(this.world.rand.nextFloat() * (float)2) - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                } else {
                    int n = 20;
                    boolean bl4 = false;
                    int n4 = 0;
                    n4 = 0;
                    int n5 = n;
                    while (n4 < n5) {
                        int it = n4++;
                        boolean bl5 = false;
                        this.world.spawnParticle(EnumParticleTypes.SPELL_MOB, this.posX + this.world.rand.nextDouble() - 0.5, this.posY + this.world.rand.nextDouble() * 0.5, this.posZ + (double)this.world.rand.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            } else {
                super.handleStatusUpdate(id);
            }
        }
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.playSound(SoundEvents.ENTITY_SMALL_SLIME_JUMP, 0.15f, 1.0f);
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.writeEntityToNBT(compound);
        compound.setByte("Color", (byte)this.getColor().getMetadata());
        compound.setBoolean("Familiar", this.isFamiliar());
        compound.setInteger("SuicideIn", this.timeToLive);
        compound.setBoolean("Poisonous", this.poisoned);
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.readEntityFromNBT(compound);
        EnumDyeColor enumDyeColor = EnumDyeColor.byMetadata((int)compound.getByte("Color"));
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(\u2026getByte(\"Color\").toInt())");
        this.setColor(enumDyeColor);
        this.setFamiliar(compound.getBoolean("Familiar"));
        this.timeToLive = compound.hasKey("SuicideIn") ? compound.getInteger("SuicideIn") : -1;
        this.poisoned = compound.hasKey("Poisonous") && compound.getBoolean("Poisonous");
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_TOAD_CROAK;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        Intrinsics.checkParameterIsNotNull((Object)damageSourceIn, (String)"damageSourceIn");
        return WitcherySounds.ENTITY_TOAD_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_TOAD_HURT;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Nullable
    protected Item getDropItem() {
        return !this.isTemp() ? Items.SLIME_BALL : super.getDropItem();
    }

    public void onUpdate() {
        if (this.follow == null) {
            this.follow = new EntityAIDimensionalFollowOwner(this, 1.0, 10.0f, 2.0f);
        }
        if (this.wander == null) {
            this.wander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        }
        this.isImmuneToFire = this.isFamiliar();
        super.onUpdate();
        EntityAIDimensionalFollowOwner entityAIDimensionalFollowOwner = this.follow;
        if (entityAIDimensionalFollowOwner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"follow");
        }
        if (entityAIDimensionalFollowOwner.resetTask) {
            boolean bl;
            block12: {
                Set set2 = this.tasks.taskEntries;
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"tasks.taskEntries");
                Iterable $this$none$iv = set2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        EntityAITasks.EntityAITaskEntry it = (EntityAITasks.EntityAITaskEntry)element$iv;
                        boolean bl2 = false;
                        EntityAIBase entityAIBase = it.action;
                        EntityAIWanderAvoidWater entityAIWanderAvoidWater = this.wander;
                        if (entityAIWanderAvoidWater == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"wander");
                        }
                        if (!Intrinsics.areEqual((Object)entityAIBase, (Object)entityAIWanderAvoidWater)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                EntityAIWanderAvoidWater entityAIWanderAvoidWater = this.wander;
                if (entityAIWanderAvoidWater == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"wander");
                }
                this.tasks.addTask(5, (EntityAIBase)entityAIWanderAvoidWater);
            } else {
                this.tasks.taskEntries.removeIf((Predicate)new Predicate<EntityAITasks.EntityAITaskEntry>(this){
                    final /* synthetic */ EntityToad this$0;

                    public final boolean test(EntityAITasks.EntityAITaskEntry it) {
                        return Intrinsics.areEqual((Object)it.action, (Object)EntityToad.access$getWander$p(this.this$0));
                    }
                    {
                        this.this$0 = entityToad;
                    }
                });
            }
        }
        if (!(this.isFamiliarSitting() || this.world.isRemote || this.motionX == 0.0 && this.motionZ == 0.0 || this.isInWater())) {
            this.getJumpHelper().setJumping();
        }
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    public int getVerticalFaceSpeed() {
        return this.isFamiliarSitting() ? 20 : super.getVerticalFaceSpeed();
    }

    public boolean attackEntityFrom(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        float a = amount;
        if (this.isEntityInvulnerable(source)) {
            return false;
        }
        Entity entity = source.getTrueSource();
        if (!this.isFamiliar()) {
            this.setSitting(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            a = (a + 1.0f) / 2.0f;
        }
        return super.attackEntityFrom(source, a);
    }

    public boolean processInteract(@NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        if (this.isTemp()) {
            return true;
        }
        ItemStack stack = player.getHeldItem(hand);
        if (this.isTamed()) {
            if (this.isOwner((EntityLivingBase)player) && this.isFamiliar() && player.isSneaking() && this.isFamiliarSitting()) {
                if (!this.world.isRemote) {
                    this.dismiss(player);
                }
                return true;
            }
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (!itemStack.isEmpty()) {
                if (stack.getItem() == Items.ROTTEN_FLESH && this.getHealth() < this.getMaxHealth()) {
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                    this.heal(10.0f);
                    return true;
                }
                EnumDyeColor enumDyeColor = WitcheryUtils.getDyeColor(stack);
                if (enumDyeColor != null) {
                    EnumDyeColor enumDyeColor2 = enumDyeColor;
                    boolean bl = false;
                    boolean bl2 = false;
                    EnumDyeColor it = enumDyeColor2;
                    boolean bl3 = false;
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                    this.setColor(it);
                    return true;
                }
                if (stack.getItem() == Items.NAME_TAG || stack.getItem() == WitcheryGeneralItems.POLYNESIA_CHARM || stack.getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM) {
                    return false;
                }
            }
            if (this.isOwner((EntityLivingBase)player) && !this.isBreedingItem(stack)) {
                if (!this.world.isRemote) {
                    this.setSitting(!this.isFamiliarSitting());
                    this.getJumpHelper().doJump();
                    this.isJumping = false;
                    this.getNavigator().clearPath();
                    this.setAttackTarget(null);
                }
                return true;
            }
        } else {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (!itemStack.isEmpty() && stack.getItem() == Items.ROTTEN_FLESH) {
                if (!player.capabilities.isCreativeMode) {
                    stack.shrink(1);
                }
                if (!this.world.isRemote) {
                    if (this.rand.nextInt(3) == 0) {
                        this.enablePersistence();
                        this.getNavigator().clearPath();
                        this.setAttackTarget(null);
                        this.setSitting(true);
                        this.setTamedBy(player);
                        this.playTameEffect(true);
                        this.world.setEntityState((Entity)this, (byte)7);
                    } else {
                        this.playTameEffect(false);
                        this.world.setEntityState((Entity)this, (byte)6);
                    }
                }
                return true;
            }
        }
        return super.processInteract(player, hand);
    }

    public boolean isBreedingItem(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return stack.getItem() == Items.ROTTEN_FLESH;
    }

    public boolean canMateWith(@NotNull EntityAnimal animal) {
        Intrinsics.checkParameterIsNotNull((Object)animal, (String)"animal");
        return animal != this && this.isTamed() && animal instanceof EntityToad && ((EntityToad)animal).isTamed() && !((EntityToad)animal).isFamiliarSitting() && this.isInLove() && ((EntityToad)animal).isInLove();
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean shouldAttackEntity(@NotNull EntityLivingBase target, @NotNull EntityLivingBase owner) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            if (target instanceof EntityToad && ((EntityToad)target).isTamed() && ((EntityToad)target).getOwner() == owner) {
                return false;
            }
            return !(target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).canAttackPlayer((EntityPlayer)target) || target instanceof EntityHorse && ((EntityHorse)target).isTame());
        }
        return false;
    }

    @Nullable
    public EntityAgeable createChild(@NotNull EntityAgeable mate) {
        Intrinsics.checkParameterIsNotNull((Object)mate, (String)"mate");
        World world = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        EntityToad entity = new EntityToad(world);
        if (this.getOwnerId() != null) {
            entity.enablePersistence();
            entity.setColor(this.getColor());
        }
        return (EntityAgeable)entity;
    }

    public EntityToad(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.timeToLive = -1;
    }

    static {
        Companion = new Companion(null);
        NAMES = new String[]{"Casper", "Wart", "Langston", "Croaker", "Prince Charming", "Frog-n-stien", "Randolph", "Evileye", "Churchill", "Santa", "Dillinger", "Spuds"};
        COLOR = EntityDataManager.createKey(EntityToad.class, (DataSerializer)DataSerializers.BYTE);
        FAMILIAR = EntityDataManager.createKey(EntityToad.class, (DataSerializer)DataSerializers.BOOLEAN);
    }

    public static final /* synthetic */ EntityAIDimensionalFollowOwner access$getFollow$p(EntityToad $this) {
        EntityAIDimensionalFollowOwner entityAIDimensionalFollowOwner = $this.follow;
        if (entityAIDimensionalFollowOwner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"follow");
        }
        return entityAIDimensionalFollowOwner;
    }

    public static final /* synthetic */ void access$setFollow$p(EntityToad $this, EntityAIDimensionalFollowOwner entityAIDimensionalFollowOwner) {
        $this.follow = entityAIDimensionalFollowOwner;
    }

    public static final /* synthetic */ EntityAIWanderAvoidWater access$getWander$p(EntityToad $this) {
        EntityAIWanderAvoidWater entityAIWanderAvoidWater = $this.wander;
        if (entityAIWanderAvoidWater == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wander");
        }
        return entityAIWanderAvoidWater;
    }

    public static final /* synthetic */ void access$setWander$p(EntityToad $this, EntityAIWanderAvoidWater entityAIWanderAvoidWater) {
        $this.wander = entityAIWanderAvoidWater;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/msrandom/witchery/entity/passive/EntityToad$Companion;", "", "()V", "COLOR", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "FAMILIAR", "", "NAMES", "", "", "[Ljava/lang/String;", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().creature(EnumCreatureType.CREATURE).egg(7553575, 5996288).size(0.8f, 0.8f).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

