/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.passive;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityFlyingTameable;
import net.msrandom.witchery.entity.ai.EntityAIFlyerAttackOnCollide;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFlyToWaypoint;
import net.msrandom.witchery.entity.ai.EntityAIFlyerFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAIFlyerLand;
import net.msrandom.witchery.entity.ai.EntityAIFlyerMate;
import net.msrandom.witchery.entity.ai.EntityAIFlyerWander;
import net.msrandom.witchery.entity.ai.EntityAIFlyingTempt;
import net.msrandom.witchery.entity.ai.EntityAISitAndStay;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.entity.passive.EntityOwl;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.DataDelegate;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 Y2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001YB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000eH\u0016J\b\u00102\u001a\u00020\u0012H\u0014J\b\u00103\u001a\u00020\u0012H\u0014J\u0010\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u000206H\u0016J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u000208H\u0016J\u0010\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020 H\u0014J\b\u0010<\u001a\u00020*H\u0014J\b\u0010=\u001a\u00020>H\u0014J\b\u0010?\u001a\u00020\u0012H\u0016J\b\u0010@\u001a\u00020>H\u0014J\u0010\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u000200H\u0014J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J\b\u0010E\u001a\u00020 H\u0016J\b\u0010F\u001a\u00020 H\u0016J\u0010\u0010G\u001a\u00020*2\u0006\u0010H\u001a\u00020\nH\u0016J\b\u0010I\u001a\u00020*H\u0014J\u0010\u0010J\u001a\u00020\u00122\u0006\u0010K\u001a\u00020LH\u0016J\b\u0010M\u001a\u00020*H\u0016J\u0018\u0010N\u001a\u00020\u00122\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u00020UH\u0016J\u000e\u0010V\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020 J\b\u0010W\u001a\u00020*H\u0016J\u0010\u0010X\u001a\u00020*2\u0006\u0010T\u001a\u00020UH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u001c\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020 8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006Z"}, d2={"Lnet/msrandom/witchery/entity/passive/EntityOwl;", "Lnet/msrandom/witchery/entity/EntityFlyingTameable;", "Lnet/msrandom/witchery/entity/familiar/Familiar;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "aiTempt", "Lnet/minecraft/entity/ai/EntityAIBase;", "colorParameter", "Lnet/minecraft/network/datasync/DataParameter;", "", "getColorParameter", "()Lnet/minecraft/network/datasync/DataParameter;", "defaultHealth", "", "getDefaultHealth", "()F", "familiarProperty", "", "getFamiliarProperty", "familiarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "getFamiliarType", "()Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "isTemp", "()Z", "names", "", "", "getNames", "()[Ljava/lang/String;", "timeToLive", "", "<set-?>", "variant", "getVariant", "()I", "setVariant", "(I)V", "variant$delegate", "Lnet/msrandom/witchery/util/DataDelegate;", "applyEntityAttributes", "", "attackEntityAsMob", "entity", "Lnet/minecraft/entity/Entity;", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "par2", "canDespawn", "canDropLoot", "canMateWith", "otherAnimal", "Lnet/minecraft/entity/passive/EntityAnimal;", "createChild", "Lnet/minecraft/entity/EntityAgeable;", "mate", "decreaseAirSupply", "air", "entityInit", "getAmbientSound", "Lnet/minecraft/util/SoundEvent;", "getCanSpawnHere", "getDeathSound", "getHurtSound", "damageSourceIn", "getOwner", "Lnet/minecraft/entity/EntityLivingBase;", "getTalkInterval", "getTotalArmorValue", "handleStatusUpdate", "id", "initEntityAI", "isBreedingItem", "itemstack", "Lnet/minecraft/item/ItemStack;", "onUpdate", "processInteract", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "setTimeToLive", "updateAITasks", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityOwl
extends EntityFlyingTameable
implements Familiar<EntityOwl> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private EntityAIBase aiTempt;
    private int timeToLive;
    private final DataDelegate variant$delegate;
    private static final String[] NAMES;
    private static final DataParameter<Integer> VARIANT;
    private static final DataParameter<Byte> COLOR;
    private static final DataParameter<Boolean> FAMILIAR;
    private static final Ingredient TEMPTATIONS;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityOwl.class), "variant", "getVariant()I"))};
        Companion = new Companion(null);
        NAMES = new String[]{"Archimedes", "Dumbledornithologist", "Al Travis", "Baltimore", "Cornelius", "Hadwig", "Hoot", "Merlin", "Owl Capone", "Pigwidgeon", "Athena", "Albertine"};
        VARIANT = EntityDataManager.createKey(EntityOwl.class, (DataSerializer)DataSerializers.VARINT);
        COLOR = EntityDataManager.createKey(EntityOwl.class, (DataSerializer)DataSerializers.BYTE);
        FAMILIAR = EntityDataManager.createKey(EntityOwl.class, (DataSerializer)DataSerializers.BOOLEAN);
        TEMPTATIONS = Ingredient.fromItems((Item[])new Item[]{Items.PORKCHOP, Items.BEEF});
    }

    public final boolean isTemp() {
        return this.timeToLive != -1;
    }

    private final int getVariant() {
        return ((Number)this.variant$delegate.getValue((Entity)this, $$delegatedProperties[0])).intValue();
    }

    private final void setVariant(int n) {
        this.variant$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[0], n);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(VARIANT, (Object)0);
        this.dataManager.register(COLOR, (Object)((byte)(this.world.rand.nextInt(100) == 0 ? 0 : this.world.rand.nextInt(15) + 1)));
        this.dataManager.register(FAMILIAR, (Object)false);
    }

    protected void initEntityAI() {
        super.initEntityAI();
        this.aiTempt = new EntityAIFlyingTempt((EntityCreature)this, TEMPTATIONS, true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay(this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIFlyerFlyToWaypoint(this, EntityAIFlyerFlyToWaypoint.CarryRequirement.HELD_ITEM));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFlyerAttackOnCollide((EntityCreature)this, 1.0, true));
        EntityAIBase entityAIBase = this.aiTempt;
        if (entityAIBase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aiTempt");
        }
        this.tasks.addTask(4, entityAIBase);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIFlyerFollowOwner<Entity>((Entity)this, 14.0f, 5.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIFlyerMate((EntityAnimal)this, 0.8));
        this.tasks.addTask(9, (EntityAIBase)new EntityAIFlyerLand((EntityLiving)this, true));
        this.tasks.addTask(10, (EntityAIBase)new EntityAIFlyerWander((EntityLiving)this, 10.0));
        this.tasks.addTask(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f, 0.2f));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + (this.isFamiliar() ? 5 : 1);
    }

    public void onUpdate() {
        this.isImmuneToFire = this.isFamiliar();
        super.onUpdate();
    }

    @Override
    public void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.writeEntityToNBT(compound);
        compound.setByte("Color", (byte)this.getColor().getMetadata());
        compound.setBoolean("Familiar", this.isFamiliar());
        compound.setInteger("SuicideIn", this.timeToLive);
    }

    @Override
    public void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.readEntityFromNBT(compound);
        EnumDyeColor enumDyeColor = EnumDyeColor.byMetadata((int)compound.getByte("Color"));
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(\u2026getByte(\"Color\").toInt())");
        this.setColor(enumDyeColor);
        this.setFamiliar(compound.getBoolean("Familiar"));
        this.timeToLive = compound.getInteger("SuicideIn");
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    @Override
    @Nullable
    public FamiliarType<EntityOwl> getFamiliarType() {
        return WitcheryFamiliars.getOwl();
    }

    @Override
    @NotNull
    public DataParameter<Boolean> getFamiliarProperty() {
        DataParameter<Boolean> dataParameter = FAMILIAR;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"FAMILIAR");
        return dataParameter;
    }

    @Override
    @Nullable
    public DataParameter<Byte> getColorParameter() {
        return COLOR;
    }

    @Override
    public float getDefaultHealth() {
        return 15.0f;
    }

    @Override
    @NotNull
    public String[] getNames() {
        return NAMES;
    }

    @Nullable
    public EntityLivingBase getOwner() {
        return this.getFamiliarOwner(super.getOwner());
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.setBaseValue(10.0);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance2.setBaseValue(0.3);
        IAttributeInstance iAttributeInstance3 = this.getAttributeMap().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance3, (String)"attributeMap.registerAtt\u2026Attributes.ATTACK_DAMAGE)");
        iAttributeInstance3.setBaseValue(4.0);
    }

    protected boolean canDespawn() {
        return false;
    }

    public void updateAITasks() {
        block2: {
            block3: {
                this.getNavigator().clearPath();
                super.updateAITasks();
                if (this.isDead || this.world.isRemote || this.timeToLive == -1) break block2;
                EntityOwl entityOwl = this;
                entityOwl.timeToLive += -1;
                int cfr_ignored_0 = entityOwl.timeToLive;
                if (this.timeToLive == 0) break block3;
                EntityLivingBase entityLivingBase = this.getAttackTarget();
                boolean bl = false;
                boolean bl2 = false;
                EntityLivingBase it = entityLivingBase;
                boolean bl3 = false;
                if (!(it == null || it.isDead)) break block2;
            }
            this.world.setEntityState((Entity)this, (byte)5);
            this.setDead();
        }
    }

    protected boolean canDropLoot() {
        return super.canDropLoot() && !this.isTemp();
    }

    public int getTalkInterval() {
        return super.getTalkInterval() * 2;
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_OWL_HOOT;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        Intrinsics.checkParameterIsNotNull((Object)damageSourceIn, (String)"damageSourceIn");
        return WitcherySounds.ENTITY_OWL_HURT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_OWL_HURT;
    }

    public boolean attackEntityAsMob(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        return entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)((EntityLivingBase)this)), 2.0f);
    }

    public boolean attackEntityFrom(@NotNull DamageSource source, float par2) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (this.isEntityInvulnerable(source)) {
            return false;
        }
        if (!this.isFamiliar()) {
            this.setSitting(false);
        }
        return super.attackEntityFrom(source, par2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean processInteract(@NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        if (this.isTemp()) {
            return true;
        }
        ItemStack stack = player.getHeldItem(hand);
        if (this.isTamed()) {
            if (this.isOwner((EntityLivingBase)player) && this.isFamiliar() && player.isSneaking() && this.isFamiliarSitting()) {
                if (this.world.isRemote) return true;
                this.dismiss(player);
                return true;
            }
            if (this.isOwner((EntityLivingBase)player)) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                if (!this.isBreedingItem(itemStack)) {
                    EnumDyeColor enumDyeColor = WitcheryUtils.getDyeColor(stack);
                    if (enumDyeColor != null) {
                        EnumDyeColor enumDyeColor2 = enumDyeColor;
                        boolean bl = false;
                        boolean bl2 = false;
                        EnumDyeColor it = enumDyeColor2;
                        boolean bl3 = false;
                        if (!player.capabilities.isCreativeMode) {
                            stack.shrink(1);
                        }
                        this.setColor(it);
                        return true;
                    }
                    if (!stack.isEmpty()) {
                        if (stack.getItem() == Items.NAME_TAG) return false;
                        if (stack.getItem() == WitcheryGeneralItems.POLYNESIA_CHARM) return false;
                        if (stack.getItem() == WitcheryGeneralItems.DEVILS_TONGUE_CHARM) {
                            return false;
                        }
                    }
                    if (!stack.isEmpty()) {
                        ItemStack itemStack2 = this.getHeldItem(hand);
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"getHeldItem(hand)");
                        if (itemStack2.isEmpty()) {
                            if (stack.getCount() == 1) {
                                this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, stack);
                                player.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                                return true;
                            }
                            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, stack.splitStack(1));
                            return true;
                        }
                    }
                    if (stack.getItem() == WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE || stack.getItem() == WitcheryIngredientItems.BOUND_WAYSTONE) {
                        this.waypoint = stack.copy();
                        this.homeX = this.posX;
                        this.homeY = this.posY;
                        this.homeZ = this.posZ;
                        this.world.playSound(null, this.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, this.getSoundCategory(), 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        if (!this.world.isRemote) return true;
                        int n = 20;
                        boolean bl = false;
                        int n2 = 0;
                        n2 = 0;
                        int n3 = n;
                        while (n2 < n3) {
                            int it = n2++;
                            boolean bl4 = false;
                            this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.world.rand.nextDouble() * (double)2 - 1.0, this.posY + this.world.rand.nextDouble(), this.posZ + (double)(this.world.rand.nextFloat() * (float)2) - 1.0, 0.0, 0.0, 0.0, new int[0]);
                        }
                        return true;
                    }
                    ItemStack itemStack3 = this.getHeldItem(hand);
                    Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"getHeldItem(hand)");
                    if (!itemStack3.isEmpty()) {
                        ItemStack itemStack4 = this.waypoint;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack4, (String)"waypoint");
                        if (itemStack4.isEmpty()) {
                            ItemStack heldStack = this.getHeldItem(hand);
                            this.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                            if (this.world.isRemote) return true;
                            this.world.spawnEntity((Entity)new EntityItem(this.world, this.posX, this.posY, this.posZ, heldStack));
                            return true;
                        }
                    }
                    if (!(this.getDistanceSq((Entity)player) < 9.0)) return true;
                    if (this.world.isRemote) return true;
                    this.setSitting(!this.isFamiliarSitting());
                    return true;
                }
            }
            if (this.isOwner((EntityLivingBase)player)) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                if (this.isBreedingItem(itemStack) && this.getHealth() < this.getMaxHealth()) {
                    if (this.world.isRemote) return true;
                    this.heal(10.0f);
                    if (player.capabilities.isCreativeMode) return true;
                    stack.shrink(1);
                    return true;
                }
            }
            boolean bl = super.processInteract(player, hand);
            return bl;
        }
        ItemStack itemStack = stack;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        if (!itemStack.isEmpty() && (stack.getItem() == Items.PORKCHOP || stack.getItem() == Items.BEEF) && player.getDistanceSq((Entity)this) < 9.0) {
            if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            if (this.world.isRemote) return true;
            if (this.rand.nextInt(3) == 0) {
                this.setVariant(1 + this.world.rand.nextInt(3));
                this.setTamedBy(player);
                this.enablePersistence();
                this.playTameEffect(true);
                this.setSitting(true);
                this.world.setEntityState((Entity)this, (byte)7);
                return true;
            }
            this.playTameEffect(false);
            this.world.setEntityState((Entity)this, (byte)6);
            return true;
        }
        if (this.isBreedingItem(stack)) return false;
        if (!super.processInteract(player, hand)) return false;
        return true;
    }

    public void handleStatusUpdate(byte id) {
        if (!this.handleDismissParticles(id)) {
            if (id == 5) {
                int n = 20;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.world.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, this.posX + this.world.rand.nextDouble() * (double)2 - 1.0, this.posY + this.world.rand.nextDouble(), this.posZ + (double)(this.world.rand.nextFloat() * (float)2) - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                super.handleStatusUpdate(id);
            }
        }
    }

    public boolean isBreedingItem(@NotNull ItemStack itemstack) {
        Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
        return itemstack.getItem() == Items.PORKCHOP || itemstack.getItem() == Items.BEEF;
    }

    public boolean canMateWith(@NotNull EntityAnimal otherAnimal) {
        Intrinsics.checkParameterIsNotNull((Object)otherAnimal, (String)"otherAnimal");
        return otherAnimal != this && this.isTamed() && otherAnimal instanceof EntityOwl && ((EntityOwl)otherAnimal).isTamed() && this.isInLove() && ((EntityOwl)otherAnimal).isInLove();
    }

    public boolean getCanSpawnHere() {
        if (this.world.rand.nextInt(3) == 0) {
            return false;
        }
        if (this.world.checkNoEntityCollision(this.getEntityBoundingBox()) && this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox())) {
            IBlockState state;
            int i = MathHelper.floor((double)this.posX);
            int j = MathHelper.floor((double)this.getEntityBoundingBox().minY);
            int k = MathHelper.floor((double)this.posZ);
            if (j < 63) {
                return false;
            }
            BlockPos pos = new BlockPos(i, j - 1, k);
            IBlockState iBlockState = state = this.world.getBlockState(pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
            Block block = iBlockState.getBlock();
            return block == Blocks.GRASS || block.isLeaves(state, (IBlockAccess)this.world, pos.down());
        }
        return false;
    }

    @Nullable
    public EntityAgeable createChild(@NotNull EntityAgeable mate) {
        Intrinsics.checkParameterIsNotNull((Object)mate, (String)"mate");
        World world = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        EntityOwl child = WitcheryEntities.OWL.create(world);
        if (child != null && this.isTamed()) {
            child.enablePersistence();
            child.setVariant(this.getVariant());
            child.setColor(this.getColor());
        }
        return (EntityAgeable)child;
    }

    public final void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public EntityOwl(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.timeToLive = -1;
        DataParameter<Integer> dataParameter = VARIANT;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"VARIANT");
        this.variant$delegate = new DataDelegate<Integer>(dataParameter);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lnet/msrandom/witchery/entity/passive/EntityOwl$Companion;", "", "()V", "COLOR", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "FAMILIAR", "", "NAMES", "", "", "[Ljava/lang/String;", "TEMPTATIONS", "Lnet/minecraft/item/crafting/Ingredient;", "VARIANT", "", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().creature(EnumCreatureType.CREATURE).egg(0xE2E2E2, 6049609).size(0.6f, 0.8f).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

