/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.passive;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.msrandom.witchery.entity.monster.EntityLilith;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0014J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\nH\u0014J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\nH\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnet/msrandom/witchery/entity/passive/EntityElle;", "Lnet/minecraft/entity/passive/EntityTameable;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "lavaPosition", "Lnet/minecraft/util/math/BlockPos;", "transformCount", "", "applyEntityAttributes", "", "createChild", "Lnet/minecraft/entity/EntityAgeable;", "ageable", "decreaseAirSupply", "air", "getExperiencePoints", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "handleStatusUpdate", "id", "", "initEntityAI", "isCourseTraversable", "", "targetX", "", "targetY", "targetZ", "distance", "isLavaPool", "pos", "isLavaPoolColumn", "updateAITasks", "WitcheryResurrected"})
public final class EntityElle
extends EntityTameable {
    private int transformCount;
    private BlockPos lavaPosition;

    protected void initEntityAI() {
        super.initEntityAI();
        PathNavigate pathNavigate = this.getNavigator();
        if (pathNavigate == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.pathfinding.PathNavigateGround");
        }
        ((PathNavigateGround)pathNavigate).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 2.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFollowOwner(this, this, 1.0, 2.0f, 4.0f){
            final /* synthetic */ EntityElle this$0;

            public boolean shouldExecute() {
                return super.shouldExecute() && EntityElle.access$getLavaPosition$p(this.this$0) == null;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.setBaseValue(20.0);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance2.setBaseValue(0.3);
    }

    private final boolean isLavaPool(World world, BlockPos pos) {
        if (this.isLavaPoolColumn(world, pos)) {
            BlockPos blockPos = pos.east();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.east()");
            if (this.isLavaPoolColumn(world, blockPos)) {
                BlockPos blockPos2 = pos.west();
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.west()");
                if (this.isLavaPoolColumn(world, blockPos2)) {
                    BlockPos blockPos3 = pos.south();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos.south()");
                    if (this.isLavaPoolColumn(world, blockPos3)) {
                        BlockPos blockPos4 = pos.north();
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"pos.north()");
                        if (this.isLavaPoolColumn(world, blockPos4)) {
                            int max2 = 36;
                            for (BlockPos p : BlockPos.getAllInBox((BlockPos)pos.add(-6, 0, -6), (BlockPos)pos.add(6, 0, 6))) {
                                double dist = pos.distanceSq((Vec3i)p);
                                if (!(dist <= (double)max2)) continue;
                                IBlockState iBlockState = world.getBlockState(p);
                                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(p)");
                                BlockStaticLiquid blockStaticLiquid = Blocks.LAVA;
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockStaticLiquid, (String)"Blocks.LAVA");
                                if (WitcheryUtils.isOf(iBlockState, (Block)blockStaticLiquid)) continue;
                                return false;
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean isLavaPoolColumn(World world, BlockPos pos) {
        BlockPos p = pos.up();
        if (world.isAirBlock(p) && world.isAirBlock(p.up())) {
            int n = 5;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                IBlockState iBlockState = world.getBlockState(pos.down(it));
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.down(it))");
                BlockStaticLiquid blockStaticLiquid = Blocks.LAVA;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockStaticLiquid, (String)"Blocks.LAVA");
                if (WitcheryUtils.isOf(iBlockState, (Block)blockStaticLiquid)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean isCourseTraversable(double targetX, double targetY, double targetZ, double distance) {
        double x = (targetX - this.posX) / distance;
        double y = (targetY - this.posY) / distance;
        double z = (targetZ - this.posZ) / distance;
        AxisAlignedBB box = this.getEntityBoundingBox();
        int i = 1;
        while ((double)i < distance) {
            box.offset(x, y, z);
            List list2 = this.world.getCollisionBoxes((Entity)this, box);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"world.getCollisionBoxes(this, box)");
            Collection collection = list2;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateAITasks() {
        block5: {
            block6: {
                double waypointZ;
                double waypointY;
                double zDistance;
                double yDistance;
                BlockPos lavaPos;
                block7: {
                    block8: {
                        super.updateAITasks();
                        if (this.world.isRemote || this.ticksExisted % 10 != 1) break block5;
                        lavaPos = this.lavaPosition;
                        if (lavaPos == null) break block6;
                        if (!(this.getDistanceSq(lavaPos) < (double)4)) break block7;
                        EntityElle entityElle = this;
                        ++entityElle.transformCount;
                        int cfr_ignored_0 = entityElle.transformCount;
                        if (this.transformCount != 20) break block8;
                        EntityLivingBase owner = this.getOwner();
                        if (owner instanceof EntityPlayer) {
                            if (!WitcheryUtils.getExtension((EntityPlayer)owner).isTransformation(WitcheryTransformations.VAMPIRE)) {
                                owner.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.summon", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                            }
                            this.world.playSound(null, this.getPosition(), WitcherySounds.ENTITY_LILITH_AMBIENT, this.getSoundCategory(), 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        }
                        break block5;
                    }
                    if (this.transformCount != 40) break block5;
                    this.transformCount = 0;
                    this.playSound(SoundEvents.ENTITY_FIREWORK_BLAST, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)5);
                    World world = this.world;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                    EntityLilith vampire = WitcheryEntities.LILITH.create(world);
                    if (vampire == null) break block5;
                    EntityLivingBase owner = this.getOwner();
                    vampire.enablePersistence();
                    vampire.copyLocationAndAnglesFrom((Entity)this);
                    vampire.onInitialSpawn(this.world.getDifficultyForLocation(vampire.getPosition()), null);
                    this.world.removeEntity((Entity)this);
                    this.world.spawnEntity((Entity)vampire);
                    vampire.world.playEvent(1017, vampire.getPosition(), 0);
                    if (owner instanceof EntityPlayer) {
                        vampire.setSummoner((EntityPlayer)owner);
                        owner.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.summon2", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                        this.world.playSound(null, vampire.getPosition(), WitcherySounds.ENTITY_LILITH_AMBIENT, this.getSoundCategory(), 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    }
                    this.world.createExplosion((Entity)vampire, vampire.posX, vampire.posY, vampire.posZ, 6.0f, ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)((Entity)this)));
                    break block5;
                }
                double xDistance = (double)lavaPos.getX() - this.posX;
                double distance = xDistance * xDistance + (yDistance = (double)lavaPos.getY() - this.posY) * yDistance + (zDistance = (double)lavaPos.getZ() - this.posZ) * zDistance;
                if (!(distance > 0.0)) break block5;
                distance = MathHelper.sqrt((double)distance);
                double waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                if (!this.isCourseTraversable(waypointX, waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f), waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f), distance)) break block5;
                this.motionX += xDistance / distance * 0.2;
                this.motionY += yDistance / distance * 0.2;
                this.motionZ += zDistance / distance * 0.2;
                break block5;
            }
            int xDistance = 0;
            int n = 10;
            while (xDistance < n) {
                void i;
                int x = MathHelper.floor((double)(this.posX + (double)this.rand.nextInt(30) - 15.0));
                int y = MathHelper.floor((double)(this.getEntityBoundingBox().minY + (double)this.rand.nextInt(6) - 3.0));
                int z = MathHelper.floor((double)(this.posZ + (double)this.rand.nextInt(30) - 15.0));
                BlockPos pos = new BlockPos(x, y, z);
                World world = this.world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                if (this.isLavaPool(world, pos)) {
                    this.lavaPosition = pos;
                    break;
                }
                ++i;
            }
        }
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected int getExperiencePoints(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        return 0;
    }

    public void handleStatusUpdate(byte id) {
        if (id == 5) {
            int n = 20;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                this.world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, this.posX + this.rand.nextDouble() * (double)2 - 1.0, this.posY + this.rand.nextDouble(), this.posZ + this.rand.nextDouble() * (double)2 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(id);
        }
    }

    @Nullable
    public EntityAgeable createChild(@NotNull EntityAgeable ageable) {
        Intrinsics.checkParameterIsNotNull((Object)ageable, (String)"ageable");
        return null;
    }

    public EntityElle(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.isImmuneToFire = true;
    }

    public static final /* synthetic */ BlockPos access$getLavaPosition$p(EntityElle $this) {
        return $this.lavaPosition;
    }

    public static final /* synthetic */ void access$setLavaPosition$p(EntityElle $this, BlockPos blockPos) {
        $this.lavaPosition = blockPos;
    }
}

