/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.passive;

import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.ai.EntityAIDimensionalFollowOwner;
import net.msrandom.witchery.entity.ai.EntityAISitAndStay;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.entity.passive.EntityCatFamiliar;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0014J\b\u0010!\u001a\u00020\"H\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020\"H\u0014J\b\u0010)\u001a\u00020\"H\u0016J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Lnet/msrandom/witchery/entity/passive/EntityCatFamiliar;", "Lnet/minecraft/entity/passive/EntityOcelot;", "Lnet/msrandom/witchery/entity/familiar/Familiar;", "ocelot", "(Lnet/minecraft/entity/passive/EntityOcelot;)V", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "colorParameter", "Lnet/minecraft/network/datasync/DataParameter;", "", "getColorParameter", "()Lnet/minecraft/network/datasync/DataParameter;", "familiarProperty", "", "getFamiliarProperty", "familiarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "getFamiliarType", "()Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "names", "", "", "getNames", "()[Ljava/lang/String;", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "decreaseAirSupply", "", "air", "entityInit", "", "getOwner", "Lnet/minecraft/entity/EntityLivingBase;", "getTotalArmorValue", "handleStatusUpdate", "id", "initEntityAI", "onUpdate", "processInteract", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityCatFamiliar
extends EntityOcelot
implements Familiar<EntityOcelot> {
    private static final String[] NAMES;
    private static final DataParameter<Byte> COLOR;
    private static final DataParameter<Boolean> FAMILIAR;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    protected void initEntityAI() {
        Object element$iv2;
        EntityAITasks entityAITasks;
        block1: {
            void $this$first$iv;
            super.initEntityAI();
            this.tasks.removeTask((EntityAIBase)this.aiSit);
            Set set2 = this.tasks.taskEntries;
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"tasks.taskEntries");
            Iterable iterable = set2;
            entityAITasks = this.tasks;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                EntityAITasks.EntityAITaskEntry it = (EntityAITasks.EntityAITaskEntry)element$iv2;
                boolean bl = false;
                if (!(it.action instanceof EntityAIOcelotSit)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        entityAITasks.removeTask(((EntityAITasks.EntityAITaskEntry)t).action);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISitAndStay((EntityTameable)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIDimensionalFollowOwner((EntityTameable)this, 1.0, 10.0f, 5.0f));
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.writeEntityToNBT(compound);
        compound.setByte("Color", (byte)this.getColor().getMetadata());
        compound.setBoolean("Familiar", this.isFamiliar());
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.readEntityFromNBT(compound);
        EnumDyeColor enumDyeColor = EnumDyeColor.byMetadata((int)compound.getByte("Color"));
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(\u2026getByte(\"Color\").toInt())");
        this.setColor(enumDyeColor);
        this.setFamiliar(compound.getBoolean("Familiar"));
    }

    public void onUpdate() {
        this.isImmuneToFire = this.isFamiliar();
        super.onUpdate();
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + (this.isFamiliar() ? 5 : 0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(COLOR, (Object)0);
        this.dataManager.register(this.getFamiliarProperty(), (Object)false);
    }

    public boolean attackEntityFrom(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        boolean sitting = this.isFamiliarSitting();
        boolean result2 = super.attackEntityFrom(source, amount);
        if (sitting && this.isFamiliar()) {
            this.setSitting(true);
        }
        return result2;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    @Override
    @Nullable
    public FamiliarType<EntityOcelot> getFamiliarType() {
        return WitcheryFamiliars.getCat();
    }

    @Override
    @NotNull
    public DataParameter<Boolean> getFamiliarProperty() {
        DataParameter<Boolean> dataParameter = FAMILIAR;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"FAMILIAR");
        return dataParameter;
    }

    @Override
    @Nullable
    public DataParameter<Byte> getColorParameter() {
        return COLOR;
    }

    @Override
    @NotNull
    public String[] getNames() {
        return NAMES;
    }

    @Nullable
    public EntityLivingBase getOwner() {
        return this.getFamiliarOwner(super.getOwner());
    }

    public boolean processInteract(@NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack stack = player.getHeldItem(hand);
        if (this.isTamed()) {
            if (this.isOwner((EntityLivingBase)player) && this.isFamiliar() && player.isSneaking() && this.isFamiliarSitting()) {
                if (!this.world.isRemote) {
                    this.dismiss(player);
                }
                return true;
            }
            if (this.isOwner((EntityLivingBase)player)) {
                ItemStack itemStack = stack;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
                EnumDyeColor enumDyeColor = WitcheryUtils.getDyeColor(itemStack);
                if (enumDyeColor != null) {
                    EnumDyeColor enumDyeColor2 = enumDyeColor;
                    boolean bl = false;
                    boolean bl2 = false;
                    EnumDyeColor it = enumDyeColor2;
                    boolean bl3 = false;
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                    }
                    this.setColor(it);
                    return true;
                }
                if (stack.isEmpty() || !this.isBreedingItem(stack) && stack.getItem() != Items.NAME_TAG && stack.getItem() != WitcheryGeneralItems.POLYNESIA_CHARM && stack.getItem() != WitcheryGeneralItems.DEVILS_TONGUE_CHARM) {
                    if (!this.world.isRemote) {
                        this.setSitting(!this.isFamiliarSitting());
                    }
                    return true;
                }
                if (!stack.isEmpty() && this.isBreedingItem(stack) && this.getHealth() < this.getMaxHealth()) {
                    if (!this.world.isRemote) {
                        if (!player.capabilities.isCreativeMode) {
                            stack.shrink(1);
                        }
                        this.heal(10.0f);
                    }
                    return true;
                }
            }
        }
        return super.processInteract(player, hand);
    }

    public void handleStatusUpdate(byte id) {
        if (!this.handleDismissParticles(id)) {
            super.handleStatusUpdate(id);
        }
    }

    public EntityCatFamiliar(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
    }

    public EntityCatFamiliar(@NotNull EntityOcelot ocelot) {
        Intrinsics.checkParameterIsNotNull((Object)ocelot, (String)"ocelot");
        World world = ocelot.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"ocelot.world");
        this(world);
        if (ocelot.hasCustomName()) {
            this.setCustomNameTag(ocelot.getCustomNameTag());
        }
        this.setLocationAndAngles(ocelot.posX, ocelot.posY, ocelot.posZ, ocelot.rotationYaw, ocelot.rotationPitch);
        this.setOwnerId(ocelot.getOwnerId());
        this.setTamed(true);
        this.setSitting(ocelot.isSitting());
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        IAttributeInstance iAttributeInstance2 = ocelot.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"ocelot.getEntityAttribut\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.setBaseValue(iAttributeInstance2.getAttributeValue());
        this.setHealth(ocelot.getHealth());
        this.setTameSkin(ocelot.getTameSkin());
    }

    static {
        Companion = new Companion(null);
        NAMES = new String[]{"Pyewackett", "Salem", "Gobbolino", "Sabbath", "Norris", "Crookshanks", "Binx", "Voodoo", "Raven", "Simpkin", "Fishbone", "Kismet"};
        COLOR = EntityDataManager.createKey(EntityCatFamiliar.class, (DataSerializer)DataSerializers.BYTE);
        FAMILIAR = EntityDataManager.createKey(EntityCatFamiliar.class, (DataSerializer)DataSerializers.BOOLEAN);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/msrandom/witchery/entity/passive/EntityCatFamiliar$Companion;", "", "()V", "COLOR", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "FAMILIAR", "", "NAMES", "", "", "[Ljava/lang/String;", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().creature(EnumCreatureType.CREATURE).size(0.6f, 0.7f).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

