/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.monster;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.symbol.AttrahoSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ConfudusSymbolEffect;
import net.msrandom.witchery.infusion.symbol.FlipendoSymbolEffect;
import net.msrandom.witchery.infusion.symbol.IgnianimaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ImpedimentaSymbolEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcherySymbolEffects;
import net.msrandom.witchery.item.ItemGlassGoblet;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.util.DataDelegate;
import net.msrandom.witchery.util.ElementWeight;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.OptionalDataDelegate;
import net.msrandom.witchery.util.WeightedElement;
import net.msrandom.witchery.util.WeightedElementKt;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 U2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001UB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020&H\u0014J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000202H\u0016J\b\u00107\u001a\u00020\u000eH\u0014J\u0010\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\bH\u0014J\b\u0010:\u001a\u00020&H\u0014J\n\u0010;\u001a\u0004\u0018\u00010<H\u0014J\b\u0010=\u001a\u000202H\u0016J\u0010\u0010>\u001a\u0002022\u0006\u0010/\u001a\u000200H\u0016J\b\u0010?\u001a\u00020<H\u0014J\u0010\u0010@\u001a\u00020<2\u0006\u0010/\u001a\u000200H\u0014J\b\u0010A\u001a\u00020\bH\u0016J\u0010\u0010B\u001a\u00020&2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020&H\u0014J\b\u0010F\u001a\u00020\u000eH\u0016J\u0010\u0010G\u001a\u00020&2\u0006\u0010/\u001a\u000200H\u0016J\b\u0010H\u001a\u00020&H\u0016J\u0018\u0010I\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010J\u001a\u00020KH\u0014J\u0010\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010P\u001a\u00020&H\u0016J\u0010\u0010Q\u001a\u00020&2\u0006\u0010R\u001a\u00020\u000eH\u0016J\b\u0010S\u001a\u00020&H\u0014J\u0010\u0010T\u001a\u00020&2\u0006\u0010M\u001a\u00020NH\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R*\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR/\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001c8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010$\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityLilith;", "Lnet/minecraft/entity/monster/EntityMob;", "Lnet/minecraft/entity/IRangedAttackMob;", "Lnet/msrandom/witchery/util/IHandleDeathTouch;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "<set-?>", "", "attackTimer", "getAttackTimer", "()I", "bossInfo", "Lnet/minecraft/world/BossInfoServer;", "", "isFriendly", "()Z", "setFriendly", "(Z)V", "isFriendly$delegate", "Lnet/msrandom/witchery/util/DataDelegate;", "value", "Lnet/minecraft/entity/player/EntityPlayer;", "summoner", "getSummoner", "()Lnet/minecraft/entity/player/EntityPlayer;", "setSummoner", "(Lnet/minecraft/entity/player/EntityPlayer;)V", "Ljava/util/UUID;", "summonerId", "getSummonerId", "()Ljava/util/UUID;", "setSummonerId", "(Ljava/util/UUID;)V", "summonerId$delegate", "Lnet/msrandom/witchery/util/OptionalDataDelegate;", "weaknessTimer", "addResizing", "", "addTrackingPlayer", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "applyEntityAttributes", "attackEntityAsMob", "entity", "Lnet/minecraft/entity/Entity;", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "damage", "", "attackEntityWithRangedAttack", "target", "Lnet/minecraft/entity/EntityLivingBase;", "distanceFactor", "canDespawn", "decreaseAirSupply", "air", "entityInit", "getAmbientSound", "Lnet/minecraft/util/SoundEvent;", "getBrightness", "getCapDT", "getDeathSound", "getHurtSound", "getTotalArmorValue", "handleStatusUpdate", "id", "", "initEntityAI", "isNonBoss", "onDeath", "onLivingUpdate", "processInteract", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "removeTrackingPlayer", "setInWeb", "setSwingingArms", "swingingArms", "updateAITasks", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityLilith
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final BossInfoServer bossInfo;
    @NotNull
    private final DataDelegate isFriendly$delegate;
    @Nullable
    private final OptionalDataDelegate summonerId$delegate;
    @Nullable
    private EntityPlayer summoner;
    private int weaknessTimer;
    private int attackTimer;
    @NotNull
    private static final List<WeightedElement<ProjectileSymbolEffect>> SPELLS;
    private static final DataParameter<Boolean> FRIENDLY;
    private static final DataParameter<Optional<UUID>> SUMMONER;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityLilith.class), "isFriendly", "isFriendly()Z")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityLilith.class), "summonerId", "getSummonerId()Ljava/util/UUID;"))};
        Companion = new Companion(null);
        SPELLS = WeightedElementKt.toWeightedList(CollectionsKt.listOf((Object[])new ElementWeight[]{new ElementWeight<IgnianimaSymbolEffect>(1, WitcherySymbolEffects.IGNIANIMA), new ElementWeight<FlipendoSymbolEffect>(5, WitcherySymbolEffects.FLIPENDO), new ElementWeight<ImpedimentaSymbolEffect>(1, WitcherySymbolEffects.IMPEDIMENTA), new ElementWeight<ConfudusSymbolEffect>(1, WitcherySymbolEffects.CONFUNDUS), new ElementWeight<AttrahoSymbolEffect>(5, WitcherySymbolEffects.ATTRAHO)}));
        FRIENDLY = EntityDataManager.createKey(EntityLilith.class, (DataSerializer)DataSerializers.BOOLEAN);
        SUMMONER = EntityDataManager.createKey(EntityLilith.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    }

    public final boolean isFriendly() {
        return (Boolean)this.isFriendly$delegate.getValue((Entity)this, $$delegatedProperties[0]);
    }

    public final void setFriendly(boolean bl) {
        this.isFriendly$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[0], bl);
    }

    @Nullable
    public final UUID getSummonerId() {
        return (UUID)this.summonerId$delegate.getValue((Entity)this, $$delegatedProperties[1]);
    }

    public final void setSummonerId(@Nullable UUID uUID) {
        this.summonerId$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[1], uUID);
    }

    @Nullable
    public final EntityPlayer getSummoner() {
        if (this.summoner != null) {
            return this.summoner;
        }
        World world = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        EntityPlayer player = WitcheryUtils.getPlayer(world, this.getSummonerId());
        if (player != null) {
            this.summoner = player;
        }
        return player;
    }

    public final void setSummoner(@Nullable EntityPlayer value) {
        block1: {
            this.summoner = value;
            EntityPlayer entityPlayer = value;
            if (entityPlayer == null) break block1;
            EntityPlayer entityPlayer2 = entityPlayer;
            boolean bl = false;
            boolean bl2 = false;
            EntityPlayer it = entityPlayer2;
            boolean bl3 = false;
            this.setSummonerId(it.getUniqueID());
            if (!it.capabilities.isCreativeMode) {
                this.setAttackTarget((EntityLivingBase)it);
            }
        }
    }

    public final int getAttackTimer() {
        return this.attackTimer;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(FRIENDLY, (Object)false);
        this.dataManager.register(SUMMONER, (Object)Optional.absent());
    }

    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        PathNavigate pathNavigate = this.getNavigator();
        if (pathNavigate == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.pathfinding.PathNavigateGround");
        }
        ((PathNavigateGround)pathNavigate).setCanSwim(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackRanged(this, this, 1.0, 20, 30.0f){
            final /* synthetic */ EntityLilith this$0;

            public boolean shouldExecute() {
                return !this.this$0.isFriendly() && super.shouldExecute();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityPlayer>(this, (EntityCreature)this, EntityPlayer.class, false){
            final /* synthetic */ EntityLilith this$0;

            public boolean shouldExecute() {
                return !this.this$0.isFriendly() && super.shouldExecute();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        });
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.setBaseValue(200.0);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance2.setBaseValue(0.35);
        IAttributeInstance iAttributeInstance3 = this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance3, (String)"getEntityAttribute(Share\u2026rAttributes.FOLLOW_RANGE)");
        iAttributeInstance3.setBaseValue(50.0);
        IAttributeInstance iAttributeInstance4 = this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance4, (String)"getEntityAttribute(Share\u2026tes.KNOCKBACK_RESISTANCE)");
        iAttributeInstance4.setBaseValue(1.0);
    }

    public void addTrackingPlayer(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public int getTotalArmorValue() {
        return 8;
    }

    public void setInWeb() {
    }

    private final void addResizing() {
        this.addPotionEffect(new PotionEffect(WitcheryPotionEffects.RESIZING, 10000, -3, true, true));
    }

    /*
     * WARNING - void declaration
     */
    protected void updateAITasks() {
        super.updateAITasks();
        if (!this.world.isRemote) {
            if (this.isFriendly()) {
                if (this.isPotionActive(WitcheryPotionEffects.RESIZING)) {
                    this.removePotionEffect(WitcheryPotionEffects.RESIZING);
                }
            } else {
                PotionEffect resizingPotion = this.getActivePotionEffect(WitcheryPotionEffects.RESIZING);
                if (resizingPotion == null) {
                    this.addResizing();
                } else if (resizingPotion.getAmplifier() != -3) {
                    this.removePotionEffect(WitcheryPotionEffects.RESIZING);
                    this.addResizing();
                }
            }
        }
        if (this.ticksExisted % 20 == 0) {
            if (this.weaknessTimer > 0) {
                EntityLilith entityLilith = this;
                entityLilith.weaknessTimer += -1;
                int cfr_ignored_0 = entityLilith.weaknessTimer;
            }
            if (!this.isPotionActive(WitcheryPotionEffects.CHILLED) && !this.isPotionActive(MobEffects.WEAKNESS) && this.weaknessTimer == 0) {
                this.heal(5.0f);
            } else if (this.weaknessTimer == 0) {
                this.heal(1.0f);
            }
        }
        if (!this.isFriendly() && this.ticksExisted % 20 == 0 && this.world.rand.nextInt(5) == 0 && !this.world.isRemote) {
            List players = this.world.getEntitiesWithinAABB(EntityPlayer.class, this.getEntityBoundingBox().grow(32.0, 16.0, 32.0));
            for (EntityPlayer player : players) {
                if (player.capabilities.isCreativeMode) continue;
                if (player.isPotionActive(MobEffects.FIRE_RESISTANCE)) {
                    player.removePotionEffect(MobEffects.FIRE_RESISTANCE);
                }
                if (!this.world.rand.nextBoolean()) continue;
                EntityPlayer entityPlayer = player;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"player");
                this.world.playSound(null, entityPlayer.getPosition(), SoundEvents.ENTITY_ENDERDRAGON_GROWL, this.getSoundCategory(), 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                int n = 0;
                int n2 = 3 + this.rand.nextInt(4);
                while (n < n2) {
                    void j;
                    EntitySmallFireball fireball = new EntitySmallFireball(this.world, player.posX + this.rand.nextDouble() * 4.0 - 2.0, player.posY + (double)this.rand.nextInt(2) + 14.0, player.posZ + this.rand.nextDouble() * 4.0 - 2.0, 0.0, -0.2, 0.0);
                    this.world.spawnEntity((Entity)fireball);
                    ++j;
                }
            }
        }
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            EntityLilith entityLilith = this;
            entityLilith.attackTimer += -1;
            int cfr_ignored_0 = entityLilith.attackTimer;
        }
    }

    public boolean attackEntityFrom(@NotNull DamageSource source, float damage) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            return super.attackEntityFrom(source, damage);
        }
        if (source.getTrueSource() != null && source.getImmediateSource() instanceof EntityLargeFireball && source.getTrueSource() instanceof EntityPlayer) {
            this.weaknessTimer = 10;
        }
        return super.attackEntityFrom(source, RangesKt.coerceAtMost((float)damage, (float)12.0f));
    }

    @Override
    public float getCapDT(@NotNull DamageSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return 12.0f;
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound tag) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            super.writeEntityToNBT(tag);
            tag.setBoolean("Friendly", this.isFriendly());
            UUID uUID = this.getSummonerId();
            if (uUID == null) break block0;
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            tag.setUniqueId("Summoner", it);
        }
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.readEntityFromNBT(tag);
        this.setFriendly(tag.getBoolean("Friendly"));
        if (tag.hasUniqueId("Summoner")) {
            this.setSummonerId(tag.getUniqueId("Summoner"));
        }
    }

    public boolean attackEntityAsMob(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        boolean flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)((EntityLivingBase)this)), 7.0f + (float)this.rand.nextInt(15));
        if (flag) {
            entity.motionY += (double)0.4f;
        }
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 4: {
                this.attackTimer = 10;
                this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
                break;
            }
            case 5: {
                int n = 20;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * (double)2 - 1.0, this.posY + this.rand.nextDouble() * (double)2, this.posZ + this.rand.nextDouble() * (double)2 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 6: {
                int n = 20;
                boolean bl = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n;
                while (n4 < n5) {
                    int it = n4++;
                    boolean bl3 = false;
                    this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 1.6 - 0.8, this.posY + this.rand.nextDouble() * 0.8, this.posZ + this.rand.nextDouble() * 1.6 - 0.8, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 7: {
                int n = 20;
                boolean bl = false;
                int n6 = 0;
                n6 = 0;
                int n7 = n;
                while (n6 < n7) {
                    int it = n6++;
                    boolean bl4 = false;
                    this.world.spawnParticle(EnumParticleTypes.REDSTONE, this.posX + this.rand.nextDouble() * (double)2 - 1.0, this.posY + this.rand.nextDouble() * 1.5, this.posZ + this.rand.nextDouble() * (double)2 - 1.0, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.handleStatusUpdate(id);
            }
        }
    }

    public float getBrightness() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isFriendly() ? null : WitcherySounds.ENTITY_LILITH_AMBIENT;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return WitcherySounds.ENTITY_LILITH_HURT;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return this.isFriendly() ? WitcherySounds.ENTITY_LILITH_HURT : WitcherySounds.ENTITY_LILITH_DEATH;
    }

    public void onDeath(@NotNull DamageSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (!this.world.isRemote) {
            this.isDead = false;
            this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
            this.world.setEntityState((Entity)this, (byte)5);
            this.setHealth(this.getMaxHealth());
            this.setFriendly(true);
            this.setAttackTarget(null);
            Iterator iterator = this.getActivePotionEffects().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"iterator.next()");
                if (!WitcheryPotion.isCurable(((PotionEffect)e).getPotion())) continue;
                iterator.remove();
            }
            EntityPlayer player = this.getSummoner();
            if (player != null) {
                this.setPositionAndUpdate(player.posX - 1.0 + this.rand.nextDouble() * 2.0, player.posY + 0.05, player.posZ - 1.0 + this.rand.nextDouble() * 2.0);
                this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                this.world.setEntityState((Entity)this, (byte)5);
                player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                this.playSound(WitcherySounds.ENTITY_LILITH_AMBIENT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
            } else {
                this.setDead();
            }
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    protected boolean processInteract(@NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        if (!this.world.isRemote && hand == EnumHand.MAIN_HAND && this.isFriendly()) {
            ItemStack stack = player.getHeldItem(hand);
            this.playSound(WitcherySounds.ENTITY_LILITH_AMBIENT, 1.0f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
            boolean vanish = false;
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (itemStack.isEmpty()) {
                player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.complete2", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
            } else {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                if (stack.getItem() instanceof ItemGlassGoblet) {
                    if (transformation.getLevel() == 0) {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.vampire_success", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                        player.setHeldItem(hand, ItemStack.EMPTY);
                        this.world.playSound(null, player.posX, player.posY + (double)player.height * 0.85, player.posZ, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, player.getSoundCategory(), 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)6);
                        Item item = stack.getItem();
                        if (item == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.ItemGlassGoblet");
                        }
                        this.world.spawnEntity((Entity)new EntityItem(this.world, player.posX, player.posY, player.posZ, ((ItemGlassGoblet)item).getNewGoblet(stack, (Entity)this)));
                        playerEx.setHumanBlood(0);
                        vanish = true;
                    } else {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.already_vampire", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                    }
                } else if (stack.getItem() == Item.getItemFromBlock((Block)((Block)WitcheryBlocks.GARLIC))) {
                    if (transformation.getLevel() > 0) {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.vampire_cured", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                        player.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        transformation.setLevel(0);
                        playerEx.sync();
                        player.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)7);
                        World world = this.world;
                        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                        WitcheryUtils.addNewParticles$default(world, EnumParticleTypes.REDSTONE, player.posX, player.posY, player.posZ, 0.0, 0, 1.0, 1.5, 48, null);
                        vanish = true;
                    } else {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.already_human", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                    }
                } else if (stack.getItem() == Item.getItemFromBlock((Block)((Block)Blocks.RED_FLOWER)) && stack.getItemDamage() == 0) {
                    if (transformation.getLevel() == 6 && transformation.getCanLevelUp()) {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.can_fly", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                        player.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ItemStack.EMPTY);
                        if (transformation.levelUp()) {
                            playerEx.sync();
                        }
                        this.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                        this.world.setEntityState((Entity)this, (byte)7);
                        vanish = true;
                    } else {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.cannot_fly", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                    }
                } else {
                    List enchants = EnchantmentHelper.buildEnchantmentList((Random)this.rand, (ItemStack)stack, (int)40, (boolean)false);
                    if (enchants.size() > 0) {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.item_enchanted", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                        List list2 = enchants;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"enchants");
                        stack = EntityLilith.Companion.addEnchantmentsFromList(stack, list2);
                        if (stack.isItemStackDamageable()) {
                            stack.setItemDamage(0);
                        }
                        player.setHeldItem(hand, stack);
                        vanish = true;
                    } else {
                        player.sendMessage(new TextComponentTranslation("entity.witchery.lilith.quest.complete2", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                    }
                }
            }
            if (vanish) {
                this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                this.world.setEntityState((Entity)this, (byte)5);
                this.setDead();
            }
            return true;
        }
        return false;
    }

    public void attackEntityWithRangedAttack(@NotNull EntityLivingBase target, float distanceFactor) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (this.world.rand.nextBoolean()) {
            this.attackTimer = 10;
            this.world.setEntityState((Entity)this, (byte)4);
            double d0 = target.posX - this.posX;
            double d2 = target.getEntityBoundingBox().minY + (double)(target.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d3 = target.posZ - this.posZ;
            float f1 = MathHelper.sqrt((float)distanceFactor) * 0.5f;
            if (!this.world.isRemote) {
                if (this.world.rand.nextInt(3) == 0) {
                    EntityLargeFireball fireballEntity = new EntityLargeFireball(this.world, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d2, d3 + this.rand.nextGaussian() * (double)f1);
                    double d4 = 1.0;
                    Vec3d vec3 = this.getLook(1.0f);
                    fireballEntity.posX = this.posX + vec3.x * d4;
                    fireballEntity.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                    fireballEntity.posZ = this.posZ + vec3.z * d4;
                    if (!this.world.isRemote) {
                        this.world.playEvent(1009, this.getPosition(), 0);
                        this.world.spawnEntity((Entity)fireballEntity);
                    }
                } else {
                    this.world.playEvent(1009, this.getPosition(), 0);
                    EntityLivingBase entityLivingBase = (EntityLivingBase)this;
                    double d = d0 + this.rand.nextGaussian() * (double)f1;
                    double d4 = d3 + this.rand.nextGaussian() * (double)f1;
                    Random random = this.rand;
                    Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"rand");
                    EntitySpellEffect effect = new EntitySpellEffect(this.world, entityLivingBase, d, d2, d4, WeightedElementKt.getWeighted(SPELLS, random), 1);
                    effect.posX = this.posX;
                    effect.posY = this.posY + (double)(this.height / 2.0f);
                    effect.posZ = this.posZ;
                    this.world.spawnEntity((Entity)effect);
                }
            }
        }
    }

    public void setSwingingArms(boolean swingingArms) {
    }

    public EntityLilith(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.bossInfo = new BossInfoServer(this.getDisplayName(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);
        DataParameter<Boolean> dataParameter = FRIENDLY;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"FRIENDLY");
        this.isFriendly$delegate = new DataDelegate<Boolean>(dataParameter);
        DataParameter<Optional<UUID>> dataParameter2 = SUMMONER;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter2, (String)"SUMMONER");
        this.summonerId$delegate = new OptionalDataDelegate<UUID>(dataParameter2);
        this.isImmuneToFire = true;
        this.experienceValue = 60;
    }

    @NotNull
    public static final List<WeightedElement<ProjectileSymbolEffect>> getSPELLS() {
        Companion companion = Companion;
        return SPELLS;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rRj\u0010\u000e\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000f0\u000f \u0006*.\u0012(\u0012&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000f0\u000f\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityLilith$Companion;", "", "()V", "FRIENDLY", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "SPELLS", "", "Lnet/msrandom/witchery/util/WeightedElement;", "Lnet/msrandom/witchery/infusion/symbol/ProjectileSymbolEffect;", "SPELLS$annotations", "getSPELLS", "()Ljava/util/List;", "SUMMONER", "Lcom/google/common/base/Optional;", "Ljava/util/UUID;", "addEnchantmentsFromList", "Lnet/minecraft/item/ItemStack;", "stack", "list", "Lnet/minecraft/enchantment/EnchantmentData;", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void SPELLS$annotations() {
        }

        @NotNull
        public final List<WeightedElement<ProjectileSymbolEffect>> getSPELLS() {
            return SPELLS;
        }

        /*
         * WARNING - void declaration
         */
        private final ItemStack addEnchantmentsFromList(ItemStack stack, List<? extends EnchantmentData> list2) {
            boolean flag = stack.getItem() == Items.BOOK;
            ItemStack newStack = flag ? new ItemStack(Items.ENCHANTED_BOOK) : stack;
            for (EnchantmentData enchantmentData : list2) {
                if (flag) {
                    ItemEnchantedBook.addEnchantment((ItemStack)newStack, (EnchantmentData)enchantmentData);
                    continue;
                }
                NBTTagCompound tag = WitcheryUtils.getOrCreateTag(newStack);
                NBTTagList enchantments = tag.getTagList("ench", 10);
                boolean addEnchant = true;
                int n = 0;
                int n2 = enchantments.tagCount();
                while (n < n2) {
                    void i;
                    NBTTagCompound enchantment = enchantments.getCompoundTagAt((int)i);
                    if (enchantment.getShort("id") == (short)Enchantment.getEnchantmentID((Enchantment)enchantmentData.enchantment)) {
                        if (enchantment.getShort("lvl") < enchantmentData.enchantmentLevel) {
                            enchantment.setShort("lvl", (short)enchantmentData.enchantmentLevel);
                        }
                        addEnchant = false;
                        break;
                    }
                    ++i;
                }
                if (addEnchant) {
                    NBTTagCompound newEnchantment = new NBTTagCompound();
                    newEnchantment.setShort("id", (short)Enchantment.getEnchantmentID((Enchantment)enchantmentData.enchantment));
                    newEnchantment.setShort("lvl", (short)enchantmentData.enchantmentLevel);
                    enchantments.appendTag((NBTBase)newEnchantment);
                }
                tag.setTag("ench", (NBTBase)enchantments);
            }
            return newStack;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

