/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.monster;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.item.EntityHuntsmansSpear;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.DataDelegate;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 Z2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001ZB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0014J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020*H\u0016J\b\u0010/\u001a\u00020\u0013H\u0014J\u0006\u00100\u001a\u00020\u001fJ\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0014J\b\u00103\u001a\u00020\u001fH\u0014J\n\u00104\u001a\u0004\u0018\u000105H\u0014J\b\u00106\u001a\u00020*H\u0016J\n\u00107\u001a\u0004\u0018\u000105H\u0014J\u0012\u00108\u001a\u0004\u0018\u0001052\u0006\u0010'\u001a\u00020(H\u0014J\b\u00109\u001a\u00020\bH\u0016J\u0010\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020<H\u0017J\u0006\u0010=\u001a\u00020\u001fJ\b\u0010>\u001a\u00020\u001fH\u0014J\b\u0010?\u001a\u00020\u0013H\u0016J\u001c\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010AH\u0016J\b\u0010E\u001a\u00020\u001fH\u0016J\u0018\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0014J\u0010\u0010K\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010O\u001a\u00020\u001fH\u0016J\u0010\u0010P\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020\u0013H\u0016J \u0010R\u001a\u00020\u001f2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020T2\u0006\u0010V\u001a\u00020TH\u0002J\u0010\u0010W\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010X\u001a\u00020\u001fH\u0014J\u0010\u0010Y\u001a\u00020\u001f2\u0006\u0010L\u001a\u00020MH\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lnet/msrandom/witchery/entity/monster/EntityHornedHuntsman;", "Lnet/minecraft/entity/monster/EntityMob;", "Lnet/minecraft/entity/IRangedAttackMob;", "Lnet/msrandom/witchery/util/IHandleDeathTouch;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "<set-?>", "", "attackTimer", "getAttackTimer", "()I", "attackingPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "getAttackingPlayer", "()Lnet/minecraft/entity/player/EntityPlayer;", "bossInfo", "Lnet/minecraft/world/BossInfoServer;", "explosiveEntrance", "", "invulnerabilityTime", "getInvulnerabilityTime", "setInvulnerabilityTime", "(I)V", "invulnerabilityTime$delegate", "Lnet/msrandom/witchery/util/DataDelegate;", "isSwingingArms", "()Z", "ticksSinceTeleport", "", "addTrackingPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayerMP;", "applyEntityAttributes", "attackEntityAsMob", "entity", "Lnet/minecraft/entity/Entity;", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "amount", "", "attackEntityWithRangedAttack", "target", "Lnet/minecraft/entity/EntityLivingBase;", "distanceFactor", "canDespawn", "causeExplosiveEntrance", "decreaseAirSupply", "air", "entityInit", "getAmbientSound", "Lnet/minecraft/util/SoundEvent;", "getBrightness", "getDeathSound", "getHurtSound", "getTotalArmorValue", "handleStatusUpdate", "id", "", "ignite", "initEntityAI", "isNonBoss", "onInitialSpawn", "Lnet/minecraft/entity/IEntityLivingData;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "livingdata", "onLivingUpdate", "playStepSound", "pos", "Lnet/minecraft/util/math/BlockPos;", "block", "Lnet/minecraft/block/Block;", "readEntityFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "removeTrackingPlayer", "setInWeb", "setSwingingArms", "swingingArms", "teleportTo", "x", "", "y", "z", "teleportToEntity", "updateAITasks", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityHornedHuntsman
extends EntityMob
implements IRangedAttackMob,
IHandleDeathTouch {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final BossInfoServer bossInfo;
    private long ticksSinceTeleport;
    private int attackTimer;
    private boolean explosiveEntrance;
    private final DataDelegate invulnerabilityTime$delegate;
    private static final DataParameter<Integer> INVULNERABILITY_TIME;
    private static final DataParameter<Boolean> SWINGING_ARMS;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityHornedHuntsman.class), "invulnerabilityTime", "getInvulnerabilityTime()I"))};
        Companion = new Companion(null);
        INVULNERABILITY_TIME = EntityDataManager.createKey(EntityHornedHuntsman.class, (DataSerializer)DataSerializers.VARINT);
        SWINGING_ARMS = EntityDataManager.createKey(EntityHornedHuntsman.class, (DataSerializer)DataSerializers.BOOLEAN);
    }

    public final int getAttackTimer() {
        return this.attackTimer;
    }

    public final boolean isSwingingArms() {
        Object object = this.dataManager.get(SWINGING_ARMS);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager.get(SWINGING_ARMS)");
        return (Boolean)object;
    }

    @Nullable
    public final EntityPlayer getAttackingPlayer() {
        return this.attackingPlayer;
    }

    private final int getInvulnerabilityTime() {
        return ((Number)this.invulnerabilityTime$delegate.getValue((Entity)this, $$delegatedProperties[0])).intValue();
    }

    private final void setInvulnerabilityTime(int n) {
        this.invulnerabilityTime$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[0], n);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(INVULNERABILITY_TIME, (Object)0);
        this.dataManager.register(SWINGING_ARMS, (Object)false);
    }

    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 48.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance.setBaseValue(400.0);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance2.setBaseValue(0.35);
        IAttributeInstance iAttributeInstance3 = this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance3, (String)"getEntityAttribute(Share\u2026rAttributes.FOLLOW_RANGE)");
        iAttributeInstance3.setBaseValue(50.0);
        IAttributeInstance iAttributeInstance4 = this.getEntityAttribute(SharedMonsterAttributes.KNOCKBACK_RESISTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance4, (String)"getEntityAttribute(Share\u2026tes.KNOCKBACK_RESISTANCE)");
        iAttributeInstance4.setBaseValue(1.0);
    }

    public void addTrackingPlayer(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(@NotNull EntityPlayerMP player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public final void causeExplosiveEntrance() {
        this.explosiveEntrance = true;
    }

    public int getTotalArmorValue() {
        return 4;
    }

    public void setInWeb() {
    }

    public final void ignite() {
        this.setInvulnerabilityTime(150);
        this.setHealth(this.getMaxHealth() / 4.0f);
    }

    protected void updateAITasks() {
        EntityLivingBase target = this.getAttackTarget();
        this.setSwingingArms(target != null);
        if (this.getInvulnerabilityTime() > 0) {
            int i = this.getInvulnerabilityTime() - 1;
            if (i <= 0) {
                if (this.explosiveEntrance) {
                    Entity entity = (Entity)this;
                    double d = this.posY + (double)this.getEyeHeight();
                    World world = this.world;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                    this.world.newExplosion(entity, this.posX, d, this.posZ, 6.0f, false, world.getGameRules().getBoolean("mobGriefing"));
                }
                this.world.playBroadcastSound(1013, this.getPosition(), 0);
            }
            this.setInvulnerabilityTime(i);
            if (this.ticksExisted % 10 == 0) {
                this.heal(20.0f);
            }
        } else {
            super.updateAITasks();
            if (this.ticksExisted % 20 == 0) {
                this.heal(1.0f);
            }
            if (!this.world.isRemote && target != null) {
                if (this.ticksExisted % 20 == 0 && this.world.rand.nextInt(5) == 0 && this.getEntitySenses().canSee((Entity)target)) {
                    double distance = this.getDistanceSq(target.posX, target.getEntityBoundingBox().minY, target.posZ);
                    this.getLookHelper().setLookPositionWithEntity((Entity)target, 30.0f, 30.0f);
                    this.attackTimer = 10;
                    this.world.setEntityState((Entity)this, (byte)4);
                    this.setHeldItem(EnumHand.MAIN_HAND, ItemStack.EMPTY);
                    EntityLivingBase entityLivingBase = this.getAttackTarget();
                    if (entityLivingBase == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"attackTarget!!");
                    this.attackEntityWithRangedAttack(entityLivingBase, MathHelper.sqrt((double)distance) / 30.0f);
                }
                if (this.ticksExisted % (200 + this.world.rand.nextInt(4) * 100) == 0 && this.getDistanceSq((Entity)target) <= 256.0 && this.getEntitySenses().canSee((Entity)target)) {
                    EntityWolf wolf = new EntityWolf(this.world);
                    wolf.setLocationAndAngles(this.posX - 0.5 + this.world.rand.nextDouble(), this.posY, this.posZ - 0.5 + this.rand.nextDouble(), this.rotationYawHead, this.rotationPitch);
                    wolf.setAngry(true);
                    wolf.setAttackTarget(target);
                    wolf.addPotionEffect(new PotionEffect(MobEffects.RESISTANCE, 20000, 1));
                    wolf.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.spawnEntity((Entity)wolf);
                }
                if (this.getNavigator().noPath() && (long)this.ticksExisted - this.ticksSinceTeleport > 200L) {
                    this.ticksSinceTeleport = this.ticksExisted;
                    this.teleportToEntity((Entity)target);
                }
            }
        }
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    @Nullable
    public IEntityLivingData onInitialSpawn(@NotNull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Intrinsics.checkParameterIsNotNull((Object)difficulty, (String)"difficulty");
        IEntityLivingData newData = super.onInitialSpawn(difficulty, livingdata);
        this.setHeldItem(EnumHand.MAIN_HAND, new ItemStack((Item)WitcheryGeneralItems.HUNTSMANS_SPEAR));
        return newData;
    }

    private final void teleportToEntity(Entity entity) {
        Vec3d vec3d = new Vec3d(this.posX - entity.posX, this.getEntityBoundingBox().minY + (double)this.height / 2.0 - entity.posY + (double)entity.getEyeHeight(), this.posZ - entity.posZ).normalize();
        double distance = 16.0;
        double x = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3d.x * distance;
        double y = this.posY + (double)this.rand.nextInt(16) - 8.0 - vec3d.y * distance;
        double z = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3d.z * distance;
        this.teleportTo(x, y, z);
    }

    private final void teleportTo(double x, double y, double z) {
        if (this.attemptTeleport(x, y, z)) {
            this.world.playSound(null, this.prevPosX, this.prevPosY, this.prevPosZ, SoundEvents.ENTITY_ENDERMEN_TELEPORT, this.getSoundCategory(), 1.0f, 1.0f);
            this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 1.0f, 1.0f);
        }
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            EntityHornedHuntsman entityHornedHuntsman = this;
            entityHornedHuntsman.attackTimer += -1;
            int cfr_ignored_0 = entityHornedHuntsman.attackTimer;
        }
    }

    public boolean attackEntityFrom(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return WitcheryUtils.isInstantKill((EntityLivingBase)this, source, amount) ? super.attackEntityFrom(source, amount) : super.attackEntityFrom(source, RangesKt.coerceAtMost((float)amount, (float)15.0f));
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.writeEntityToNBT(tag);
        tag.setInteger("InvulnerabilityTime", this.getInvulnerabilityTime());
        tag.setBoolean("ExplosiveEntrance", this.explosiveEntrance);
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.readEntityFromNBT(tag);
        this.setInvulnerabilityTime(tag.getInteger("InvulnerabilityTime"));
        this.explosiveEntrance = tag.getBoolean("ExplosiveEntrance");
    }

    public boolean attackEntityAsMob(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        this.attackTimer = 10;
        this.world.setEntityState((Entity)this, (byte)4);
        boolean flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)((EntityLivingBase)this)), (float)(7 + this.rand.nextInt(15)));
        if (flag) {
            entity.motionY += 0.4;
        }
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 4: {
                this.attackTimer = 10;
                this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f);
                break;
            }
            case 5: {
                int n = 40;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, this.posX + this.rand.nextDouble() * (double)4 - (double)2, this.posY + this.rand.nextDouble() * (double)2, this.posZ + this.rand.nextDouble() * (double)4 - (double)2, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            case 6: {
                int n = 40;
                boolean bl = false;
                int n4 = 0;
                n4 = 0;
                int n5 = n;
                while (n4 < n5) {
                    int it = n4++;
                    boolean bl3 = false;
                    this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * (double)4 - (double)2, this.posY + this.rand.nextDouble() * (double)2, this.posZ + this.rand.nextDouble() * (double)4 - (double)2, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.handleStatusUpdate(id);
            }
        }
    }

    public float getBrightness() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_ENDERDRAGON_GROWL;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return SoundEvents.ENTITY_ZOMBIE_HORSE_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WITHER_DEATH;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_STEP, 1.0f, 1.0f);
    }

    protected boolean canDespawn() {
        return false;
    }

    public void attackEntityWithRangedAttack(@NotNull EntityLivingBase target, float distanceFactor) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        World world = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        EntityHuntsmansSpear spear = new EntityHuntsmansSpear(world, (EntityLivingBase)this);
        double x = target.posX - this.posX;
        double y = target.getEntityBoundingBox().minY - spear.posY + (double)target.height / 3.0;
        double z = target.posZ - this.posZ;
        double d = x * x + z * z;
        boolean bl = false;
        double distance = Math.sqrt(d);
        float f = 14;
        World world2 = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
        EnumDifficulty enumDifficulty = world2.getDifficulty();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDifficulty, (String)"world.difficulty");
        spear.shoot(x, y + distance * 0.2, z, 1.6f, f - (float)enumDifficulty.getId() * 4.0f);
        double d2 = (double)(distanceFactor * 8.0f) + this.rand.nextGaussian() * (double)0.25f;
        World world3 = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"world");
        EnumDifficulty enumDifficulty2 = world3.getDifficulty();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDifficulty2, (String)"world.difficulty");
        spear.setDamage(d2 + (double)((float)enumDifficulty2.getId() * 0.11f));
        spear.setKnockbackStrength(2);
        this.playSound(SoundEvents.ENTITY_IRONGOLEM_ATTACK, 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
        this.world.spawnEntity((Entity)spear);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.dataManager.set(SWINGING_ARMS, (Object)swingingArms);
    }

    public EntityHornedHuntsman(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        BossInfo bossInfo = new BossInfoServer(this.getDisplayName(), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_6).setDarkenSky(true);
        if (bossInfo == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.BossInfoServer");
        }
        this.bossInfo = (BossInfoServer)bossInfo;
        DataParameter<Integer> dataParameter = INVULNERABILITY_TIME;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"INVULNERABILITY_TIME");
        this.invulnerabilityTime$delegate = new DataDelegate<Integer>(dataParameter);
        this.isImmuneToFire = true;
        PathNavigate pathNavigate = this.getNavigator();
        if (pathNavigate == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.pathfinding.PathNavigateGround");
        }
        ((PathNavigateGround)pathNavigate).setCanSwim(true);
        this.experienceValue = 70;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityHornedHuntsman$Companion;", "", "()V", "INVULNERABILITY_TIME", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "SWINGING_ARMS", "", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

