/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.monster;

import com.google.common.base.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.monster.EntityHellhound;
import net.msrandom.witchery.entity.passive.EntityElle;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 C2\u00020\u0001:\u0001CB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0014J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0014J\n\u0010 \u001a\u0004\u0018\u00010!H\u0014J\b\u0010\"\u001a\u00020\u000eH\u0016J\n\u0010#\u001a\u0004\u0018\u00010!H\u0014J\b\u0010$\u001a\u00020\u000bH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010&\u001a\u00020\u001bH\u0014J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0007J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0007J\b\u0010+\u001a\u00020\u000bH\u0014J\b\u0010,\u001a\u00020\u0006H\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0015H\u0014J\b\u00101\u001a\u00020\u0015H\u0016J\b\u00102\u001a\u00020\u0015H\u0016J\u0018\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0014J\u0018\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00152\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u0006H\u0002J\u0010\u0010B\u001a\u00020\u00152\u0006\u0010>\u001a\u00020?H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityHellhound;", "Lnet/minecraft/entity/monster/EntityMob;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "conversionTime", "", "conversionTimeBoost", "getConversionTimeBoost", "()I", "headRotationCourse", "", "headRotationCourseOld", "isConverting", "", "()Z", "isHellhoundWet", "isShaking", "prevShakeTime", "shakeTime", "applyEntityAttributes", "", "attackEntityAsMob", "entity", "Lnet/minecraft/entity/Entity;", "attackEntityFrom", "source", "Lnet/minecraft/util/DamageSource;", "amount", "canDespawn", "convertToWolf", "entityInit", "getAmbientSound", "Lnet/minecraft/util/SoundEvent;", "getCanSpawnHere", "getDeathSound", "getEyeHeight", "getHurtSound", "damageSourceIn", "getInterestedAngle", "partialTicks", "getShakeAngle", "offset", "getSoundVolume", "getTotalArmorValue", "handleStatusUpdate", "id", "", "initEntityAI", "onLivingUpdate", "onUpdate", "playStepSound", "pos", "Lnet/minecraft/util/math/BlockPos;", "block", "Lnet/minecraft/block/Block;", "processInteract", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "startConversion", "time", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityHellhound
extends EntityMob {
    private float headRotationCourse;
    private float headRotationCourseOld;
    private boolean isHellhoundWet;
    private boolean isShaking;
    private float shakeTime;
    private float prevShakeTime;
    private int conversionTime;
    private static final DataParameter<Boolean> CONVERTING;
    public static final Companion Companion;

    public final boolean isConverting() {
        Object object = this.dataManager.get(CONVERTING);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataManager[CONVERTING]");
        return (Boolean)object;
    }

    protected void initEntityAI() {
        super.initEntityAI();
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySheep.class, true));
        Predicate predicate2 = (Predicate)new Predicate<EntityLivingBase>(this){
            final /* synthetic */ EntityHellhound this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(@Nullable EntityLivingBase it) {
                EntityLivingBase entityLivingBase = it;
                if (entityLivingBase == null) return false;
                EntityLivingBase entityLivingBase2 = entityLivingBase;
                boolean bl = false;
                boolean bl2 = false;
                EntityLivingBase entity = entityLivingBase2;
                boolean bl3 = false;
                if (!(entity.getDistanceSq((Entity)this.this$0) < 25.0)) return false;
                return true;
            }
            {
                this.this$0 = entityHellhound;
            }
        };
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, predicate2));
        this.targetTasks.addTask(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityElle.class, 10, true, false, predicate2));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        IAttributeInstance iAttributeInstance = this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"getEntityAttribute(Share\u2026ttributes.MOVEMENT_SPEED)");
        iAttributeInstance.setBaseValue((double)0.3f);
        IAttributeInstance iAttributeInstance2 = this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance2, (String)"getEntityAttribute(Share\u2026terAttributes.MAX_HEALTH)");
        iAttributeInstance2.setBaseValue(20.0);
        IAttributeInstance iAttributeInstance3 = this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance3, (String)"getEntityAttribute(Share\u2026Attributes.ATTACK_DAMAGE)");
        iAttributeInstance3.setBaseValue(4.0);
    }

    public int getTotalArmorValue() {
        int i = super.getTotalArmorValue() + 2;
        if (i > 20) {
            i = 20;
        }
        return i;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(CONVERTING, (Object)false);
    }

    private final void convertToWolf() {
        EntityWolf wolf = new EntityWolf(this.world);
        wolf.copyLocationAndAnglesFrom((Entity)this);
        wolf.onInitialSpawn(this.world.getDifficultyForLocation(wolf.getPosition()), null);
        this.world.removeEntity((Entity)this);
        this.world.spawnEntity((Entity)wolf);
        wolf.addPotionEffect(new PotionEffect(MobEffects.NAUSEA, 200, 0));
        this.world.playEvent(1017, this.getPosition(), 0);
    }

    public boolean processInteract(@NotNull EntityPlayer player, @NotNull EnumHand hand) {
        ItemStack stack;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        ItemStack itemStack = stack = player.getHeldItem(hand);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        if (!itemStack.isEmpty() && stack.getItem() == Items.GOLDEN_APPLE && stack.getItemDamage() == 0 && this.isPotionActive(MobEffects.WEAKNESS)) {
            if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            if (!this.world.isRemote) {
                this.startConversion(this.rand.nextInt(1000) + 3600);
            }
            return true;
        }
        return false;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        this.playSound(SoundEvents.ENTITY_WOLF_STEP, 0.15f, 1.0f);
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.writeEntityToNBT(compound);
        compound.setInteger("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.readEntityFromNBT(compound);
        if (compound.getInteger("ConversionTime") != -1) {
            this.startConversion(compound.getInteger("ConversionTime"));
        }
    }

    private final void startConversion(int time) {
        this.conversionTime = time;
        this.dataManager.set(CONVERTING, (Object)true);
        this.removePotionEffect(MobEffects.WEAKNESS);
        World world = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        EnumDifficulty enumDifficulty = world.getDifficulty();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDifficulty, (String)"world.difficulty");
        this.addPotionEffect(new PotionEffect(MobEffects.STRENGTH, time, RangesKt.coerceAtMost((int)(enumDifficulty.getId() - 1), (int)0)));
    }

    private final int getConversionTimeBoost() {
        int i = 1;
        if (this.rand.nextFloat() < 0.01f) {
            BlockPos blockPos = this.getPosition();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"position");
            BlockPos p = blockPos;
            for (BlockPos pos : WitcheryUtils.rangeTo(WitcheryUtils.minus(p, 4), WitcheryUtils.plus(p, 4))) {
                IBlockState iBlockState = this.world.getBlockState(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
                Block block = iBlockState.getBlock();
                if (block != Blocks.IRON_BARS && block != Blocks.BED || !(this.rand.nextFloat() < 0.3f)) continue;
                ++i;
            }
        }
        return i;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.ENTITY_WOLF_GROWL;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        Intrinsics.checkParameterIsNotNull((Object)damageSourceIn, (String)"damageSourceIn");
        return SoundEvents.ENTITY_WOLF_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_WOLF_DEATH;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.world.isRemote && !this.isDead && this.isHellhoundWet && !this.isShaking && !this.hasPath() && this.onGround) {
            this.isShaking = true;
            this.shakeTime = 0.0f;
            this.prevShakeTime = 0.0f;
            this.world.setEntityState((Entity)this, (byte)8);
        }
    }

    public void onUpdate() {
        if (!this.world.isRemote && this.isConverting()) {
            int i = this.getConversionTimeBoost();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.convertToWolf();
            }
        }
        super.onUpdate();
        if (!this.isDead) {
            this.headRotationCourseOld = this.headRotationCourse;
            this.headRotationCourse += this.headRotationCourse * -0.4f;
            if (this.isWet()) {
                this.isHellhoundWet = true;
                this.isShaking = false;
                this.shakeTime = 0.0f;
                this.prevShakeTime = 0.0f;
            } else if ((this.isHellhoundWet || this.isShaking) && this.isShaking) {
                if (this.shakeTime == 0.0f) {
                    this.playSound(SoundEvents.ENTITY_WOLF_SHAKE, this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                }
                this.prevShakeTime = this.shakeTime;
                this.shakeTime += 0.05f;
                if (this.prevShakeTime >= 2.0f) {
                    this.isHellhoundWet = false;
                    this.isShaking = false;
                    this.prevShakeTime = 0.0f;
                    this.shakeTime = 0.0f;
                }
                if (this.shakeTime > 0.4f) {
                    float f = (float)this.getEntityBoundingBox().minY;
                    int j = (int)(MathHelper.sin((float)((this.shakeTime - 0.4f) * (float)Math.PI)) * 7.0f);
                    for (int k = 0; k < j; ++k) {
                        float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                        float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                        this.world.spawnParticle(EnumParticleTypes.WATER_SPLASH, this.posX + (double)f2, (double)f + 0.8, this.posZ + (double)f3, this.motionX, this.motionY, this.motionZ, new int[0]);
                    }
                }
            }
            if (this.world.isRemote && this.ticksExisted % 2 == 0) {
                this.world.spawnParticle(EnumParticleTypes.FLAME, this.posX - (double)this.width * 0.35 + this.world.rand.nextDouble() * (double)this.width * 0.7, 0.5 + this.posY + this.world.rand.nextDouble() * ((double)this.height - 0.1), this.posZ - (double)this.width * 0.35 + this.world.rand.nextDouble() * (double)this.width * 0.7, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final float getShakeAngle(float partialTicks, float offset) {
        float f2 = (this.prevShakeTime + (this.shakeTime - this.prevShakeTime) * partialTicks + offset) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.sin((float)(f2 * (float)Math.PI)) * MathHelper.sin((float)(f2 * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public final float getInterestedAngle(float partialTicks) {
        return (this.headRotationCourseOld + (this.headRotationCourse - this.headRotationCourseOld) * partialTicks) * 0.15f * (float)Math.PI;
    }

    public boolean attackEntityFrom(@NotNull DamageSource source, float amount) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        float initial = amount;
        if (this.isEntityInvulnerable(source)) {
            return false;
        }
        Entity entity = source.getTrueSource();
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            initial = (initial + 1.0f) / 2.0f;
        }
        return super.attackEntityFrom(source, initial);
    }

    public boolean attackEntityAsMob(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        boolean flag = super.attackEntityAsMob(entity);
        if (flag) {
            World world = this.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            EnumDifficulty enumDifficulty = world.getDifficulty();
            Intrinsics.checkExpressionValueIsNotNull((Object)enumDifficulty, (String)"world.difficulty");
            int i = enumDifficulty.getId();
            if (this.rand.nextFloat() < (float)i * 0.1f) {
                entity.setFire(2 * i);
            }
        }
        return flag;
    }

    public void handleStatusUpdate(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.shakeTime = 0.0f;
            this.prevShakeTime = 0.0f;
        } else {
            super.handleStatusUpdate(id);
        }
    }

    protected boolean canDespawn() {
        return !this.isConverting();
    }

    public boolean getCanSpawnHere() {
        World world = this.world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        return world.getDifficulty() != EnumDifficulty.PEACEFUL && this.world.checkNoEntityCollision(this.getEntityBoundingBox()) && this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox());
    }

    public EntityHellhound(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.isImmuneToFire = true;
    }

    static {
        Companion = new Companion(null);
        CONVERTING = EntityDataManager.createKey(EntityHellhound.class, (DataSerializer)DataSerializers.BOOLEAN);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R:\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityHellhound$Companion;", "", "()V", "CONVERTING", "Lnet/minecraft/network/datasync/DataParameter;", "", "kotlin.jvm.PlatformType", "CONVERTING$annotations", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void CONVERTING$annotations() {
        }

        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().creature(EnumCreatureType.MONSTER).size(0.9f, 0.9f).egg(14181632, 5968392).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

