/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.monster;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.monster.EntityAttackBat;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\tH\u0014J\b\u0010\r\u001a\u00020\tH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0007J\b\u0010 \u001a\u00020\tH\u0014J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityAttackBat;", "Lnet/minecraft/entity/passive/EntityBat;", "Lnet/minecraft/entity/IEntityOwnable;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "ownerEntity", "Lnet/minecraft/entity/player/EntityPlayer;", "collideWithEntity", "", "entity", "Lnet/minecraft/entity/Entity;", "collideWithNearbyEntities", "entityInit", "getOwner", "getOwnerId", "Ljava/util/UUID;", "handleStatusUpdate", "id", "", "isCourseTraversable", "", "x", "", "y", "z", "motion", "readFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "setOwner", "player", "updateAITasks", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityAttackBat
extends EntityBat
implements IEntityOwnable {
    private EntityPlayer ownerEntity;
    private static final DataParameter<Optional<UUID>> OWNER;
    public static final Companion Companion;

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(OWNER, (Object)Optional.absent());
    }

    protected void collideWithNearbyEntities() {
        List list2 = this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.getEntityBoundingBox().expand(0.2, 0.0, 0.2));
        for (Entity entity : list2) {
            if (!entity.canBePushed()) continue;
            Entity entity2 = entity;
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"entity");
            this.collideWithEntity(entity2);
        }
    }

    protected void collideWithEntity(@NotNull Entity entity) {
        EntityPlayer owner;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!this.world.isRemote && entity instanceof EntityLivingBase && (owner = this.getOwner()) != null && entity != owner && !(entity instanceof EntityBat) && !entity.isDead) {
            entity.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)((Entity)this), (Entity)((Entity)owner)), 4.0f);
            this.world.setEntityState((Entity)this, (byte)6);
            this.playSound(WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
            this.setDead();
        }
    }

    protected void updateAITasks() {
        if (!this.world.isRemote) {
            if (this.ticksExisted > 300) {
                this.world.setEntityState((Entity)this, (byte)5);
                this.setDead();
            } else {
                RayTraceResult result2;
                EntityPlayer owner = this.getOwner();
                if (owner != null && owner.dimension == this.dimension && (result2 = OtherwhereInfusion.raytraceEntities(this.world, owner, 32.0)) != null && result2.typeOfHit == RayTraceResult.Type.ENTITY && result2.entityHit instanceof EntityLivingBase && !(result2.entityHit instanceof EntityBat)) {
                    float yaw;
                    boolean bl;
                    double d;
                    double x = result2.entityHit.posX - this.posX;
                    double y = result2.entityHit.posY - this.posY;
                    double z = result2.entityHit.posZ - this.posZ;
                    double d2 = x * x + y * y + z * z;
                    boolean bl2 = false;
                    double motion = Math.sqrt(d2);
                    boolean done = false;
                    if (this.isCourseTraversable(result2.entityHit.posX, result2.entityHit.posY, result2.entityHit.posZ, motion)) {
                        this.motionX += x / motion * 0.1;
                        this.motionY += y / motion * 0.1;
                        this.motionZ += z / motion * 0.1;
                        double d3 = this.motionZ;
                        d = this.motionX;
                        bl = false;
                        float f = (float)(Math.toDegrees(Math.atan2(d3, d)) - 1.5707963267948966);
                        float f2 = MathHelper.wrapDegrees((float)(f - this.rotationYaw));
                        this.moveForward = 0.5f;
                        this.rotationYaw += f2;
                        done = true;
                    }
                    double d4 = this.motionX;
                    d = this.motionZ;
                    bl = false;
                    this.rotationYaw = yaw = (float)Math.toDegrees(-Math.atan2(d4, d));
                    this.renderYawOffset = yaw;
                    if (done) {
                        return;
                    }
                }
            }
        }
        super.updateAITasks();
    }

    /*
     * WARNING - void declaration
     */
    public void handleStatusUpdate(byte id) {
        switch (id) {
            case 5: {
                int n = 0;
                int n2 = 19;
                while (n <= n2) {
                    void i;
                    this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX + this.rand.nextDouble() - 0.5, this.posY + this.rand.nextDouble() * 0.9, this.posZ + this.rand.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    ++i;
                }
                break;
            }
            case 6: {
                int n = 19;
                for (int i = 0; i <= n; ++i) {
                    this.world.spawnParticle(EnumParticleTypes.REDSTONE, this.posX + this.rand.nextDouble() - 0.5, this.posY + this.rand.nextDouble() * 0.9, this.posZ + this.rand.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                super.handleStatusUpdate(id);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCourseTraversable(double x, double y, double z, double motion) {
        double offsetX = (x - this.posX) / motion;
        double offsetY = (y - this.posY) / motion;
        double offsetZ = (z - this.posZ) / motion;
        int n = 1;
        int n2 = (int)motion;
        if (n <= n2) {
            while (true) {
                void i;
                List list2 = this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox().offset(offsetX, offsetY, offsetZ));
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"world.getCollisionBoxes(\u2026fsetX, offsetY, offsetZ))");
                Collection collection = list2;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return false;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return true;
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.dataManager.get(OWNER)).orNull();
    }

    @Nullable
    public EntityPlayer getOwner() {
        if (this.ownerEntity == null) {
            World world = this.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            this.ownerEntity = WitcheryUtils.getPlayer(world, this.getOwnerId());
        }
        return this.ownerEntity;
    }

    public final void setOwner(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.dataManager.set(OWNER, (Object)Optional.fromNullable((Object)player.getUniqueID()));
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
            super.writeEntityToNBT(compound);
            UUID uUID = this.getOwnerId();
            if (uUID == null) break block0;
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            compound.setUniqueId("Owner", it);
        }
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.readFromNBT(compound);
        if (compound.hasUniqueId("Owner")) {
            this.dataManager.set(OWNER, (Object)Optional.fromNullable((Object)compound.getUniqueId("Owner")));
        }
    }

    public EntityAttackBat(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
    }

    static {
        Companion = new Companion(null);
        OWNER = EntityDataManager.createKey(EntityAttackBat.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Rj\u0010\u0003\u001a^\u0012(\u0012&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005 \u0007*.\u0012(\u0012&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/msrandom/witchery/entity/monster/EntityAttackBat$Companion;", "", "()V", "OWNER", "Lnet/minecraft/network/datasync/DataParameter;", "Lcom/google/common/base/Optional;", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().creature(EnumCreatureType.MONSTER).size(0.5f, 0.9f).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

