/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.item;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.item.EntityCrossbowBolt;
import net.msrandom.witchery.init.WitcheryEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/msrandom/witchery/entity/item/EntityCrossbowBolt;", "Lnet/minecraft/entity/projectile/EntityArrow;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "shooter", "Lnet/minecraft/entity/EntityLivingBase;", "rapid", "", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;Z)V", "isPoweredDraining", "()Z", "setPoweredDraining", "(Z)V", "stack", "Lnet/minecraft/item/ItemStack;", "getArrowStack", "onHit", "", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "readEntityFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "setBolt", "item", "Lnet/minecraft/item/Item;", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityCrossbowBolt
extends EntityArrow {
    private boolean isPoweredDraining;
    private ItemStack stack;
    private boolean rapid;
    public static final Companion Companion = new Companion(null);

    public final boolean isPoweredDraining() {
        return this.isPoweredDraining;
    }

    public final void setPoweredDraining(boolean bl) {
        this.isPoweredDraining = bl;
    }

    public final void setBolt(@NotNull Item item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        this.stack = new ItemStack(item);
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.writeEntityToNBT(tag);
        tag.setBoolean("Rapid", this.rapid);
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.readEntityFromNBT(tag);
        this.rapid = tag.getBoolean("Rapid");
    }

    protected void onHit(@NotNull RayTraceResult hit) {
        Entity entity;
        Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
        if (!this.world.isRemote && !this.rapid && hit.typeOfHit == RayTraceResult.Type.ENTITY && (entity = hit.entityHit) instanceof EntityLivingBase) {
            float f = MathHelper.wrapDegrees((float)(entity.rotationYaw - this.rotationYaw));
            boolean bl = false;
            float angleDifference = Math.abs(f);
            if (angleDifference <= (float)90) {
                EntityCrossbowBolt entityCrossbowBolt = this;
                double d = 2.0 - (double)angleDifference / 90.0;
                double d2 = entityCrossbowBolt.getDamage();
                EntityCrossbowBolt entityCrossbowBolt2 = entityCrossbowBolt;
                boolean bl2 = false;
                double d3 = Math.ceil(d);
                entityCrossbowBolt2.setDamage(d2 * d3);
            }
        }
        super.onHit(hit);
    }

    @NotNull
    public ItemStack getArrowStack() {
        return this.stack;
    }

    public EntityCrossbowBolt(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        this.stack = itemStack;
    }

    public EntityCrossbowBolt(@NotNull World world, @NotNull EntityLivingBase shooter, boolean rapid) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)shooter, (String)"shooter");
        super(world, shooter);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        this.stack = itemStack;
        this.rapid = rapid;
    }

    @JvmStatic
    @Nullable
    public static final EntityCrossbowBolt getSourceBolt(@NotNull DamageSource source) {
        return Companion.getSourceBolt(source);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/witchery/entity/item/EntityCrossbowBolt$Companion;", "", "()V", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getSourceBolt", "Lnet/msrandom/witchery/entity/item/EntityCrossbowBolt;", "source", "Lnet/minecraft/util/DamageSource;", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final EntityCrossbowBolt getSourceBolt(@NotNull DamageSource source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Entity entity = source.getImmediateSource();
            if (!(entity instanceof EntityCrossbowBolt)) {
                entity = null;
            }
            return (EntityCrossbowBolt)entity;
        }

        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().size(0.5f, 0.5f).track(10, 64).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

