/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.item;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.entity.EntityBrewEffectCloud;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.init.data.brewing.WitcheryDispersals;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.DataDelegate;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016R+\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R+\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\t\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lnet/msrandom/witchery/entity/item/EntityBrew;", "Lnet/minecraft/entity/projectile/EntityThrowable;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/world/World;)V", "thrower", "Lnet/minecraft/entity/EntityLivingBase;", "brewStack", "Lnet/minecraft/item/ItemStack;", "isSpell", "", "(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;Z)V", "x", "", "y", "z", "(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;Z)V", "<set-?>", "brew", "getBrew", "()Lnet/minecraft/item/ItemStack;", "setBrew", "(Lnet/minecraft/item/ItemStack;)V", "brew$delegate", "Lnet/msrandom/witchery/util/DataDelegate;", "()Z", "setSpell", "(Z)V", "isSpell$delegate", "entityInit", "", "getGravityVelocity", "", "handleStatusUpdate", "id", "", "onImpact", "result", "Lnet/minecraft/util/math/RayTraceResult;", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityBrew
extends EntityThrowable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final DataDelegate brew$delegate;
    @NotNull
    private final DataDelegate isSpell$delegate;
    private static final DataParameter<Boolean> SPELL;
    private static final DataParameter<ItemStack> BREW;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityBrew.class), "brew", "getBrew()Lnet/minecraft/item/ItemStack;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(EntityBrew.class), "isSpell", "isSpell()Z"))};
        Companion = new Companion(null);
        SPELL = EntityDataManager.createKey(EntityBrew.class, (DataSerializer)DataSerializers.BOOLEAN);
        BREW = EntityDataManager.createKey(EntityBrew.class, (DataSerializer)DataSerializers.ITEM_STACK);
    }

    @NotNull
    public final ItemStack getBrew() {
        return (ItemStack)this.brew$delegate.getValue((Entity)this, $$delegatedProperties[0]);
    }

    public final void setBrew(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"<set-?>");
        this.brew$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[0], itemStack);
    }

    public final boolean isSpell() {
        return (Boolean)this.isSpell$delegate.getValue((Entity)this, $$delegatedProperties[1]);
    }

    public final void setSpell(boolean bl) {
        this.isSpell$delegate.setValue((Entity)this, (KProperty<?>)$$delegatedProperties[1], bl);
    }

    protected void entityInit() {
        this.dataManager.register(BREW, (Object)ItemStack.EMPTY);
        this.dataManager.register(SPELL, (Object)false);
        super.entityInit();
    }

    protected float getGravityVelocity() {
        return this.isSpell() ? 0.0f : 0.05f;
    }

    protected void onImpact(@NotNull RayTraceResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        if (!this.world.isRemote) {
            BrewActionList actionList = new BrewActionList(this.getBrew().getTagCompound());
            ModifiersImpact modifiers = new ModifiersImpact(this.getPositionVector(), false, 0, EntityUtil.playerOrFake(this.world, this.getThrower()));
            for (BrewAction action : actionList.actions) {
                World world = this.world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                action.prepareSplashPotion(world, actionList, modifiers);
            }
            if (Intrinsics.areEqual((Object)this.getBrew().getItem(), (Object)((Object)WitcheryGeneralItems.LINGERING_BREW_BOTTLE)) && Intrinsics.areEqual((Object)modifiers.getDispersal(), (Object)WitcheryDispersals.INSTANT)) {
                World world = this.world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                EntityBrewEffectCloud cloud = new EntityBrewEffectCloud(world, this.posX, this.posY, this.posZ, actionList, modifiers);
                cloud.setOwner(this.getThrower());
                cloud.setRadiusOnUse(-0.5f);
                cloud.setWaitTime(10);
                cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
                this.world.spawnEntity((Entity)cloud);
                this.world.setEntityState((Entity)this, (byte)6);
            } else if (WitcheryBrewEffects.impactSplashPotion(this.world, this.getBrew(), result2, modifiers)) {
                this.world.setEntityState((Entity)this, (byte)6);
            }
            this.setDead();
        }
    }

    public void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.readEntityFromNBT(compound);
        if (compound.hasKey("Brew", 10)) {
            this.setBrew(new ItemStack(compound.getCompoundTag("Brew")));
        }
        if (this.getBrew().isEmpty()) {
            this.setDead();
            return;
        }
        this.setSpell(compound.getBoolean("Spell"));
    }

    public void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.writeEntityToNBT(compound);
        if (this.getBrew().isEmpty()) {
            return;
        }
        compound.setTag("Brew", (NBTBase)this.getBrew().writeToNBT(new NBTTagCompound()));
        compound.setBoolean("Spell", this.isSpell());
    }

    /*
     * WARNING - void declaration
     */
    public void handleStatusUpdate(byte id) {
        if (id == 6) {
            ArrayList<ItemStack> arrayList = new BrewActionList((NBTTagCompound)this.getBrew().getTagCompound()).items;
            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"BrewActionList(brew.tagCompound).items");
            int color2 = WitcheryUtils.getBrewColor((Collection<ItemStack>)arrayList);
            int n = 0;
            int n2 = 7;
            while (n <= n2) {
                void i;
                this.world.spawnParticle(EnumParticleTypes.ITEM_CRACK, this.posX, this.posY, this.posZ, this.rand.nextGaussian() * 0.15, this.rand.nextDouble() * 0.2, this.rand.nextGaussian() * 0.15, new int[]{Item.getIdFromItem((Item)((Item)Items.SPLASH_POTION))});
                ++i;
            }
            float red = (float)(color2 >>> 16 & 0xFF) / 255.0f;
            float green = (float)(color2 >>> 8 & 0xFF) / 255.0f;
            float blue = (float)(color2 & 0xFF) / 255.0f;
            int n3 = 0;
            int n4 = 99;
            while (n3 <= n4) {
                void i;
                double distance = this.rand.nextDouble() * 4.0;
                double rotation = this.rand.nextDouble() * Math.PI * 2.0;
                boolean bl = false;
                double xSpeed = Math.cos(rotation) * distance;
                double ySpeed = this.rand.nextDouble() * 0.5 + 0.01;
                boolean bl2 = false;
                double zSpeed = Math.sin(rotation) * distance;
                Particle particle = Minecraft.getMinecraft().effectRenderer.spawnEffectParticle(EnumParticleTypes.SPELL.getParticleID(), this.posX + xSpeed * 0.1, this.posY + 0.3, this.posZ + zSpeed * 0.1, xSpeed, ySpeed, zSpeed, new int[0]);
                if (particle != null) {
                    float colorMultiplier = 0.75f + this.rand.nextFloat() * 0.25f;
                    particle.setRBGColorF(red * colorMultiplier, green * colorMultiplier, blue * colorMultiplier);
                    particle.multiplyVelocity((float)distance);
                }
                ++i;
            }
            this.world.playSound(this.posX, this.posY, this.posZ, SoundEvents.ENTITY_SPLASH_POTION_BREAK, SoundCategory.NEUTRAL, 1.0f, this.world.rand.nextFloat() * 0.1f + 0.9f, false);
        } else {
            super.handleStatusUpdate(id);
        }
    }

    public EntityBrew(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        DataParameter<ItemStack> dataParameter = BREW;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"BREW");
        this.brew$delegate = new DataDelegate<ItemStack>(dataParameter);
        DataParameter<Boolean> dataParameter2 = SPELL;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter2, (String)"SPELL");
        this.isSpell$delegate = new DataDelegate<Boolean>(dataParameter2);
    }

    public EntityBrew(@NotNull World world, @NotNull EntityLivingBase thrower, @NotNull ItemStack brewStack, boolean isSpell) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)thrower, (String)"thrower");
        Intrinsics.checkParameterIsNotNull((Object)brewStack, (String)"brewStack");
        super(world, thrower);
        DataParameter<ItemStack> dataParameter = BREW;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"BREW");
        this.brew$delegate = new DataDelegate<ItemStack>(dataParameter);
        DataParameter<Boolean> dataParameter2 = SPELL;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter2, (String)"SPELL");
        this.isSpell$delegate = new DataDelegate<Boolean>(dataParameter2);
        this.setBrew(brewStack);
        this.setSpell(isSpell);
    }

    public EntityBrew(@NotNull World world, double x, double y, double z, @NotNull ItemStack brewStack, boolean isSpell) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)brewStack, (String)"brewStack");
        super(world, x, y, z);
        DataParameter<ItemStack> dataParameter = BREW;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter, (String)"BREW");
        this.brew$delegate = new DataDelegate<ItemStack>(dataParameter);
        DataParameter<Boolean> dataParameter2 = SPELL;
        Intrinsics.checkExpressionValueIsNotNull(dataParameter2, (String)"SPELL");
        this.isSpell$delegate = new DataDelegate<Boolean>(dataParameter2);
        this.setBrew(brewStack);
        this.setSpell(isSpell);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/entity/item/EntityBrew$Companion;", "", "()V", "BREW", "Lnet/minecraft/network/datasync/DataParameter;", "Lnet/minecraft/item/ItemStack;", "kotlin.jvm.PlatformType", "SPELL", "", "properties", "Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "getProperties", "()Lnet/msrandom/witchery/init/WitcheryEntities$Properties;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final WitcheryEntities.Properties getProperties() {
            return new WitcheryEntities.Properties().size(0.25f, 0.25f).track(1, 64).render(properties.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

