/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.familiar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.entity.familiar.Familiar;
import net.msrandom.witchery.entity.familiar.FamiliarInstance;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.resources.FamiliarPowerManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u001e\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a\u0016\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0006\u001a\u0016\u0010$\u001a\u00020\r*\u0004\u0018\u00010\u00062\b\u0010%\u001a\u0004\u0018\u00010&\u001a(\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001b\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0002*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"%\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0003\"\b\b\u0000\u0010\u0014*\u00020\u000e*\u0002H\u00148G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"FAMILIAR_ENTITIES", "", "Ljava/util/UUID;", "Lnet/msrandom/witchery/entity/familiar/Familiar;", "activeFamiliarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "Lnet/minecraft/entity/player/EntityPlayer;", "getActiveFamiliarType", "(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "boundFamiliar", "getBoundFamiliar", "(Lnet/minecraft/entity/player/EntityPlayer;)Lnet/msrandom/witchery/entity/familiar/Familiar;", "canBeFamiliar", "", "Lnet/minecraft/entity/Entity;", "(Lnet/minecraft/entity/Entity;)Z", "familiarId", "getFamiliarId", "(Lnet/minecraft/entity/player/EntityPlayer;)Ljava/util/UUID;", "familiarInstance", "T", "getFamiliarInstance", "(Lnet/minecraft/entity/Entity;)Lnet/msrandom/witchery/entity/familiar/Familiar;", "familiarName", "", "getFamiliarName", "(Lnet/minecraft/entity/player/EntityPlayer;)Ljava/lang/String;", "getBoundFamiliarById", "player", "uuidFamiliar", "handleLivingDeath", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "handlePlayerHurt", "Lnet/minecraftforge/event/entity/living/LivingHurtEvent;", "hasFamiliarPower", "power", "Lnet/minecraft/util/ResourceLocation;", "summonFamiliar", "x", "", "y", "z", "WitcheryResurrected"})
@JvmName(name="Familiars")
public final class Familiars {
    private static final Map<UUID, Familiar<?>> FAMILIAR_ENTITIES;

    @JvmName(name="canBeFamiliar")
    public static final boolean canBeFamiliar(@NotNull Entity $this$canBeFamiliar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canBeFamiliar, (String)"$this$canBeFamiliar");
        return $this$canBeFamiliar instanceof Familiar && ((Familiar)$this$canBeFamiliar).getFamiliarType() != null || FamiliarType.REGISTRY.contains($this$canBeFamiliar.getClass());
    }

    @Contract(pure=false)
    @NotNull
    public static final <T extends Entity> Familiar<T> getFamiliarInstance(@NotNull T $this$familiarInstance) {
        Familiar<Object> familiar;
        Intrinsics.checkParameterIsNotNull($this$familiarInstance, (String)"$this$familiarInstance");
        Map<UUID, Familiar<?>> map = FAMILIAR_ENTITIES;
        UUID uUID = $this$familiarInstance.getUniqueID();
        boolean bl = false;
        Map<UUID, Familiar<?>> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(uUID)) {
            Familiar<?> familiar2 = FAMILIAR_ENTITIES.get($this$familiarInstance.getUniqueID());
            if (familiar2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.entity.familiar.Familiar<T>");
            }
            familiar = familiar2;
        } else if (Familiars.canBeFamiliar($this$familiarInstance)) {
            FamiliarType<Object> familiarType;
            if ($this$familiarInstance instanceof Familiar) {
                familiarType = ((Familiar)$this$familiarInstance).getFamiliarType();
                if (familiarType == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                FamiliarType<? extends Entity> familiarType2 = FamiliarType.REGISTRY.get($this$familiarInstance.getClass());
                if (familiarType2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.entity.familiar.FamiliarType<T>");
                }
                familiarType = familiarType2;
            }
            FamiliarType type = familiarType;
            Familiar result2 = null;
            if (Intrinsics.areEqual(FamiliarType.REGISTRY.getKey(type), $this$familiarInstance.getClass())) {
                result2 = type.create($this$familiarInstance);
                if (Intrinsics.areEqual($this$familiarInstance, result2.getEntity()) ^ true) {
                    $this$familiarInstance.setDead();
                    $this$familiarInstance.world.spawnEntity(result2.getEntity());
                }
            } else {
                result2 = (Familiar)$this$familiarInstance;
            }
            UUID uUID2 = $this$familiarInstance.getUniqueID();
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"uniqueID");
            FAMILIAR_ENTITIES.put(uUID2, result2);
            familiar = result2;
            if (familiar == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.entity.familiar.Familiar<T>");
            }
        } else {
            throw (Throwable)new IllegalArgumentException(EntityList.getKey($this$familiarInstance) + " can not be a familiar, please use the canBeFamiliar method to check before using this one");
        }
        return familiar;
    }

    @Nullable
    public static final Familiar<?> getBoundFamiliarById(@NotNull EntityPlayer player, @Nullable UUID uuidFamiliar) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (uuidFamiliar != null) {
            if (player.world.isRemote) {
                Object object;
                Object v2;
                block7: {
                    List list2 = player.world.loadedEntityList;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"player.world.loadedEntityList");
                    Iterable $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl = false;
                        Entity entity = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"it");
                        if (!Intrinsics.areEqual((Object)entity.getUniqueID(), (Object)uuidFamiliar)) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                if ((object = (Entity)v2) != null && (object = Familiars.getFamiliarInstance(object)) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    return it;
                }
            } else {
                MinecraftServer minecraftServer = player.getServer();
                if (minecraftServer != null) {
                    MinecraftServer minecraftServer2 = minecraftServer;
                    boolean bl = false;
                    boolean bl4 = false;
                    MinecraftServer server = minecraftServer2;
                    boolean bl5 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)server.worlds, (String)"server.worlds");
                    WorldServer[] $this$forEach$iv = server.worlds;
                    boolean $i$f$forEach = false;
                    WorldServer[] worldServerArray = $this$forEach$iv;
                    int n = worldServerArray.length;
                    for (int i = 0; i < n; ++i) {
                        WorldServer element$iv;
                        WorldServer world = element$iv = worldServerArray[i];
                        boolean bl6 = false;
                        Object object = world.getEntityFromUuid(uuidFamiliar);
                        if (object == null || (object = Familiars.getFamiliarInstance(object)) == null) continue;
                        Object object3 = object;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Object it = object3;
                        boolean bl9 = false;
                        return it;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Familiar<?> getBoundFamiliar(@NotNull EntityPlayer $this$boundFamiliar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$boundFamiliar, (String)"$this$boundFamiliar");
        return Familiars.getBoundFamiliarById($this$boundFamiliar, Familiars.getFamiliarId($this$boundFamiliar));
    }

    @Nullable
    public static final UUID getFamiliarId(@NotNull EntityPlayer $this$familiarId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$familiarId, (String)"$this$familiarId");
        FamiliarInstance familiarInstance = WitcheryUtils.getExtension((EntityPlayer)$this$familiarId).familiar;
        return familiarInstance != null && (familiarInstance = familiarInstance.getData()) != null ? familiarInstance.getUniqueId("UUID") : null;
    }

    public static final boolean hasFamiliarPower(@Nullable EntityPlayer $this$hasFamiliarPower, @Nullable ResourceLocation power) {
        Set<ResourceLocation> set2;
        if ($this$hasFamiliarPower == null) {
            return false;
        }
        if (power == null) {
            return true;
        }
        FamiliarType<?> familiarType = Familiars.getActiveFamiliarType($this$hasFamiliarPower);
        if (familiarType != null) {
            FamiliarType<?> familiarType2 = familiarType;
            boolean bl = false;
            boolean bl2 = false;
            FamiliarType<?> it = familiarType2;
            boolean bl3 = false;
            set2 = FamiliarPowerManager.INSTANCE.getPowers().get(it);
        } else {
            set2 = null;
        }
        Set<ResourceLocation> powers = set2;
        return powers != null && powers.contains(power);
    }

    @Nullable
    public static final FamiliarType<?> getActiveFamiliarType(@NotNull EntityPlayer $this$activeFamiliarType) {
        FamiliarType<?> familiarType;
        Intrinsics.checkParameterIsNotNull((Object)$this$activeFamiliarType, (String)"$this$activeFamiliarType");
        if (!$this$activeFamiliarType.world.isRemote) {
            FamiliarInstance familiarInstance = WitcheryUtils.getExtension((EntityPlayer)$this$activeFamiliarType).familiar;
            if (familiarInstance != null) {
                FamiliarInstance familiarInstance2 = familiarInstance;
                boolean bl = false;
                boolean bl2 = false;
                FamiliarInstance it = familiarInstance2;
                boolean bl3 = false;
                familiarType = it.isSummoned() ? it.getFamiliarType() : null;
            } else {
                familiarType = null;
            }
        } else {
            familiarType = null;
        }
        return familiarType;
    }

    public static final void handlePlayerHurt(@NotNull LivingHurtEvent event, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        World world = event.getEntityLiving().world;
        if (!world.isRemote && !event.isCanceled()) {
            float totalDamage = event.getAmount();
            float redirectedDamage = totalDamage * 0.01f;
            FamiliarInstance instance = WitcheryUtils.getExtension((EntityPlayer)player).familiar;
            if (instance != null) {
                Familiar<?> familiar = Familiars.getBoundFamiliarById(player, Familiars.getFamiliarId(player));
                if (familiar != null) {
                    Object entity = familiar.getEntity();
                    if (entity.getDistanceSq((Entity)player) <= (double)576.0f) {
                        redirectedDamage = totalDamage * 0.1f;
                    }
                    if (redirectedDamage >= 1.0f) {
                        entity.attackEntityFrom(event.getSource(), redirectedDamage);
                    }
                }
                event.setAmount(event.getAmount() - redirectedDamage);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void handleLivingDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        World world = event.getEntityLiving().world;
        if (world.isRemote) return;
        if (event.isCanceled()) return;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            Familiar<?> familiar;
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            if (entityLivingBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
            }
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            Familiar<?> familiar2 = familiar = Familiars.getBoundFamiliar(player);
            if (familiar2 == null) return;
            Familiar<?> familiar3 = familiar2;
            boolean bl = false;
            boolean bl2 = false;
            Familiar<?> it = familiar3;
            boolean bl3 = false;
            if (((Entity)it.getEntity()).isDead) return;
            Entity owner = it.getOwner();
            it.dismiss();
            World world2 = world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
            WitcheryUtils.addNewParticles$default(world2, EnumParticleTypes.SPELL_INSTANT, ((Entity)it.getEntity()).posX, ((Entity)it.getEntity()).posY, ((Entity)it.getEntity()).posZ, 0.0, 20, 0.0, 0.0, 192, null);
            if (!(owner instanceof EntityPlayer)) return;
            WitcheryUtils.getExtension((EntityPlayer)owner).sync();
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        Familiar<Entity> familiar = Familiars.getFamiliarInstance((Entity)entity);
        boolean bl = false;
        boolean bl4 = false;
        Familiar<Entity> it = familiar;
        boolean bl5 = false;
        if (!it.isFamiliar()) return;
        Entity owner = it.getOwner();
        if (owner instanceof EntityPlayer) {
            Entity entity2 = it.getEntity();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"it.entity");
            if (Intrinsics.areEqual((Object)((EntityLivingBase)entity2).getUniqueID(), (Object)Familiars.getFamiliarId((EntityPlayer)owner))) {
                owner.attackEntityFrom(DamageSource.MAGIC, ((EntityPlayer)owner).getMaxHealth() * 2.0f);
                it.dismiss();
                World world3 = world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world3, (String)"world");
                WitcheryUtils.addNewParticles$default(world3, EnumParticleTypes.SPELL_INSTANT, ((EntityLivingBase)it.getEntity()).posX, ((EntityLivingBase)it.getEntity()).posY, ((EntityLivingBase)it.getEntity()).posZ, 0.0, 20, 0.0, 0.0, 192, null);
                WitcheryUtils.getExtension((EntityPlayer)owner).sync();
                event.setCanceled(true);
                return;
            }
        }
        EntityLivingBase entityLivingBase = entity;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityLivingBase, (String)"entity");
        entityLivingBase.setHealth(1.0f);
        event.setCanceled(true);
    }

    @Nullable
    public static final String getFamiliarName(@NotNull EntityPlayer $this$familiarName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$familiarName, (String)"$this$familiarName");
        FamiliarInstance familiarInstance = WitcheryUtils.getExtension((EntityPlayer)$this$familiarName).familiar;
        return familiarInstance != null && (familiarInstance = familiarInstance.getData()) != null ? familiarInstance.getString("CustomName") : null;
    }

    @Nullable
    public static final Familiar<?> summonFamiliar(@NotNull EntityPlayer $this$summonFamiliar, double x, double y, double z) {
        FamiliarInstance instance;
        Intrinsics.checkParameterIsNotNull((Object)$this$summonFamiliar, (String)"$this$summonFamiliar");
        PlayerExtendedData playerEx = WitcheryUtils.getExtension($this$summonFamiliar);
        FamiliarInstance familiarInstance = instance = playerEx.familiar;
        if (familiarInstance != null) {
            if (!familiarInstance.isSummoned()) {
                FamiliarType<?> type = instance.getFamiliarType();
                Entity entity = EntityList.createEntityFromNBT((NBTTagCompound)instance.getData(), (World)$this$summonFamiliar.world);
                if (entity != null) {
                    entity.setLocationAndAngles(x, y, z, 0.0f, 0.0f);
                    Familiar<?> familiar = type.create(entity);
                    familiar.setColor(instance.getColor());
                    familiar.setFamiliarTamed(true);
                    familiar.setFamiliarOwnerId($this$summonFamiliar.getUniqueID());
                    familiar.setMaxHealth(50.0f);
                    $this$summonFamiliar.world.spawnEntity(familiar.getEntity());
                    $this$summonFamiliar.world.setEntityState(familiar.getEntity(), (byte)7);
                    instance.setSummoned(true);
                    familiar.getEntity().playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / $this$summonFamiliar.world.rand.nextFloat() * 0.4f + 0.8f);
                    return familiar;
                }
            }
        }
        return null;
    }

    static {
        boolean bl = false;
        FAMILIAR_ENTITIES = new HashMap();
    }
}

