/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.familiar;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.familiar.FamiliarInstance;
import net.msrandom.witchery.entity.familiar.FamiliarType;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0002\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0017J\b\u00108\u001a\u000205H\u0017J(\u0010\u0006\u001a\u0002052\u0006\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u0014H\u0017J\b\u0010=\u001a\u000205H\u0017J\u0010\u0010=\u001a\u0002052\u0006\u00106\u001a\u000207H\u0017J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0017J\u0014\u0010B\u001a\u0004\u0018\u00010C2\b\u0010D\u001a\u0004\u0018\u00010CH\u0017J\u0010\u0010E\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u000fH\u0017J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010H\u001a\u000207H\u0017J\u0010\u0010I\u001a\u0002052\u0006\u0010\u0004\u001a\u00020\u0014H\u0017J\u0012\u0010J\u001a\u0002052\b\u0010F\u001a\u0004\u0018\u00010KH\u0017J\u0010\u0010L\u001a\u0002052\u0006\u0010\u0004\u001a\u00020\u001dH\u0017J\u0010\u0010M\u001a\u0002052\u0006\u0010N\u001a\u00020\u0014H\u0017J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020,H\u0002R*\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058V@VX\u0097\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\b\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00148VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\b\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00028\u00008VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\b\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u001a\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R*\u0010#\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u001d8V@VX\u0097\u000e\u00a2\u0006\u0012\u0012\u0004\b$\u0010\b\u001a\u0004\b#\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010\b\u001a\u0004\b(\u0010%R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b-\u0010\b\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u000f8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010\b\u001a\u0004\b2\u00103\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006R"}, d2={"Lnet/msrandom/witchery/entity/familiar/Familiar;", "T", "Lnet/minecraft/entity/Entity;", "Lnet/minecraft/entity/IEntityOwnable;", "value", "Lnet/minecraft/item/EnumDyeColor;", "color", "color$annotations", "()V", "getColor", "()Lnet/minecraft/item/EnumDyeColor;", "setColor", "(Lnet/minecraft/item/EnumDyeColor;)V", "colorParameter", "Lnet/minecraft/network/datasync/DataParameter;", "", "colorParameter$annotations", "getColorParameter", "()Lnet/minecraft/network/datasync/DataParameter;", "defaultHealth", "", "defaultHealth$annotations", "getDefaultHealth", "()F", "entity", "entity$annotations", "getEntity", "()Lnet/minecraft/entity/Entity;", "familiarProperty", "", "getFamiliarProperty", "familiarType", "Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "getFamiliarType", "()Lnet/msrandom/witchery/entity/familiar/FamiliarType;", "isFamiliar", "isFamiliar$annotations", "()Z", "setFamiliar", "(Z)V", "isFamiliarSitting", "isFamiliarSitting$annotations", "names", "", "", "names$annotations", "getNames", "()[Ljava/lang/String;", "particleEffectId", "particleEffectId$annotations", "getParticleEffectId", "()B", "bindTo", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "clearFamiliar", "red", "green", "blue", "multiplier", "dismiss", "getFamiliarAttribute", "Lnet/minecraft/entity/ai/attributes/IAttributeInstance;", "attribute", "Lnet/minecraft/entity/ai/attributes/IAttribute;", "getFamiliarOwner", "Lnet/minecraft/entity/EntityLivingBase;", "default", "handleDismissParticles", "id", "isBoundTo", "boundEntity", "setFamiliarHealth", "setFamiliarOwnerId", "Ljava/util/UUID;", "setFamiliarTamed", "setMaxHealth", "maxHealth", "throwImplementationException", "", "name", "WitcheryResurrected"})
public interface Familiar<T extends Entity>
extends IEntityOwnable {
    default public boolean isFamiliar() {
        Object object = this.getEntity().getDataManager().get(this.getFamiliarProperty());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"entity.dataManager[familiarProperty]");
        return (Boolean)object;
    }

    default public void setFamiliar(boolean value) {
        this.getEntity().getDataManager().set(this.getFamiliarProperty(), (Object)value);
    }

    @NotNull
    default public EnumDyeColor getColor() {
        int n;
        DataParameter<Byte> dataParameter = this.getColorParameter();
        if (dataParameter != null) {
            DataParameter<Byte> dataParameter2 = dataParameter;
            boolean bl = false;
            boolean bl2 = false;
            DataParameter<Byte> it = dataParameter2;
            boolean bl3 = false;
            n = ((Number)this.getEntity().getDataManager().get(it)).byteValue();
        } else {
            n = 0;
        }
        EnumDyeColor enumDyeColor = EnumDyeColor.byMetadata((int)n);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumDyeColor, (String)"EnumDyeColor.byMetadata(\u2026nager[it].toInt() } ?: 0)");
        return enumDyeColor;
    }

    default public void setColor(@NotNull EnumDyeColor value) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            DataParameter<Byte> dataParameter = this.getColorParameter();
            if (dataParameter == null) break block0;
            DataParameter<Byte> dataParameter2 = dataParameter;
            boolean bl = false;
            boolean bl2 = false;
            DataParameter<Byte> it = dataParameter2;
            boolean bl3 = false;
            this.getEntity().getDataManager().set(it, (Object)((byte)value.getMetadata()));
        }
    }

    @JvmDefault
    default public void setMaxHealth(float maxHealth) {
        this.setFamiliar(true);
        IAttribute iAttribute = SharedMonsterAttributes.MAX_HEALTH;
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttribute, (String)"SharedMonsterAttributes.MAX_HEALTH");
        this.getFamiliarAttribute(iAttribute).setBaseValue((double)maxHealth);
        this.setFamiliarHealth(maxHealth);
    }

    @JvmDefault
    default public void clearFamiliar() {
        this.setFamiliar(false);
        IAttribute iAttribute = SharedMonsterAttributes.MAX_HEALTH;
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttribute, (String)"SharedMonsterAttributes.MAX_HEALTH");
        this.getFamiliarAttribute(iAttribute).setBaseValue(10.0);
        this.setFamiliarHealth(this.getDefaultHealth());
    }

    default public float getDefaultHealth() {
        return 10.0f;
    }

    @Nullable
    public FamiliarType<T> getFamiliarType();

    @NotNull
    public DataParameter<Boolean> getFamiliarProperty();

    @Nullable
    default public DataParameter<Byte> getColorParameter() {
        return null;
    }

    @Nullable
    default public String[] getNames() {
        return null;
    }

    @JvmDefault
    @Nullable
    default public EntityLivingBase getFamiliarOwner(@Nullable EntityLivingBase entityLivingBase) {
        if (this.isFamiliar() && !((Entity)this.getEntity()).world.isRemote) {
            EntityPlayerMP entityPlayerMP;
            UUID uUID = this.getOwnerId();
            if (uUID != null) {
                UUID uUID2 = uUID;
                boolean bl = false;
                boolean bl2 = false;
                UUID id = uUID2;
                boolean bl3 = false;
                World world = ((Entity)this.getEntity()).world;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"entity.world");
                Object object = world.getMinecraftServer();
                if (object != null && (object = object.getPlayerList()) != null && (object = object.getPlayers()) != null) {
                    Object v5;
                    block6: {
                        Iterable $this$firstOrNull$iv = (Iterable)object;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            EntityPlayerMP it = (EntityPlayerMP)element$iv;
                            boolean bl4 = false;
                            EntityPlayerMP entityPlayerMP2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerMP2, (String)"it");
                            GameProfile gameProfile = entityPlayerMP2.getGameProfile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)gameProfile, (String)"it.gameProfile");
                            if (!Intrinsics.areEqual((Object)gameProfile.getId(), (Object)id)) continue;
                            v5 = element$iv;
                            break block6;
                        }
                        v5 = null;
                    }
                    entityPlayerMP = v5;
                } else {
                    entityPlayerMP = null;
                }
            } else {
                entityPlayerMP = null;
            }
            return (EntityLivingBase)entityPlayerMP;
        }
        return entityLivingBase;
    }

    @NotNull
    default public T getEntity() {
        Familiar familiar = this;
        if (familiar == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        return (T)((Entity)familiar);
    }

    @JvmDefault
    default public void bindTo(@NotNull EntityPlayer player) {
        Object name2;
        boolean bl;
        Object object;
        block9: {
            Object object2;
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
                Familiar<?> familiar = Familiars.getBoundFamiliar(player);
                if (familiar != null) {
                    familiar.clearFamiliar();
                }
                if ((object2 = this.getNames()) == null) break block8;
                object = object2;
                bl = false;
                boolean bl2 = false;
                String[] it = object;
                boolean bl3 = false;
                object2 = it[player.getRNG().nextInt(it.length)];
                if (object2 != null) break block9;
            }
            object2 = name2 = "Familiar";
        }
        if (!this.getEntity().hasCustomName()) {
            object = (CharSequence)name2;
            bl = false;
            if (object.length() > 0) {
                this.getEntity().setCustomNameTag((String)name2);
            }
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        FamiliarType<T> type = this.getFamiliarType();
        Class<? extends Entity> key = FamiliarType.REGISTRY.getKey(type);
        if (type == null || key == null) {
            playerEx.familiar = null;
        } else {
            NBTTagCompound tag = this.getEntity().writeToNBT(new NBTTagCompound());
            tag.setString("id", String.valueOf(EntityList.getKey(this.getEntity())));
            NBTTagCompound nBTTagCompound = tag;
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"tag");
            playerEx.familiar = new FamiliarInstance(type, key, nBTTagCompound, this.getColor(), true);
        }
        playerEx.sync();
        this.setMaxHealth(50.0f);
    }

    @JvmDefault
    default public void dismiss(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.dismiss();
        if (this.isBoundTo(player)) {
            player.world.setEntityState(this.getEntity(), this.getParticleEffectId());
            WitcheryUtils.getExtension(player).sync();
        }
    }

    @JvmDefault
    default public void dismiss() {
        block2: {
            Entity entity = this.getOwner();
            if (entity == null) break block2;
            Entity entity2 = entity;
            boolean bl = false;
            boolean bl2 = false;
            Entity it = entity2;
            boolean bl3 = false;
            if (it instanceof EntityPlayer && this.isBoundTo((EntityPlayer)it)) {
                this.getEntity().playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / ((Entity)this.getEntity()).world.rand.nextFloat() * 0.4f + 0.8f);
                this.getEntity().setDead();
                PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)it);
                FamiliarInstance instance = playerEx.familiar;
                if (instance != null) {
                    instance.setSummoned(false);
                    instance.setColor(this.getColor());
                    instance.getData().setString("id", String.valueOf(EntityList.getKey(this.getEntity())));
                    this.getEntity().writeToNBT(instance.getData());
                }
            }
        }
    }

    @JvmDefault
    default public boolean isBoundTo(@NotNull EntityPlayer boundEntity) {
        Intrinsics.checkParameterIsNotNull((Object)boundEntity, (String)"boundEntity");
        return Intrinsics.areEqual((Object)Familiars.getFamiliarId(boundEntity), (Object)this.getEntity().getUniqueID());
    }

    @JvmDefault
    @SideOnly(value=Side.CLIENT)
    default public void color(float red, float green, float blue, float multiplier) {
        int c = this.getColor().getColorValue();
        float r = (float)(c >>> 16 & 0xFF) / 255.0f;
        float g = (float)(c >>> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GlStateManager.color((float)(r * multiplier + red), (float)(g * multiplier + green), (float)(b * multiplier + blue));
    }

    @JvmDefault
    @SideOnly(value=Side.CLIENT)
    default public boolean handleDismissParticles(byte id) {
        if (id == this.getParticleEffectId()) {
            int n = 20;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                ((Entity)this.getEntity()).world.spawnParticle(EnumParticleTypes.SPELL_INSTANT, ((Entity)this.getEntity()).posX + ((Entity)this.getEntity()).world.rand.nextDouble() * (double)2 - 1.0, ((Entity)this.getEntity()).posY + ((Entity)this.getEntity()).world.rand.nextDouble(), ((Entity)this.getEntity()).posZ + (double)(((Entity)this.getEntity()).world.rand.nextFloat() * (float)2) - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
            return true;
        }
        return false;
    }

    default public byte getParticleEffectId() {
        return 64;
    }

    default public boolean isFamiliarSitting() {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityTameable)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "isFamiliarSitting");
            throw null;
        }
        return ((EntityTameable)it).isSitting();
    }

    @JvmDefault
    default public void setFamiliarHealth(float value) {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityLivingBase)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "setFamiliarHealth");
            throw null;
        }
        ((EntityLivingBase)it).setHealth(value);
    }

    @JvmDefault
    @NotNull
    default public IAttributeInstance getFamiliarAttribute(@NotNull IAttribute attribute) {
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityLivingBase)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "getFamiliarAttribute");
            throw null;
        }
        IAttributeInstance iAttributeInstance = ((EntityLivingBase)it).getEntityAttribute(attribute);
        Intrinsics.checkExpressionValueIsNotNull((Object)iAttributeInstance, (String)"it.getEntityAttribute(attribute)");
        return iAttributeInstance;
    }

    @JvmDefault
    default public void setFamiliarTamed(boolean value) {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityTameable)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "setFamiliarTamed");
            throw null;
        }
        ((EntityTameable)it).setTamed(value);
    }

    @JvmDefault
    default public void setFamiliarOwnerId(@Nullable UUID id) {
        T t = this.getEntity();
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        if (!(it instanceof EntityTameable)) {
            Void void_ = DefaultImpls.throwImplementationException(this, "setFamiliarOwnerId");
            throw null;
        }
        ((EntityTameable)it).setOwnerId(id);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @JvmDefault
        public static /* synthetic */ void isFamiliar$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void color$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void defaultHealth$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void colorParameter$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void names$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void entity$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void particleEffectId$annotations() {
        }

        @JvmDefault
        public static /* synthetic */ void isFamiliarSitting$annotations() {
        }

        private static <T extends Entity> Void throwImplementationException(Familiar<T> $this, String name2) {
            throw (Throwable)new IllegalStateException(name2 + " is not implemented in " + Reflection.getOrCreateKotlinClass($this.getClass()).getSimpleName());
        }
    }
}

