/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class EntityAIZombieMateNow
extends EntityAIBase {
    private final EntityZombie zombieObj;
    private final World world;
    private EntityZombie mate;
    private int matingTimeout;
    private boolean mating;
    private boolean begin;

    public EntityAIZombieMateNow(EntityZombie zombie) {
        this.zombieObj = zombie;
        this.world = zombie.world;
        this.setMutexBits(3);
    }

    public void beginMating() {
        this.begin = true;
    }

    public boolean shouldExecute() {
        if (!this.begin) {
            return false;
        }
        EntityZombie zombie = (EntityZombie)this.world.findNearestEntityWithinAABB(EntityZombie.class, this.zombieObj.getEntityBoundingBox().expand(8.0, 3.0, 8.0), (Entity)this.zombieObj);
        if (zombie == null || zombie.isChild()) {
            return false;
        }
        this.mate = zombie;
        return true;
    }

    public void startExecuting() {
        this.matingTimeout = 600;
        this.mating = true;
        this.begin = false;
    }

    public void resetTask() {
        this.mate = null;
        this.mating = false;
        this.begin = false;
    }

    public boolean shouldContinueExecuting() {
        return this.matingTimeout >= 0;
    }

    public void updateTask() {
        --this.matingTimeout;
        this.zombieObj.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, 30.0f);
        if (this.zombieObj.getDistanceSq((Entity)this.mate) > 2.25) {
            this.zombieObj.getNavigator().tryMoveToEntityLiving((Entity)this.mate, 1.4);
        } else if (this.matingTimeout == 0 && this.mating) {
            this.giveBirth();
        }
    }

    private void giveBirth() {
        EntityZombieVillager zombieVillager;
        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(this.mate.posX, this.mate.posY, this.mate.posZ, 1.0f, 2.0f, EnumParticleTypes.HEART), (Entity)this.mate);
        if (!(this.zombieObj instanceof EntityZombieVillager)) {
            zombieVillager = new EntityZombieVillager(this.world);
            zombieVillager.setLocationAndAngles(this.zombieObj.posX, this.zombieObj.posY, this.zombieObj.posZ, 0.0f, 0.0f);
            zombieVillager.onInitialSpawn(this.world.getDifficultyForLocation(zombieVillager.getPosition()), null);
            this.world.removeEntity((Entity)this.zombieObj);
            this.world.spawnEntity((Entity)zombieVillager);
        }
        if (!(this.mate instanceof EntityZombieVillager)) {
            zombieVillager = new EntityZombieVillager(this.world);
            zombieVillager.setLocationAndAngles(this.mate.posX, this.mate.posY, this.mate.posZ, 0.0f, 0.0f);
            zombieVillager.onInitialSpawn(this.world.getDifficultyForLocation(zombieVillager.getPosition()), null);
            this.world.removeEntity((Entity)this.mate);
            this.world.spawnEntity((Entity)zombieVillager);
        }
        EntityZombie baby = new EntityZombie(this.world);
        baby.setLocationAndAngles(this.mate.posX, this.mate.posY, this.mate.posZ, 0.0f, 0.0f);
        baby.setChild(true);
        this.world.spawnEntity((Entity)baby);
    }
}

