/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.Vec3d;
import net.msrandom.witchery.entity.EntityImp;

public class EntityAIWanderWithRestriction
extends EntityAIBase {
    private final EntityImp imp;
    private final double speed;
    private double xPosition;
    private double yPosition;
    private double zPosition;

    public EntityAIWanderWithRestriction(EntityImp imp, double speed) {
        this.imp = imp;
        this.speed = speed;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        if (this.imp.getIdleTime() >= 100) {
            return false;
        }
        if (this.imp.getRNG().nextInt(120) != 0) {
            return false;
        }
        Vec3d vec3 = RandomPositionGenerator.findRandomTarget((EntityCreature)this.imp, (int)10, (int)7);
        if (vec3 == null) {
            return false;
        }
        if (this.imp.getHomePos().distanceSq(vec3.x, vec3.y, vec3.z) > 256.0) {
            return false;
        }
        this.xPosition = vec3.x;
        this.yPosition = vec3.y;
        this.zPosition = vec3.z;
        return true;
    }

    public boolean shouldContinueExecuting() {
        return !this.imp.getNavigator().noPath();
    }

    public void startExecuting() {
        this.imp.getNavigator().tryMoveToXYZ(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }
}

