/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAIToadSit
extends EntityAIBase {
    private final EntityTameable theOcelot;
    private final double speed;
    private int currentTick;
    private int distance;
    private int maxSittingTicks;
    private int sitableBlockX;
    private int sitableBlockY;
    private int sitableBlockZ;

    public EntityAIToadSit(EntityTameable par1EntityOcelot, double par2) {
        this.theOcelot = par1EntityOcelot;
        this.speed = par2;
        this.setMutexBits(5);
    }

    public boolean shouldExecute() {
        return !this.theOcelot.isSitting() && this.theOcelot.getRNG().nextDouble() <= (double)0.0065f && this.getNearbySitableBlockDistance();
    }

    public boolean shouldContinueExecuting() {
        return this.currentTick <= this.maxSittingTicks && this.distance <= 60 && this.isSittableBlock(this.theOcelot.world, new BlockPos(this.sitableBlockX, this.sitableBlockY, this.sitableBlockZ));
    }

    public void startExecuting() {
        this.theOcelot.getNavigator().tryMoveToXYZ((double)this.sitableBlockX + 0.5, (double)(this.sitableBlockY + 1), (double)this.sitableBlockZ + 0.5, this.speed);
        this.currentTick = 0;
        this.distance = 0;
        this.maxSittingTicks = this.theOcelot.getRNG().nextInt(this.theOcelot.getRNG().nextInt(1200) + 1200) + 1200;
    }

    public void resetTask() {
        this.theOcelot.setSitting(false);
    }

    public void updateTask() {
        ++this.currentTick;
        this.theOcelot.getAISit().setSitting(false);
        if (this.theOcelot.getDistanceSq((double)this.sitableBlockX, (double)(this.sitableBlockY + 1), (double)this.sitableBlockZ) > 1.0) {
            this.theOcelot.setSitting(false);
            this.theOcelot.getNavigator().tryMoveToXYZ((double)this.sitableBlockX + 0.5, (double)(this.sitableBlockY + 1), (double)this.sitableBlockZ + 0.5, this.speed);
            ++this.distance;
        } else if (!this.theOcelot.isSitting()) {
            this.theOcelot.setSitting(true);
        } else {
            --this.distance;
        }
    }

    protected boolean getNearbySitableBlockDistance() {
        int i = (int)this.theOcelot.posY;
        double d0 = 4.147483647E9;
        int j = (int)this.theOcelot.posX - 8;
        while ((double)j < this.theOcelot.posX + 8.0) {
            int k = (int)this.theOcelot.posZ - 8;
            while ((double)k < this.theOcelot.posZ + 8.0) {
                int y = i - 2;
                while ((double)y < (double)i + 3.0) {
                    double d2;
                    BlockPos pos = new BlockPos(j, y, k);
                    if (this.isSittableBlock(this.theOcelot.world, pos) && this.theOcelot.world.isAirBlock(pos) && (d2 = this.theOcelot.getDistanceSq(pos)) < d0) {
                        this.sitableBlockX = j;
                        this.sitableBlockY = y;
                        this.sitableBlockZ = k;
                        d0 = d2;
                    }
                    ++y;
                }
                ++k;
            }
            ++j;
        }
        return d0 < 2.147483647E9;
    }

    protected boolean isSittableBlock(World par1World, BlockPos pos) {
        return par1World.getBlockState(pos).getBlock() == Blocks.WATERLILY;
    }
}

