/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.player.EntityPlayer;

public class EntityAITemptWithPlayer
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final double speed;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private EntityAITasks.EntityAITaskEntry avoidWater;

    public EntityAITemptWithPlayer(EntityCreature par1EntityCreature, double par2) {
        this.temptedEntity = par1EntityCreature;
        this.speed = par2;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.world.getClosestPlayerToEntity((Entity)this.temptedEntity, 10.0);
        return this.temptingPlayer != null;
    }

    public boolean shouldContinueExecuting() {
        return this.shouldExecute();
    }

    public void startExecuting() {
        double targetX = this.temptingPlayer.posX;
        double targetY = this.temptingPlayer.posY;
        double targetZ = this.temptingPlayer.posZ;
        this.isRunning = true;
        this.avoidWater = this.temptedEntity.tasks.taskEntries.stream().filter(v -> v.action instanceof EntityAIWanderAvoidWater).findAny().orElse(null);
        if (this.avoidWater != null) {
            this.temptedEntity.tasks.removeTask(this.avoidWater.action);
        }
    }

    public void resetTask() {
        this.temptingPlayer = null;
        this.temptedEntity.getNavigator().clearPath();
        this.delayTemptCounter = 100;
        this.isRunning = false;
        if (this.avoidWater != null) {
            this.temptedEntity.tasks.addTask(this.avoidWater.priority, this.avoidWater.action);
        }
    }

    public void updateTask() {
        this.temptedEntity.getLookHelper().setLookPositionWithEntity((Entity)this.temptingPlayer, 30.0f, (float)this.temptedEntity.getVerticalFaceSpeed());
        if (this.temptedEntity.getDistanceSq((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.getNavigator().clearPath();
        } else {
            this.temptedEntity.getNavigator().tryMoveToEntityLiving((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

