/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.init.WitcheryDataExtensions;

public class EntityAISleep
extends EntityAIBase {
    private final EntityVillager villager;
    private final World world;
    Village village;

    public EntityAISleep(EntityVillager villager) {
        int insidePosX = -1;
        int insidePosZ = -1;
        this.villager = villager;
        this.world = villager.world;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        int z;
        int x;
        int k;
        int j;
        long time = this.world.getWorldTime() % 24000L;
        if (time < 13000L || time >= 23999L || this.villager.hurtTime > 0) {
            return false;
        }
        if (this.villager.getRNG().nextInt(50) != 0) {
            return false;
        }
        int i = MathHelper.floor((double)this.villager.posX);
        BlockPos pos = new BlockPos(i, j = MathHelper.floor((double)this.villager.posY), k = MathHelper.floor((double)this.villager.posZ));
        Village village = this.world.villageCollection.getNearestVillage(pos, 14);
        if (village == null) {
            return false;
        }
        if (this.villager.world.canSeeSky(pos)) {
            return false;
        }
        int count = 0;
        for (x = i - 1; x <= i + 1; ++x) {
            for (z = k - 1; z <= k + 1; ++z) {
                if (this.villager.world.canSeeSky(new BlockPos(x, j, z)) || !this.villager.world.getBlockState(new BlockPos(x, j + 1, z)).getMaterial().isReplaceable()) continue;
                ++count;
            }
        }
        if (count < 4) {
            return false;
        }
        count = 0;
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                if (this.world.getBlockState(new BlockPos(x + i, j - 1, z + k)).getMaterial().isReplaceable()) continue;
                ++count;
            }
        }
        return count >= 6;
    }

    public void startExecuting() {
        VillagerExtendedData ext = WitcheryDataExtensions.VILLAGER.get(this.villager);
        if (ext != null) {
            ext.setSleeping(true);
        }
    }

    public void resetTask() {
        this.village = null;
        VillagerExtendedData ext = WitcheryDataExtensions.VILLAGER.get(this.villager);
        if (ext != null) {
            ext.setSleeping(false);
        }
    }

    public boolean shouldContinueExecuting() {
        long time = this.world.getWorldTime() % 24000L;
        return time > 13000L && time < 23999L && this.villager.hurtTime == 0;
    }

    public void updateTask() {
        VillagerExtendedData ext = WitcheryDataExtensions.VILLAGER.get(this.villager);
        if (ext != null) {
            ext.incrementSleepingTicks();
        }
    }
}

