/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.math.AxisAlignedBB;
import net.msrandom.witchery.entity.EntityGoblin;

public class EntityAIPickUpBlocks
extends EntityAIBase {
    protected final EntityGoblin entity;
    protected final double range;

    public EntityAIPickUpBlocks(EntityGoblin entity, double range) {
        this.entity = entity;
        this.range = range;
        this.setMutexBits(7);
    }

    public boolean shouldExecute() {
        return this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItemMainhand().isEmpty() && this.entity.getLeashed() && this.isItemInReachableDistance();
    }

    public void startExecuting() {
        AxisAlignedBB bb = new AxisAlignedBB(this.entity.posX - this.range, this.entity.posY - this.range, this.entity.posZ - this.range, this.entity.posX + this.range, this.entity.posY + this.range, this.entity.posZ + this.range);
        List items = this.entity.world.getEntitiesWithinAABB(EntityItem.class, bb);
        double SPEED = 0.6;
        for (EntityItem item : items) {
            if (!this.entity.getNavigator().tryMoveToEntityLiving((Entity)item, SPEED)) continue;
            break;
        }
    }

    public boolean shouldContinueExecuting() {
        return this.entity != null && !this.entity.isWorshipping() && this.entity.getHeldItemMainhand().isEmpty() && this.entity.getLeashed() && this.isItemInReachableDistance();
    }

    public void updateTask() {
        if (this.entity.getNavigator().noPath()) {
            AxisAlignedBB bb = new AxisAlignedBB(this.entity.posX - this.range, this.entity.posY - this.range, this.entity.posZ - this.range, this.entity.posX + this.range, this.entity.posY + this.range, this.entity.posZ + this.range);
            List items = this.entity.world.getEntitiesWithinAABB(EntityItem.class, bb);
            double SPEED = 0.6;
            for (EntityItem item : items) {
                if (!this.entity.getNavigator().tryMoveToEntityLiving((Entity)item, SPEED)) continue;
                break;
            }
        } else {
            double PICKUP_RANGE = 1.5;
            AxisAlignedBB bb2 = new AxisAlignedBB(this.entity.posX - PICKUP_RANGE, this.entity.posY - PICKUP_RANGE, this.entity.posZ - PICKUP_RANGE, this.entity.posX + PICKUP_RANGE, this.entity.posY + PICKUP_RANGE, this.entity.posZ + PICKUP_RANGE);
            List items2 = this.entity.world.getEntitiesWithinAABB(EntityItem.class, bb2);
            if (!items2.isEmpty()) {
                this.entity.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, ((EntityItem)items2.get(0)).getItem());
                if (!this.entity.world.isRemote) {
                    ((EntityItem)items2.get(0)).setDead();
                }
            }
        }
    }

    protected boolean isItemInReachableDistance() {
        AxisAlignedBB bb = new AxisAlignedBB(this.entity.posX - this.range, this.entity.posY - this.range, this.entity.posZ - this.range, this.entity.posX + this.range, this.entity.posY + this.range, this.entity.posZ + this.range);
        List items = this.entity.world.getEntitiesWithinAABB(EntityItem.class, bb);
        double SPEED = 0.1;
        for (EntityItem item : items) {
            if (this.entity.getNavigator().getPathToEntityLiving((Entity)item) == null) continue;
            return true;
        }
        return false;
    }
}

