/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityAIMoveTowardsVampire
extends EntityAIBase {
    private final EntityCreature theEntity;
    private final double speed;
    private final float maxTargetDistance;
    private final float minTargetDistance;
    private EntityLivingBase targetEntity;
    private double movePosX;
    private double movePosY;
    private double movePosZ;

    public EntityAIMoveTowardsVampire(EntityCreature par1EntityCreature, double par2, float min, float max) {
        this.theEntity = par1EntityCreature;
        this.speed = par2;
        this.minTargetDistance = min;
        this.maxTargetDistance = max;
        this.setMutexBits(1);
    }

    private EntityLivingBase getDistanceSqToPartner() {
        double R = this.maxTargetDistance;
        AxisAlignedBB bb = new AxisAlignedBB(this.theEntity.posX - R, this.theEntity.posY - R, this.theEntity.posZ - R, this.theEntity.posX + R, this.theEntity.posY + R, this.theEntity.posZ + R);
        List mogs = this.theEntity.world.getEntitiesWithinAABB(EntityPlayer.class, bb);
        double minDistance = Double.MAX_VALUE;
        EntityPlayer target = null;
        for (EntityPlayer player : mogs) {
            double distance;
            if (WitcheryUtils.getExtension(player).getTransformation(WitcheryTransformations.VAMPIRE).getLevel() < 8 || (distance = this.theEntity.getDistanceSq((Entity)player)) >= minDistance) continue;
            minDistance = distance;
            target = player;
        }
        return target;
    }

    public boolean shouldExecute() {
        this.targetEntity = this.getDistanceSqToPartner();
        if (this.targetEntity == null) {
            return false;
        }
        double dist = this.targetEntity.getDistanceSq((Entity)this.theEntity);
        return dist <= (double)(this.maxTargetDistance * this.maxTargetDistance) && dist >= (double)(this.minTargetDistance * this.minTargetDistance);
    }

    public boolean shouldContinueExecuting() {
        if (this.theEntity.ticksExisted % 20 == 0) {
            this.theEntity.getNavigator().tryMoveToXYZ(this.targetEntity.posX, this.targetEntity.posY, this.targetEntity.posZ, this.speed);
        }
        return true;
    }

    public void resetTask() {
        this.targetEntity = null;
    }

    public void startExecuting() {
        this.theEntity.getNavigator().tryMoveToXYZ(this.targetEntity.posX, this.targetEntity.posY, this.targetEntity.posZ, this.speed);
    }
}

