/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class EntityAIMoveTowardsEntityClass
extends EntityAIBase {
    private final EntityCreature theEntity;
    private final Class<? extends EntityLiving> targetType;
    private final double speed;
    private final float maxTargetDistance;
    private final float minTargetDistance;
    private EntityLivingBase targetEntity;
    private double movePosX;
    private double movePosY;
    private double movePosZ;

    public EntityAIMoveTowardsEntityClass(EntityCreature par1EntityCreature, Class<? extends EntityLiving> targetType, double par2, float par4, float par5) {
        this.theEntity = par1EntityCreature;
        this.targetType = targetType;
        this.speed = par2;
        this.minTargetDistance = par4;
        this.maxTargetDistance = par5;
        this.setMutexBits(1);
    }

    private EntityLiving getDistanceSqToPartner() {
        double R = this.maxTargetDistance;
        AxisAlignedBB bb = new AxisAlignedBB(this.theEntity.posX - R, this.theEntity.posY - R, this.theEntity.posZ - R, this.theEntity.posX + R, this.theEntity.posY + R, this.theEntity.posZ + R);
        List mogs = this.theEntity.world.getEntitiesWithinAABB(this.targetType, bb);
        double minDistance = Double.MAX_VALUE;
        EntityLiving target = null;
        for (EntityLiving mog : mogs) {
            double distance = this.theEntity.getDistanceSq((Entity)mog);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            target = mog;
        }
        return target;
    }

    public boolean shouldExecute() {
        if (this.theEntity.world.rand.nextInt(20) != 0) {
            return false;
        }
        this.targetEntity = this.getDistanceSqToPartner();
        if (this.targetEntity == null) {
            return false;
        }
        double dist = this.targetEntity.getDistanceSq((Entity)this.theEntity);
        if (dist > (double)(this.maxTargetDistance * this.maxTargetDistance)) {
            return false;
        }
        if (dist < (double)(this.minTargetDistance * this.minTargetDistance)) {
            return false;
        }
        Vec3d vec3 = RandomPositionGenerator.findRandomTargetBlockTowards((EntityCreature)this.theEntity, (int)16, (int)7, (Vec3d)this.targetEntity.getPositionVector());
        if (vec3 == null) {
            return false;
        }
        this.movePosX = vec3.x;
        this.movePosY = vec3.y;
        this.movePosZ = vec3.z;
        return true;
    }

    public boolean shouldContinueExecuting() {
        return !this.theEntity.getNavigator().noPath() && this.targetEntity.isEntityAlive() && this.targetEntity.getDistanceSq((Entity)this.theEntity) < (double)(this.maxTargetDistance * this.maxTargetDistance);
    }

    public void resetTask() {
        this.targetEntity = null;
    }

    public void startExecuting() {
        this.theEntity.getNavigator().tryMoveToXYZ(this.movePosX, this.movePosY, this.movePosZ, this.speed);
    }
}

