/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class EntityAIMateWithPlayer
extends EntityAIBase {
    private final EntityVillager villager;
    private final World world;
    private EntityPlayer mate;
    private int matingTimeout;
    private boolean forceExecute;

    public EntityAIMateWithPlayer(EntityVillager villager) {
        this.villager = villager;
        this.world = villager.world;
        this.setMutexBits(3);
    }

    public void forceTask(EntityPlayer player) {
        this.forceExecute = true;
        this.mate = player;
    }

    public boolean shouldExecute() {
        if (this.villager.getGrowingAge() != 0) {
            return false;
        }
        if (!this.forceExecute && this.villager.getRNG().nextInt(500) != 0) {
            return false;
        }
        if (this.forceExecute) {
            this.forceExecute = false;
            return true;
        }
        Entity entity = this.world.findNearestEntityWithinAABB(EntityPlayer.class, this.villager.getEntityBoundingBox().expand(16.0, 3.0, 16.0), (Entity)this.villager);
        if (entity == null) {
            return false;
        }
        this.mate = (EntityPlayer)entity;
        return true;
    }

    public void startExecuting() {
        this.matingTimeout = 1000;
        this.villager.setMating(true);
    }

    public void resetTask() {
        this.mate = null;
        this.villager.setMating(false);
    }

    public boolean shouldContinueExecuting() {
        return this.matingTimeout >= 0 && this.villager.getGrowingAge() == 0;
    }

    public void updateTask() {
        if (this.matingTimeout > 0) {
            --this.matingTimeout;
        }
        this.villager.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, 30.0f);
        if (this.villager.getDistanceSq((Entity)this.mate) > 2.25) {
            this.villager.getNavigator().tryMoveToEntityLiving((Entity)this.mate, 0.3);
        } else if (this.matingTimeout > 0 && this.villager.getDistanceSq((Entity)this.mate) <= 2.25) {
            this.matingTimeout = 0;
            this.giveBirth();
        }
        if (this.villager.getRNG().nextInt(20) == 0) {
            this.world.setEntityState((Entity)this.villager, (byte)12);
        }
    }

    private void giveBirth() {
        EntityVillager entityvillager = this.villager.createChild((EntityAgeable)this.villager);
        this.villager.setGrowingAge(6000);
        entityvillager.setGrowingAge(-24000);
        entityvillager.setLocationAndAngles(this.villager.posX, this.villager.posY, this.villager.posZ, 0.0f, 0.0f);
        this.world.spawnEntity((Entity)entityvillager);
        this.world.setEntityState((Entity)entityvillager, (byte)12);
    }
}

